package money;

import junit.framework.*;

public class MoneyBagTest extends TestCase {
  private Money f12UKP;
  private Money f14UKP;
  private Money f7USD;
  private Money f21USD;

  private IMoney fMB1;
  private IMoney fMB2;

  public MoneyBagTest(String name) {
     super(name);
  }
  public static void main(String args[]) {
     //junit.textui.TestRunner.run(MoneyBagTest.class);
     junit.swingui.TestRunner.run(MoneyBagTest.class);
  }
  protected void setUp() {
    f12UKP= new Money(12, "UKP");
    f14UKP= new Money(14, "UKP");
    f7USD= new Money( 7, "USD");
    f21USD= new Money(21, "USD");

    fMB1= MoneyBag.make(f12UKP, f7USD);
    fMB2= MoneyBag.make(f14UKP, f21USD);
  }

  public void testSimpleEquals() {
    assert (!f12UKP.equals(null));
    assertEquals(f12UKP, f12UKP);
    assertEquals(f12UKP, new Money(12,"UKP"));
    assert(!f12UKP.equals(f14UKP));
  }


  public void testString() {
    assertEquals(fMB1.toString(),"{[7 USD][12 UKP]}");
  }

  public void testNegate() {
    // {[12 UKP][7 USD]} negate == {[-12 UKP][-7 USD]}
    Money bag[]= { new Money(-12, "UKP"), new Money(-7, "USD") };
    IMoney expected= MoneyBag.make(bag);
    assertEquals(expected, fMB1.negate());
  }
  public void testAdd() {
    // {[12 UKP][7 USD]} + [14 UKP] == {[26 UKP][7 USD]}
    Money bag[]= { new Money(26, "UKP"), new Money(7, "USD") };
    IMoney expected= MoneyBag.make(bag);
    assertEquals(expected,f14UKP.add(fMB1));
    assertEquals(expected, fMB1.add(f14UKP));
  }

  public void testSubtract() {
    // {[12 UKP][7 USD]} - {[14 UKP][21 USD] == {[-2 UKP][-14 USD]}
    Money bag[]= { new Money(-2, "UKP"), new Money(-14, "USD") };
    IMoney expected= MoneyBag.make(bag);
    assertEquals(expected, fMB1.subtract(fMB2));
  }

  public void testBagAdd() {
    // {[12 UKP][7 USD]} + {[14 UKP][21 USD]} == {[26 UKP][28 USD]}
    Money bag[]= { new Money(26, "UKP"), new Money(28, "USD") };
    IMoney expected= MoneyBag.make(bag);
    assertEquals(expected, fMB1.add(fMB2));
  }

  public void testIsZero() {
    assert(fMB1.subtract(fMB1).isZero());
    Money bag[] = { new Money (0, "UKP"), new Money (0, "USD") };
    assert(MoneyBag.make(bag).isZero());
  }

  public void testMixedAdd() {
    // [12 UKP] + [7 USD] == {[12 UKP][7 USD]}
    Money bag[]= { f12UKP, f7USD };
    IMoney expected= MoneyBag.make(bag);
    assertEquals(expected, f12UKP.add(f7USD));
  }

  public void testEquals() {
    IMoney equal= MoneyBag.make(new Money(12, "UKP"), new Money(7, "USD"));
    assert(fMB1.equals(equal));
    assert(!fMB1.equals(f12UKP));
    assert(!fMB1.equals(f7USD));
    assert(!f12UKP.equals(fMB1));
    assert(!fMB1.equals(fMB2));
  }


  public void testUniformRep() {
    IMoney mm = MoneyBag.make(f12UKP,f14UKP);
    IMoney sum = f12UKP.add(f14UKP);
    assertEquals(mm,sum);
  }

}

