package money;

import junit.framework.*;

public class MoneyTest extends TestCase {

   public MoneyTest(String name) {
      super(name);
   }

   /**
    * TestRunner.run uses introspection
    * to find all the test methods
    * these must be public & begin with "test"
    */
    public static void main(String args[]) {
       //junit.textui.TestRunner.run(MoneyTest.class);
       junit.swingui.TestRunner.run(MoneyTest.class);
    }

    private Money f12UKP,f14UKP;

    /**
     * setUP constructs the context for the tests
     */
    protected void setUp() {
       f12UKP= new Money(12, "UKP");
       f14UKP= new Money(14, "UKP");
    }

    public void testEquals() {
       assert(!f12UKP.equals(null));
       assert(!f12UKP.equals(f14UKP));
       assertEquals(f12UKP,new Money(12,"UKP"));
    }

    public void testAdd() {
       assertEquals(f12UKP.add(f14UKP),new Money(26,"UKP"));
    }

    public void testNegate() {
      assertEquals(f12UKP.negate(),new Money(-12,"UKP"));
    }

    public void testSub() {
      assertEquals(f12UKP.subtract(f14UKP),new Money(-2,"UKP"));
      assert((f12UKP.subtract(new Money(12,"UKP"))).isZero());
    }

    public void testString() {
       assertEquals(f12UKP.toString(),"[12 UKP]");
    }

}