package factory;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class FactoryFrame extends JFrame {
  JPanel contentPane;
  BorderLayout borderLayout1 = new BorderLayout();
  JPanel jPanel1 = new JPanel();
  JButton make = new JButton();
  JButton clear = new JButton();
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextArea jTextArea1 = new JTextArea();
  JComboBox jComboBox1 = new JComboBox();

  /**Construct the frame*/
  public FactoryFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  /**Component initialization*/
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(FactoryFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.getContentPane().setBackground(Color.lightGray);
    this.setSize(new Dimension(400, 300));
    this.setTitle("Factory Example");
    make.setText("Make");
    make.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        makeAction(e);
      }
    });
    clear.setText("Clear");
    clear.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        clearAction(e);
      }
    });
    jPanel1.setBackground(Color.red);
    contentPane.setBackground(Color.white);
    jTextArea1.setText("");
    jTextArea1.setEditable(false);
    jTextArea1.setFont(new java.awt.Font("SansSerif", 1, 18));
    jComboBox1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        selectMeal(e);
      }
    });
    contentPane.add(jPanel1, BorderLayout.SOUTH);
    jPanel1.add(make, null);
    jPanel1.add(clear, null);
    jPanel1.add(jComboBox1, null);
    jComboBox1.addItem("Vegan");
    jComboBox1.addItem("Carnivore");
    jComboBox1.addItem("Omnivore");
    contentPane.add(jScrollPane1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(jTextArea1, null);
  }
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  Meal oftheday = new Meal();

  void makeAction(ActionEvent e) {
     jTextArea1.append(oftheday.toString());
  }

  void clearAction(ActionEvent e) {
     jTextArea1.setText("");
  }

  void selectMeal(ActionEvent e) {
      String s = (String)jComboBox1.getSelectedItem();
      oftheday.setMeal(s);
  }

}