package chain;

interface Chain {
  public void send(String msg);
}

class Filter implements Chain {
   Chain next;
   String match;
   Filter(String s, Chain c) {match=s; next = c;}

   public void send(String msg) {
    if (next!=null) {
      if (!msg.equals(match)) next.send(msg);
    }
   }
}

class Gen {
  Gen(Chain c) {
    c.send("Design");
    c.send("Patterns");
    c.send("are");
    c.send("not");
    c.send("very");
    c.send("difficult");
  }
}

class Printer implements Chain {
  public void send(String msg) {
            System.out.println(msg);
  }
}

public class MainChain {

  public static void main (String [] args ) {
    new Gen(
      new Filter("very",
        new Filter("not",
          new Printer())));
  }
}


