package composite;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.Iterator;

public class CompositeFrame extends JFrame {
  JPanel contentPane;
  BorderLayout borderLayout1 = new BorderLayout();
  JSplitPane jSplitPane1 = new JSplitPane();
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextArea jTextArea1 = new JTextArea();
  JTree jTree1;

  /**Construct the frame*/
  public CompositeFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  /**Component initialization*/
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(CompositeFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(579, 360));
    this.setTitle("Composite Example");
    jSplitPane1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    jScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    jTextArea1.setEditable(false);
    jTextArea1.setFont(new java.awt.Font("Dialog", 1, 18));
    jTree1 = new JTree(new DefaultTreeModel(makeTree(fileTree())));
    jTree1.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
      public void valueChanged(TreeSelectionEvent e) {
        printNode(e);
      }
    });
    jTree1.setFont(new java.awt.Font("Monospaced", 1, 18));
    contentPane.add(jSplitPane1, BorderLayout.CENTER);
    jSplitPane1.add(jScrollPane1, JSplitPane.BOTTOM);
    jSplitPane1.add(jTree1, JSplitPane.TOP);
    jScrollPane1.getViewport().add(jTextArea1, null);
    jSplitPane1.setDividerLocation(200);
  }
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  void printNode(TreeSelectionEvent e) {
    Dentry d = (Dentry)
                ((DefaultMutableTreeNode)
                  e.getPath().getLastPathComponent()
                ).getUserObject();
    jTextArea1.append(d.pathName()+"["+d.size()+"]\n");
  }

  private Directory fileTree() {
        Directory root = new Directory("Food");
	Directory parent;

	parent = new Directory("Vegetable");
	root.add(parent);
	parent.add(new File("carrot",100));
	parent.add(new File("parsnip",100));
	parent.add(new File("lettuce",100));
	parent.add(new File("radish",100));

	parent = new Directory("Meat");
	root.add(parent);
	parent.add(new File("lamb",101));
	parent.add(new File("beef",102));
	parent.add(new File("kangaroo",103));
	parent.add(new File("pork",104));

	parent = new Directory("Fruit");
	root.add(parent);
        Directory temp = new Directory("apple");
        temp.add(new File("red",55));
        temp.add(new File("green",55));
	parent.add(temp);
	parent.add(new File("pear",120));
	parent.add(new File("orange",130));
	parent.add(new File("bananas",140));
        return root;
    }

    private DefaultMutableTreeNode makeTree(Dentry root) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(root);
        Iterator I = root.getEntries();
        if (I!=null)
        while(I.hasNext()) {
           Dentry leaf = (Dentry)I.next();
           parent.add(makeTree(leaf));
        }
        return parent;
    }

}