package composite;

import java.util.*;

abstract class Dentry {

  protected String name;

  public Dentry(String s) {
    name = s;
  }

  public String toString() {
    return name;
  }

  public abstract int size();

  public void add(Dentry c) {}

  public void remove(Dentry c){}

  public Iterator getEntries() {
    return null;
  }

  public String pathName() {
    /*
    * provide an implementation for this
    */
    return ".";
   }

  protected void setParent(Dentry p) {
     /* provide implemetation here */
  }
}


class Directory extends Dentry {

  /* something needed here */

  Directory(String name) {
    super(name);
  }

  public int size() {
    /*
    * provide an implementation here
    */
    return 0;
  }

  public void add(Dentry c)
    { /* implementation*/ }

  public void remove(Dentry c)
    { /* implementation*/}

  public Iterator getEntries()
    { /* implementation*/
      return null ;
    }

}


class File extends Dentry {

    private int fsize;

    public File(String name, int s) {
          super(name);
          fsize = s;
    }

    public int size() { return fsize; }


}
