package iterator;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Iterator;

public class IteratorFrame extends JFrame {
  JPanel contentPane;
  BorderLayout borderLayout1 = new BorderLayout();
  JTextArea jTextArea1 = new JTextArea();
  JPanel jPanel1 = new JPanel();
  JButton add = new JButton();
  JTextField entry = new JTextField();
  JButton remove = new JButton();

  /**Construct the frame*/
  public IteratorFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  /**Component initialization*/
  private void jbInit() throws Exception  {
    jTextArea1.setEditable(false);
    jTextArea1.setFont(new java.awt.Font("Dialog", 1, 18));
    //setIconImage(Toolkit.getDefaultToolkit().createImage(IteratorFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("Iterator Example");
    add.setText("add");
    add.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        addTest(e);
      }
    });
    entry.setMinimumSize(new Dimension(4, 100));
    entry.setPreferredSize(new Dimension(100, 21));
    remove.setText("remove");
    remove.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        removeTest(e);
      }
    });
    contentPane.add(jTextArea1, BorderLayout.CENTER);
    contentPane.add(jPanel1, BorderLayout.SOUTH);
    jPanel1.add(add, null);
    jPanel1.add(entry, null);
    jPanel1.add(remove, null);
  }
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  /*
  * this code uses the MyList iterator implementation
  */

  MyList items = new MyList();

  void display() {
     jTextArea1.setText("");
     Iterator I = items.iterator();
     while (I.hasNext()) {
        jTextArea1.append(((String)I.next())+"\n");
     }
  }

  void addTest(ActionEvent e) {
     String s = entry.getText();
     if (!s.equals("")) {
       items.add(s);
       entry.setText("");
       display();
     }
  }

  void removeTest(ActionEvent e) {
     String s = entry.getText();
     if (!s.equals("")) {
       items.remove(s);
       entry.setText("");
       display();
     }

  }
}