package engine;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class StateFrame extends JFrame {
  JPanel contentPane;
  BorderLayout borderLayout1 = new BorderLayout();
  JSplitPane jSplitPane1 = new JSplitPane();
  JScrollPane jScrollPane1 = new JScrollPane();
  JPanel jPanel1 = new JPanel();
  JTextArea jTextArea1 = new JTextArea();
  BorderLayout borderLayout2 = new BorderLayout();
  JPanel jPanel2 = new JPanel();
  JButton start = new JButton();
  JButton stop = new JButton();
  JLabel jLabel1 = new JLabel();
  JPanel jPanel3 = new JPanel();
  Component component1;
  JTextField jTextField1 = new JTextField();

  /**Construct the frame*/
  public StateFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
      initObserver();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  /**Component initialization*/
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(StateFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    component1 = Box.createVerticalStrut(150);
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(400, 300));
    this.setTitle("State + Observer pattern example");
    jTextArea1.setFont(new java.awt.Font("Dialog", 1, 16));
    jPanel1.setLayout(borderLayout2);
    start.setBackground(Color.green);
    start.setFont(new java.awt.Font("Dialog", 1, 14));
    start.setText("start");
    start.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        startAction(e);
      }
    });
    stop.setBackground(Color.red);
    stop.setFont(new java.awt.Font("Dialog", 1, 14));
    stop.setText("stop");
    stop.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        stopAction(e);
      }
    });
    jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
    jLabel1.setText("Observer:");
    jPanel3.setLayout(new FlowLayout());
    jTextField1.setFont(new java.awt.Font("SansSerif", 1, 18));
    jTextField1.setPreferredSize(new Dimension(160, 28));
    contentPane.add(jSplitPane1, BorderLayout.CENTER);
    jSplitPane1.add(jScrollPane1, JSplitPane.TOP);
    jScrollPane1.getViewport().add(jTextArea1, null);
    jSplitPane1.add(jPanel1, JSplitPane.BOTTOM);
    jPanel1.add(jPanel2, BorderLayout.SOUTH);
    jPanel2.add(start, null);
    jPanel2.add(stop, null);
    jPanel1.add(jLabel1, BorderLayout.NORTH);
    jPanel1.add(jPanel3, BorderLayout.CENTER);
    jPanel3.add(jTextField1, null);
    jPanel3.add(component1, null);
    jSplitPane1.setDividerLocation(200);
  }
  /**Overridden so we can exit when window is closed*/
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  /*
  * application specific actions
  */

  Engine eng = new Engine();

  private void initObserver() {
     eng.attach(new ObserverField(jTextField1));
  }

  void stopAction(ActionEvent e) {
     eng.stop();
     jTextArea1.append("Engine is "+eng.printState()+"\n");
  }

  void startAction(ActionEvent e) {
     eng.start();
     jTextArea1.append("Engine is "+eng.printState()+"\n");
  }
}