package money;
import java.util.*;

/**
* Implements a bag of multiple currencies
* delays conversions
*/
class MoneyBag implements IMoney {

  private Map bag = new HashMap(5);

  private MoneyBag() {
  }

  /**
   * factory methods that return a MoneyBag or Money
   * object depending on whether arguments can be simplified
   */
  public static IMoney make(Money ar[]) {
    return (new MoneyBag(ar)).simplify();
  }

  public static IMoney make(IMoney m1, IMoney m2) {
    return m1.add(m2);
  }

  private MoneyBag(Money ar[]) {
    for (int i= 0; i < ar.length; i++) {
      if (!ar[i].isZero())
          insertMoney(ar[i]);
    }
  }

  MoneyBag(Money m1, Money m2) { //Used by SimpleMoney
    insertMoney(m1);
    insertMoney(m2);
  }

  private MoneyBag(Money m, MoneyBag mm) {
    insertMoney(m);
    insertMoney(mm);
  }

  private MoneyBag(MoneyBag m1, MoneyBag m2) {
    insertMoney(m1);
    insertMoney(m2);
  }

  public IMoney add(IMoney m) {
    return m.addMoneyBag(this);
  }

  public IMoney addMoney(Money m) {
    return (new MoneyBag(m, this)).simplify();
  }
  public IMoney addMoneyBag(MoneyBag s) {
     return (new MoneyBag(s, this)).simplify();
  }

  private void insertMoney(Money m) {
     if (m.isZero()) return;
     Money sm = (Money)bag.get(m.currency());
     if (sm==null) {bag.put(m.currency(),m); return;}
     bag.remove(sm.currency());
     IMoney sum = sm.addMoney(m);
     if (!sum.isZero())
            bag.put(((Money)sum).currency(),sum);
  }

  private void insertMoney(MoneyBag mm) {
     for (Iterator i= (mm.bag.values()).iterator(); i.hasNext(); ) {
      insertMoney((Money)i.next());
     }
  }

  private IMoney simplify() {
    if (bag.size()==1) {
      Iterator i = (bag.values()).iterator();
      return (IMoney)i.next();
    }
    return this;
  }

  /**
  * Subtract money from this
  */
  public IMoney subtract(IMoney m) {
     return add(m.negate());
  }

  /**
  * negate money
  */
  public IMoney negate() {
    MoneyBag result =new MoneyBag();
    Iterator i = (bag.values()).iterator();
    while (i.hasNext()) {
       IMoney m = ((IMoney)i.next()).negate();
       result.bag.put(((Money)m).currency(),m);
    }
    return  result;
  }

  /**
  * amount is zero
  */
  public boolean isZero() {
    return bag.size()==0;
  }

  public boolean equals(Object o) {
    if (!(o instanceof IMoney)) return false;
    if (isZero() && ((IMoney)o).isZero()) return true;
    return subtract((IMoney)o).isZero();
  }

  public int hashCode() {
    int hash= 0;
    for (Iterator i= bag.values().iterator(); i.hasNext(); ) {
    Object m= i.next();
            hash^= m.hashCode();
    }
    return hash;
  }

  public String toString() {
    StringBuffer buffer = new StringBuffer();
    buffer.append("{");
    for (Iterator i= bag.values().iterator(); i.hasNext(); )
        buffer.append((Money) i.next());
    buffer.append("}");
    return buffer.toString();
  }

}