/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.spoofax.DebugUtil;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.StackTracer;
import org.spoofax.interpreter.core.StrategoSignature;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.library.java.JFFLibrary;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Match;
import org.spoofax.interpreter.stratego.OpDecl;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements IContext {
    public static int indentation = 0;
    private final StackTracer stackTracer;
    private final ITermFactory programFactory;
    private final Map<String, IOperatorRegistry> operatorRegistries;
    private final Map<String, OpDecl> opdecls;
    private final StrategoSignature strategoSignature;
    private ITermFactory factory;
    private IStrategoTerm current;
    private VarScope varScope;
    private volatile transient boolean asyncCancelled;

    public Context(ITermFactory factory, ITermFactory programFactory) {
        this(factory, programFactory, false);
    }

    public Context(ITermFactory factory, ITermFactory programFactory, boolean skipStandardLibraries) {
        this.programFactory = programFactory;
        this.factory = factory;
        this.stackTracer = new StackTracer();
        this.opdecls = new HashMap<String, OpDecl>();
        this.varScope = new VarScope(null);
        this.strategoSignature = new StrategoSignature(programFactory);
        this.operatorRegistries = new LinkedHashMap<String, IOperatorRegistry>();
        if (!skipStandardLibraries) {
            this.addOperatorRegistry(new SSLLibrary());
            this.addOperatorRegistry(new JFFLibrary(factory));
            this.stackTracer.setIOAgent(this.getIOAgent());
        }
    }

    @Override
    public IStrategoTerm current() {
        return this.current;
    }

    @Override
    public void setCurrent(IStrategoTerm term) {
        this.current = term;
    }

    @Override
    public StackTracer getStackTracer() {
        return this.stackTracer;
    }

    public IOAgent getIOAgent() {
        SSLLibrary op = (SSLLibrary)this.getOperatorRegistry("SSL");
        return op == null ? null : op.getIOAgent();
    }

    public void setIOAgent(IOAgent ioAgent) {
        SSLLibrary op = (SSLLibrary)this.getOperatorRegistry("SSL");
        if (op == null) {
            throw new IllegalStateException("No SSL library");
        }
        op.setIOAgent(ioAgent);
    }

    public static void debug(Object ... s) {
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(DebugUtil.buildIndent(indentation), s);
        }
    }

    @Override
    public IStrategoTerm lookupVar(String n) throws InterpreterException {
        return this.varScope.lookup(n);
    }

    @Override
    public SDefT lookupSVar(String n) throws InterpreterException {
        return this.varScope.lookupSVar(n);
    }

    @Override
    public ITermFactory getFactory() {
        if (this.asyncCancelled) {
            this.cancel();
        }
        return this.factory;
    }

    @Override
    public void setFactory(ITermFactory factory) {
        this.factory = factory;
    }

    @Override
    public boolean bindVars(Match.Results r) {
        int i = 0;
        while (i < r.size()) {
            Match.Binding x = (Match.Binding)r.get(i);
            VarScope s = this.varScope.scopeOf((String)x.first);
            if (s == null) {
                this.varScope.add((String)x.first, (IStrategoTerm)x.second);
            } else if (s.hasVarInLocalScope((String)x.first)) {
                IStrategoTerm t = s.lookup((String)x.first);
                if (!t.equals(x.second)) {
                    if (DebugUtil.isDebugging()) {
                        Context.debug(" no bind : ", x.first, " already bound to ", t, ", new: ", x.second);
                    }
                    return false;
                }
            } else {
                s.add((String)x.first, (IStrategoTerm)x.second);
            }
            ++i;
        }
        return true;
    }

    @Override
    public VarScope getVarScope() {
        return this.varScope;
    }

    @Override
    public void setVarScope(VarScope newVarScope) {
        assert (newVarScope != null);
        this.varScope = newVarScope;
    }

    @Override
    public void popVarScope() {
        this.setVarScope(this.varScope.getParent());
    }

    @Override
    public void restoreVarScope(VarScope anotherVarScope) {
        this.varScope = anotherVarScope;
    }

    void addOpDecl(String name, OpDecl decl) {
        this.opdecls.put(name, decl);
    }

    public void addSVar(String name, SDefT def) {
        this.varScope.addSVar(name, def);
    }

    @Override
    public StrategoSignature getStrategoSignature() {
        return this.strategoSignature;
    }

    public ITermFactory getProgramFactory() {
        return this.programFactory;
    }

    @Override
    public IOperatorRegistry getOperatorRegistry(String domain) {
        return this.operatorRegistries.get(domain);
    }

    @Override
    public AbstractPrimitive lookupOperator(String name) {
        if (this.asyncCancelled) {
            this.cancel();
        }
        for (IOperatorRegistry or : this.operatorRegistries.values()) {
            AbstractPrimitive t = or.get(name);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Deprecated
    public void addOperatorRegistry(String domain, IOperatorRegistry or) {
        this.operatorRegistries.put(domain, or);
    }

    @Override
    public void addOperatorRegistry(IOperatorRegistry or) {
        this.operatorRegistries.put(or.getOperatorRegistryName(), or);
    }

    @Override
    public Collection<String> getStrategyNames() {
        VarScope v = this.getVarScope();
        while (v.getParent() != null) {
            v = v.getParent();
        }
        HashSet<String> r = new HashSet<String>();
        for (SDefT s : v.getStrategyDefinitions()) {
            r.add(s.getName());
        }
        return r;
    }

    @Override
    public void asyncCancel() {
        this.asyncCancelled = true;
    }

    @Override
    public void asyncCancelReset() {
        this.asyncCancelled = false;
    }

    private void cancel() {
        this.asyncCancelled = false;
        this.getIOAgent().closeAllFiles();
        throw new CancellationException("Stratego interpreter cancelled");
    }
}

