/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.spoofax.DebugUtil;
import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Pair;
import org.spoofax.interpreter.core.StrategoSignature;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.All;
import org.spoofax.interpreter.stratego.Build;
import org.spoofax.interpreter.stratego.CallT;
import org.spoofax.interpreter.stratego.ExtSDef;
import org.spoofax.interpreter.stratego.Fail;
import org.spoofax.interpreter.stratego.GuardedLChoice;
import org.spoofax.interpreter.stratego.Id;
import org.spoofax.interpreter.stratego.ImportTerm;
import org.spoofax.interpreter.stratego.Let;
import org.spoofax.interpreter.stratego.Match;
import org.spoofax.interpreter.stratego.One;
import org.spoofax.interpreter.stratego.OpDecl;
import org.spoofax.interpreter.stratego.PrimT;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.stratego.Scope;
import org.spoofax.interpreter.stratego.Seq;
import org.spoofax.interpreter.stratego.Some;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.io.binary.TermReader;

public class StrategoCoreLoader {
    private Context context;

    StrategoCoreLoader(Context context) {
        this.context = context;
    }

    private ExtSDef parseExtSDef(IStrategoAppl t) {
        String name = Tools.javaStringAt(t, 0);
        IStrategoList svars = Tools.listAt(t, 1);
        IStrategoList tvars = Tools.listAt(t, 2);
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug("name  : ", name);
        }
        SDefT.SVar[] realsvars = this.makeSVars(svars);
        String[] realtvars = this.makeVars(tvars);
        VarScope oldScope = this.context.getVarScope();
        VarScope newScope = new VarScope(oldScope);
        return new ExtSDef(name, realsvars, realtvars, newScope);
    }

    private Strategy parseStrategy(IStrategoAppl appl) throws InterpreterException {
        StrategoSignature sign;
        IStrategoConstructor ctor = appl.getConstructor();
        if (ctor.equals((sign = this.context.getStrategoSignature()).getBuild())) {
            return this.parseBuild(appl);
        }
        if (ctor.equals(sign.getScope())) {
            return this.parseScope(appl);
        }
        if (ctor.equals(sign.getSeq())) {
            return this.parseSeq(appl);
        }
        if (ctor.equals(sign.getGuardedLChoice())) {
            return this.parseGuardedLChoice(appl);
        }
        if (ctor.equals(sign.getMatch())) {
            return this.parseMatch(appl);
        }
        if (ctor.equals(sign.getId())) {
            return this.parseId(appl);
        }
        if (ctor.equals(sign.getCallT())) {
            return this.parseCallT(appl);
        }
        if (ctor.equals(sign.getPrimT())) {
            return this.parsePrimT(appl);
        }
        if (ctor.equals(sign.getLet())) {
            return this.parseLet(appl);
        }
        if (ctor.equals(sign.getFail())) {
            return this.makeFail(appl);
        }
        if (ctor.equals(sign.getId())) {
            return this.makeId(appl);
        }
        if (ctor.equals(sign.getAll())) {
            return this.makeAll(appl);
        }
        if (ctor.equals(sign.getOne())) {
            return this.makeOne(appl);
        }
        if (ctor.equals(sign.getSome())) {
            return this.makeSome(appl);
        }
        if (ctor.equals(sign.getImportTerm())) {
            return this.makeImportTerm(appl);
        }
        throw new InterpreterException("Unknown op '" + ctor + "'");
    }

    private Strategy makeImportTerm(IStrategoAppl appl) {
        IStrategoString str = Tools.stringAt(appl, 0);
        return new ImportTerm(str.stringValue());
    }

    private Strategy makeId(IStrategoAppl appl) {
        return new Id();
    }

    private Some makeSome(IStrategoAppl t) throws InterpreterException {
        Strategy body = this.parseStrategy(Tools.applAt(t, 0));
        return new Some(body);
    }

    private One makeOne(IStrategoAppl t) throws InterpreterException {
        Strategy body = this.parseStrategy(Tools.applAt(t, 0));
        return new One(body);
    }

    private All makeAll(IStrategoAppl t) throws InterpreterException {
        Strategy body = this.parseStrategy(Tools.applAt(t, 0));
        return new All(body);
    }

    private Strategy makeFail(IStrategoAppl appl) {
        return new Fail();
    }

    private Let parseLet(IStrategoAppl t) throws InterpreterException {
        IStrategoTerm[] l = Tools.listAt(t, 0).getAllSubterms();
        SDefT[] defs = new SDefT[l.length];
        int i = 0;
        while (i < l.length) {
            defs[i] = this.parseSDefT((IStrategoAppl)l[i]);
            ++i;
        }
        Strategy body = this.parseStrategy(Tools.applAt(t, 1));
        return new Let(defs, body);
    }

    public SDefT parseSDefT(IStrategoAppl t) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug("parseSDefT()");
        }
        String name = Tools.javaStringAt(t, 0);
        IStrategoList svars = Tools.listAt(t, 1);
        IStrategoList tvars = Tools.listAt(t, 2);
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" name  : ", name);
        }
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" svars : ", svars);
        }
        SDefT.SVar[] realsvars = this.makeSVars(svars);
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" svars : ", realsvars);
        }
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" tvars : ", tvars);
        }
        String[] realtvars = this.makeVars(tvars);
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" tvars : ", realtvars);
        }
        VarScope newScope = new VarScope(this.context.getVarScope());
        this.context.setVarScope(newScope);
        Strategy body = this.parseStrategy(Tools.applAt(t, 3));
        this.context.popVarScope();
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" +name: ", name);
        }
        return new SDefT(name, realsvars, realtvars, body, newScope);
    }

    private String[] makeVars(IStrategoList svars) {
        IStrategoTerm[] sv = svars.getAllSubterms();
        String[] realsvars = new String[sv.length];
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" vars  : ", svars);
        }
        int j = 0;
        while (j < svars.size()) {
            realsvars[j] = Tools.javaStringAt(sv[j], 0);
            ++j;
        }
        return realsvars;
    }

    private SDefT.SVar[] makeSVars(IStrategoList svars) {
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug("makeSVars()");
        }
        IStrategoTerm[] sv = svars.getAllSubterms();
        SDefT.SVar[] realsvars = new SDefT.SVar[sv.length];
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" vars  : ", svars);
        }
        int j = 0;
        while (j < sv.length) {
            IStrategoAppl t = (IStrategoAppl)sv[j];
            SDefT.ArgType type = this.parseArgType(Tools.applAt(t, 1));
            String name = Tools.javaStringAt(t, 0);
            realsvars[j] = new SDefT.SVar(name, type);
            ++j;
        }
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug("       : ", realsvars);
        }
        return realsvars;
    }

    private SDefT.ArgType parseArgType(IStrategoAppl t) {
        if (Tools.isFunType(t, this.context)) {
            IStrategoList l = Tools.listAt(t, 0);
            ArrayList<SDefT.ArgType> ch = new ArrayList<SDefT.ArgType>();
            int i = 0;
            while (i < l.size()) {
                ch.add(this.parseArgType(Tools.applAt(l, i)));
                ++i;
            }
            return new SDefT.FunType(ch);
        }
        if (Tools.isConstType(t, this.context)) {
            return new SDefT.ConstType();
        }
        return null;
    }

    private PrimT parsePrimT(IStrategoAppl t) throws InterpreterException {
        String name = Tools.javaStringAt(t, 0);
        Strategy[] svars = this.parseStrategyList(Tools.listAt(t, 1));
        IStrategoTerm[] tvars = this.parseTermList(Tools.listAt(t, 2));
        return new PrimT(name, svars, tvars);
    }

    private Strategy parseCallT(IStrategoAppl t) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug("parseCallT()");
        }
        String name = Tools.javaStringAt(Tools.applAt(t, 0), 0);
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" name  : ", name);
        }
        IStrategoList svars = Tools.listAt(t, 1);
        Strategy[] realsvars = this.parseStrategyList(svars);
        IStrategoTerm[] realtvars = this.parseTermList(Tools.listAt(t, 2));
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" -svars : ", realsvars);
        }
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(" -tvars : ", realtvars);
        }
        return new CallT(name, realsvars, realtvars);
    }

    private IStrategoTerm[] parseTermList(IStrategoList tvars) {
        return tvars.getAllSubterms();
    }

    private Strategy[] parseStrategyList(IStrategoList svars) throws InterpreterException {
        IStrategoTerm[] sv = svars.getAllSubterms();
        Strategy[] v = new Strategy[sv.length];
        int i = 0;
        while (i < sv.length) {
            v[i] = this.parseStrategy((IStrategoAppl)sv[i]);
            ++i;
        }
        return v;
    }

    private Id parseId(IStrategoAppl t) {
        return new Id();
    }

    private Match parseMatch(IStrategoAppl t) {
        IStrategoAppl u = Tools.applAt(t, 0);
        return new Match(u);
    }

    private GuardedLChoice parseGuardedLChoice(IStrategoAppl t) throws InterpreterException {
        LinkedList<Pair<Strategy, Strategy>> s = new LinkedList<Pair<Strategy, Strategy>>();
        IStrategoConstructor ctor = this.context.getStrategoSignature().getGuardedLChoice();
        while (t.getConstructor().equals(ctor)) {
            s.add(new Pair<Strategy, Strategy>(this.parseStrategy(Tools.applAt(t, 0)), this.parseStrategy(Tools.applAt(t, 1))));
            t = Tools.applAt(t, 2);
        }
        s.add(new Pair<Strategy, Object>(this.parseStrategy(t), null));
        return new GuardedLChoice(s.toArray(new Pair[0]));
    }

    private Seq parseSeq(IStrategoAppl t) throws InterpreterException {
        LinkedList<Strategy> s = new LinkedList<Strategy>();
        StrategoSignature sign = this.context.getStrategoSignature();
        while (t.getConstructor().equals(sign.getSeq())) {
            s.add(this.parseStrategy(Tools.applAt(t, 0)));
            t = Tools.applAt(t, 1);
        }
        s.add(this.parseStrategy(t));
        return new Seq(s.toArray(new Strategy[0]));
    }

    private Scope parseScope(IStrategoAppl t) throws InterpreterException {
        IStrategoList vars = Tools.listAt(t, 0);
        ArrayList<String> realvars = new ArrayList<String>(vars.size());
        int i = 0;
        while (i < vars.size()) {
            realvars.add(Tools.javaStringAt(vars, i));
            ++i;
        }
        Strategy body = this.parseStrategy(Tools.applAt(t, 1));
        return new Scope(realvars, body);
    }

    private Build parseBuild(IStrategoAppl t) {
        IStrategoAppl u = Tools.applAt(t, 0);
        return new Build(u);
    }

    @Deprecated
    public void load(String path) throws IOException, InterpreterException {
        this.doLoad(new TermReader(this.context.getProgramFactory()).parseFromFile(path));
    }

    public void load(IStrategoTerm prg) throws InterpreterException {
        this.doLoad(prg);
    }

    private void doLoad(IStrategoTerm prg) throws InterpreterException {
        IStrategoAppl sign = Tools.applAt(Tools.listAt(prg, 0), 0);
        IStrategoAppl strats = Tools.applAt(Tools.listAt(prg, 0), 1);
        if (DebugUtil.isDebugging()) {
            DebugUtil.debug(prg);
        }
        this.loadConstructors(Tools.listAt(Tools.applAt(Tools.listAt(sign, 0), 0), 0));
        this.loadStrategies(Tools.listAt(strats, 0));
    }

    private void loadConstructors(IStrategoList list) {
        int i = 0;
        while (i < list.size()) {
            if (!Tools.applAt(list, i).getConstructor().getName().equals("OpDeclInj") && !Tools.applAt(list, i).getConstructor().getName().equals("ExtOpDeclInj")) {
                String name = Tools.javaStringAt(Tools.applAt(list, i), 0);
                this.context.addOpDecl(name, new OpDecl(name));
            }
            ++i;
        }
    }

    private void loadStrategies(IStrategoList list) throws InterpreterException {
        int i = 0;
        while (i < list.size()) {
            SDefT def;
            IStrategoAppl t = Tools.applAt(list, i);
            if (Tools.isSDefT(t, this.context)) {
                def = this.parseSDefT(t);
                this.context.addSVar(def.getName(), def);
            } else if (Tools.isExtSDef(t, this.context)) {
                def = this.parseExtSDef(t);
                this.context.addSVar(def.getName(), def);
                throw new InterpreterException("Illegal ExtSDef in StrategoCore file");
            }
            ++i;
        }
    }

    @Deprecated
    public void load(InputStream stream) throws InterpreterException, IOException {
        if (stream == null) {
            throw new IOException("Could not load Stratego core input from null stream");
        }
        this.doLoad(new TermReader(this.context.getProgramFactory()).parseFromStream(stream));
    }
}

