/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.language.SemanticIndexEntry;
import org.spoofax.interpreter.library.language.SemanticIndexEntryFactory;
import org.spoofax.interpreter.library.language.SemanticIndexEntryParent;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticIndex {
    private final Map<SemanticIndexEntry, SemanticIndexEntry> table = new HashMap<SemanticIndexEntry, SemanticIndexEntry>();
    private final Map<URI, Set<SemanticIndexEntry>> fileTable = new HashMap<URI, Set<SemanticIndexEntry>>();
    private IOAgent agent;
    private ITermFactory termFactory;
    private SemanticIndexEntryFactory factory;
    private SemanticIndexEntry entryTemplate;

    public void initialize(ITermFactory factory, IOAgent agent) {
        this.agent = agent;
        this.factory = new SemanticIndexEntryFactory(factory);
        this.termFactory = factory;
        this.entryTemplate = new SemanticIndexEntry(factory.makeConstructor("template", 0), factory.makeList(), factory.makeList(), null, null);
    }

    public void ensureInitialized() {
        if (this.factory == null) {
            throw new IllegalStateException("Semantic index not initialized");
        }
    }

    public SemanticIndexEntryFactory getFactory() {
        return this.factory;
    }

    public void add(IStrategoAppl entry, URI file) {
        this.ensureInitialized();
        IStrategoTerm type = this.factory.getEntryType(entry);
        IStrategoList id = this.factory.getEntryId(entry);
        IStrategoTerm namespace = this.factory.getEntryNamespace(entry);
        IStrategoTerm data = this.factory.getEntryData(entry);
        SemanticIndexEntryParent parent = this.getEntryParentAbove(namespace, id, true);
        this.add(this.factory.createEntry(type, namespace, id, data, parent, file), parent);
    }

    public void add(SemanticIndexEntry entry) {
        this.ensureInitialized();
        this.add(entry, this.getEntryParentAbove(entry.getNamespace(), entry.getId(), true));
    }

    private void add(SemanticIndexEntry entry, SemanticIndexEntryParent parent) {
        SemanticIndexEntry existing;
        if (parent != null) {
            parent.add(entry);
        }
        if ((existing = this.table.get(entry)) == null) {
            this.table.put(entry, entry);
            if (entry.getFile() != null) {
                this.getFileSet(entry.getFile()).add(entry);
            }
        } else {
            assert (!entry.isParent());
            existing.addToTail(entry);
            if (entry.getFile() != null) {
                this.getFileSet(entry.getFile()).add(existing);
            }
        }
    }

    public void remove(SemanticIndexEntry entry) {
        URI file;
        SemanticIndexEntry head;
        List<SemanticIndexEntry> tail = entry.getTail();
        if (!tail.isEmpty()) {
            head = tail.remove(tail.size() - 1);
            head.setTail(tail);
            this.table.put(head, head);
        } else {
            head = this.table.get(entry);
            if (head != entry) {
                tail = head.getTail();
                int i = 0;
                int max2 = tail.size();
                while (i < max2) {
                    if (tail.get(i) == entry) {
                        tail.remove(i);
                        break;
                    }
                    ++i;
                }
            } else {
                this.table.remove(entry);
            }
        }
        boolean otherEntriesExist = head != entry;
        SemanticIndexEntryParent parent = this.getEntryParentAbove(entry.getNamespace(), entry.getId(), false);
        if (parent != null) {
            if (!otherEntriesExist) {
                parent.remove(entry);
                if (parent.isEmpty()) {
                    this.remove(parent);
                }
            } else {
                parent.add(head);
            }
        }
        if ((file = entry.getFile()) != null) {
            Set<SemanticIndexEntry> fileSet = this.getFileSet(file);
            if (otherEntriesExist && this.isFileReferenced(head, tail, file)) {
                fileSet.add(head);
            } else {
                fileSet.remove(entry);
                if (fileSet.isEmpty()) {
                    this.fileTable.remove(file);
                }
            }
        }
    }

    private boolean isFileReferenced(SemanticIndexEntry head, List<SemanticIndexEntry> tail, URI file) {
        if (file.equals(head.getFile())) {
            return true;
        }
        int i = 0;
        int max2 = tail.size();
        while (i < max2) {
            if (file.equals(tail.get(i).getFile())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Set<SemanticIndexEntry> getFileSet(URI file) {
        Set<SemanticIndexEntry> result = this.fileTable.get(file);
        if (result == null) {
            result = new HashSet<SemanticIndexEntry>();
            this.fileTable.put(file, result);
        }
        return result;
    }

    public IStrategoList getTerms(IStrategoAppl template) {
        IStrategoList results = this.termFactory.makeList();
        SemanticIndexEntry entry = this.getEntry(template);
        if (entry == null) {
            return results;
        }
        IStrategoAppl result = entry.toTerm(this.factory);
        results = this.termFactory.makeListCons(result, results);
        List<SemanticIndexEntry> tail = entry.getTail();
        int i = 0;
        int max2 = tail.size();
        while (i < max2) {
            result = tail.get(i).toTerm(this.factory);
            results = this.termFactory.makeListCons(result, results);
            ++i;
        }
        return results;
    }

    public SemanticIndexEntry getEntry(IStrategoAppl template) {
        this.ensureInitialized();
        return this.getEntry(this.factory.getEntryType(template), this.factory.getEntryNamespace(template), this.factory.getEntryId(template), this.factory.getEntryData(template) != null);
    }

    private SemanticIndexEntry getEntry(IStrategoTerm type, IStrategoTerm namespace, IStrategoList id, boolean isDataEntry) {
        this.entryTemplate.internalReinit(type, namespace, id, isDataEntry ? this.factory.getDefDataCon() : null);
        return this.table.get(this.entryTemplate);
    }

    public IStrategoList getEntryChildTerms(IStrategoAppl template) {
        this.ensureInitialized();
        IStrategoTerm type = this.factory.getEntryType(template);
        IStrategoTerm namespace = this.factory.getEntryNamespace(template);
        SemanticIndexEntryParent parent = this.getEntryParentAt(namespace, this.factory.getEntryId(template));
        if (parent == null) {
            return this.termFactory.makeList();
        }
        if (type == this.factory.getDefCon() && parent.getAllDefsCached() != null) {
            return parent.getAllDefsCached();
        }
        IStrategoList results = this.termFactory.makeList();
        for (SemanticIndexEntry entry : parent.getChildren()) {
            if (entry.getType() != type) continue;
            assert (!entry.isParent());
            assert (entry.getNamespace().match(namespace));
            results = this.termFactory.makeListCons(entry.toTerm(this.factory), results);
        }
        if (type == this.factory.getDefCon()) {
            parent.setAllDefsCached(results);
        }
        return results;
    }

    public IStrategoList getEntryDescendantTerms(IStrategoAppl template) {
        this.ensureInitialized();
        IStrategoTerm type = this.factory.getEntryType(template);
        IStrategoTerm namespace = this.factory.getEntryNamespace(template);
        SemanticIndexEntryParent parent = this.getEntryParentAt(namespace, this.factory.getEntryId(template));
        return this.collectEntryDescendentTerms(parent, type, namespace, this.termFactory.makeList());
    }

    private IStrategoList collectEntryDescendentTerms(SemanticIndexEntryParent parent, IStrategoTerm type, IStrategoTerm namespace, IStrategoList results) {
        for (SemanticIndexEntry entry : parent.getChildren()) {
            if (entry.getType() == type) {
                assert (!entry.isParent());
                assert (entry.getNamespace().match(namespace));
                results = this.termFactory.makeListCons(entry.toTerm(this.factory), results);
                continue;
            }
            if (!entry.isParent()) continue;
            results = this.collectEntryDescendentTerms((SemanticIndexEntryParent)entry, type, namespace, results);
        }
        return results;
    }

    private SemanticIndexEntryParent getEntryParentAbove(IStrategoTerm namespace, IStrategoList id, boolean createNonExistant) {
        if (id.isEmpty()) {
            return null;
        }
        SemanticIndexEntryParent result = this.getEntryParentAt(namespace, id = id.tail());
        if (result == null && createNonExistant) {
            result = this.factory.createEntryParent(namespace, id, this.getEntryParentAbove(namespace, id, true));
            this.add(result);
        }
        return result;
    }

    private SemanticIndexEntryParent getEntryParentAt(IStrategoTerm namespace, IStrategoList id) {
        return (SemanticIndexEntryParent)this.getEntry(SemanticIndexEntryParent.TYPE, namespace, id, false);
    }

    public void clear() {
        this.table.clear();
        this.fileTable.clear();
    }

    public void clear(URI file) {
        Set<SemanticIndexEntry> fileSet = this.fileTable.remove(file);
        if (fileSet == null) {
            return;
        }
        SemanticIndexEntry[] copy = new SemanticIndexEntry[fileSet.size()];
        SemanticIndexEntry[] semanticIndexEntryArray = copy = fileSet.toArray(copy);
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticIndexEntry entry = semanticIndexEntryArray[n2];
            this.remove(entry);
            ++n2;
        }
    }

    public boolean isIndexed(URI file) {
        return this.fileTable.get(file) != null;
    }

    public void setIndexed(URI file) {
        this.getFileSet(file);
    }

    public Set<URI> getAllFiles() {
        return Collections.unmodifiableSet(this.fileTable.keySet());
    }

    public URI toFileURI(String path) {
        File file = new File(path);
        return file.isAbsolute() ? file.toURI() : new File(this.agent.getWorkingDir(), path).toURI();
    }

    public String fromFileURI(URI uri) {
        File file = new File(uri);
        return file.toString();
    }

    public String toString() {
        return this.table.keySet().toString();
    }
}

