/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import java.io.File;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class SSL_access
extends AbstractPrimitive {
    private static final int R_OK = 4;
    private static final int W_OK = 2;
    private static final int X_OK = 1;
    private static final int F_OK = 0;

    protected SSL_access() {
        super("SSL_access", 0, 2);
    }

    public boolean call(IContext env, Strategy[] sargs, IStrategoTerm[] targs) throws InterpreterException {
        if (!Tools.isTermString(targs[0])) {
            return false;
        }
        if (!Tools.isTermList(targs[1])) {
            return false;
        }
        SSLLibrary op = (SSLLibrary)env.getOperatorRegistry("SSL");
        String path = Tools.javaString(targs[0]);
        int permissions = this.permissions_from_term((IStrategoList)targs[1]);
        File f = op.getIOAgent().openFile(path);
        if ((permissions & 4) != 0) {
            if (!f.canRead()) {
                return false;
            }
        } else if ((permissions & 2) != 0) {
            if (!f.canWrite()) {
                return false;
            }
        } else {
            if ((permissions & 1) != 0) {
                return false;
            }
            if (permissions == 0 && !f.exists()) {
                return false;
            }
        }
        env.setCurrent(targs[0]);
        return true;
    }

    private int permissions_from_term(IStrategoList perms) {
        int res = 0;
        int i = 0;
        while (i < perms.size()) {
            IStrategoAppl t = Tools.applAt(perms, i);
            if (Tools.hasConstructor(t, "W_OK")) {
                res |= 2;
            } else if (Tools.hasConstructor(t, "R_OK")) {
                res |= 4;
            } else if (Tools.hasConstructor(t, "X_OK")) {
                res |= 1;
            } else if (Tools.hasConstructor(t, "F_OK")) {
                res |= 0;
            } else {
                System.err.println("*** ERROR: not an access mode: " + t);
            }
            ++i;
        }
        return res;
    }
}

