/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.xml;

import java.util.ArrayList;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.xml.XMLAbstractPrimitive;
import org.spoofax.interpreter.library.xml.XMLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.xml.sax.SAXParseException;

public class XML_get_parse_errors
extends XMLAbstractPrimitive {
    private static final String NAME = "XML_get_parse_errors";

    public XML_get_parse_errors(XMLLibrary library) {
        super(library, NAME, 0, 0);
    }

    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        Exception fatalError = this.library.getLastException();
        ArrayList<SAXParseException> nonFatalErrors = this.library.getLastErrors();
        if (fatalError == null && (nonFatalErrors == null || nonFatalErrors.isEmpty())) {
            return false;
        }
        ITermFactory factory = env.getFactory();
        ArrayList<IStrategoString> errors = new ArrayList<IStrategoString>();
        if (nonFatalErrors != null) {
            for (SAXParseException pe : nonFatalErrors) {
                errors.add(factory.makeString(XML_get_parse_errors.toString(pe)));
            }
        }
        if (fatalError != null) {
            if (fatalError instanceof SAXParseException) {
                errors.add(factory.makeString(XML_get_parse_errors.toString((SAXParseException)fatalError)));
            } else {
                errors.add(factory.makeString(fatalError.getMessage()));
            }
        }
        env.setCurrent(factory.makeList(errors));
        return true;
    }

    private static String toString(SAXParseException pe) {
        return String.valueOf(pe.getMessage()) + " [line " + pe.getLineNumber() + ", column " + pe.getColumnNumber() + "]";
    }
}

