/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.xml;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.library.xml.XMLAbstractPrimitive;
import org.spoofax.interpreter.library.xml.XMLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.xml.sax.SAXException;

public class XML_set_feature
extends XMLAbstractPrimitive {
    private static final String PREFIX = "http://spoofax.org/sax/features/";
    private static final String MIXED_CONTENT = "http://spoofax.org/sax/features/mixed-content";
    private static final String CHARACTER_DATA = "http://spoofax.org/sax/features/character-data";

    public XML_set_feature(XMLLibrary library) {
        super(library, "XML_set_feature", 0, 2);
    }

    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) {
        boolean enable;
        if (tvars[0].getTermType() != 5 || tvars[1].getTermType() != 3) {
            return false;
        }
        this.library.clearErrors();
        String feature = ((IStrategoString)tvars[0]).stringValue();
        boolean bl = enable = ((IStrategoInt)tvars[1]).intValue() != 0;
        if (feature.startsWith(PREFIX)) {
            if (feature.equals(MIXED_CONTENT)) {
                this.library.setAllowMixedContent(enable);
                return true;
            }
            if (feature.equals(CHARACTER_DATA)) {
                this.library.setAllowCharacterContent(enable);
                return true;
            }
            this.library.setLastException(new Exception("Feature \"" + feature + "\" not recognized"));
            return false;
        }
        SAXParserFactory parserFactory = this.library.obtainParserFactory();
        if (parserFactory == null) {
            return false;
        }
        try {
            parserFactory.setFeature(feature, enable);
            this.library.purgeParser();
            return true;
        }
        catch (SAXException e) {
            this.library.setLastException(e);
        }
        catch (ParserConfigurationException e) {
            this.library.setLastException(e);
        }
        return false;
    }
}

