/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.DebugUtil;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.stratego.All;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;

public class Some
extends Strategy {
    protected Strategy body;

    public Some(Strategy body) {
        this.body = body;
    }

    public IConstruct eval(IContext env) throws InterpreterException {
        if (DebugUtil.isDebugging()) {
            Some.debug("Some.eval() - ", env.current());
        }
        IStrategoTerm t = env.current();
        switch (t.getTermType()) {
            case 3: 
            case 4: 
            case 5: {
                return this.getHook().pop().onFailure(env);
            }
            case 1: {
                return this.eval(env, 0, false, (IStrategoTerm[])t.getAllSubterms().clone());
            }
            case 2: 
            case 7: {
                IStrategoTerm[] subterms = t.getAllSubterms();
                assert (All.isCopy(t, subterms));
                return this.eval(env, 0, false, subterms);
            }
            case 9: {
                return this.getHook().pop().onFailure(env);
            }
        }
        throw new InterpreterException("Unknown ATerm type " + t.getTermType());
    }

    protected IConstruct eval(IContext env, final int n, final boolean hadsome, final IStrategoTerm[] list) throws InterpreterException {
        final IStrategoTerm old = env.current();
        if (n >= old.getSubtermCount()) {
            if (hadsome) {
                switch (old.getTermType()) {
                    case 1: {
                        env.setCurrent(env.getFactory().replaceAppl(((IStrategoAppl)old).getConstructor(), list, (IStrategoAppl)old));
                        break;
                    }
                    case 2: {
                        env.setCurrent(env.getFactory().replaceList(list, (IStrategoList)old));
                        break;
                    }
                    case 7: {
                        env.setCurrent(env.getFactory().replaceTuple(list, (IStrategoTuple)old));
                    }
                }
                return this.getHook().pop().onSuccess(env);
            }
            return this.getHook().pop().onFailure(env);
        }
        env.setCurrent(list[n]);
        this.body.getHook().push(new Hook(){

            public IConstruct onFailure(IContext env) throws InterpreterException {
                env.setCurrent(old);
                return Some.this.eval(env, n + 1, hadsome, list);
            }

            public IConstruct onSuccess(IContext env) throws InterpreterException {
                list[n] = env.current();
                env.setCurrent(old);
                return Some.this.eval(env, n + 1, true, list);
            }
        });
        return this.body;
    }

    public void prettyPrint(StupidFormatter sf) {
        sf.append("Some(");
        this.body.prettyPrint(sf);
        sf.append(")");
    }
}

