/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.test;

import java.io.IOException;
import junit.framework.TestCase;
import org.spoofax.DebugUtil;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public abstract class AbstractInterpreterTest
extends TestCase {
    protected Interpreter itp;
    protected ITermFactory factory;
    protected String basePath;
    private boolean unitTestDebug = false;

    protected void setUp(String path) throws Exception {
        super.setUp();
        this.basePath = path;
        this.itp = new Interpreter();
        this.factory = this.itp.getFactory();
        DebugUtil.setDebug(false);
        DebugUtil.setTracing(false);
        this.unitTestDebug = true;
    }

    protected void tearDown() throws Exception {
        this.itp.shutdown();
        this.itp = null;
        this.factory = null;
        super.tearDown();
    }

    public void interpTestFail(String test, IStrategoTerm input) throws IOException, InterpreterException {
        AbstractInterpreterTest.assertFalse(this.runInterp(test, input));
    }

    public void interpTestFail(String test, String input) throws IOException, InterpreterException {
        IStrategoTerm t = this.itp.getFactory().parseFromString(input);
        this.interpTestFail(test, t);
    }

    public void interpTest(String test, String input, String output) throws IOException, InterpreterException {
        IStrategoTerm i = this.factory.parseFromString(input);
        IStrategoTerm o = this.factory.parseFromString(output);
        this.interpTest(test, i, o);
    }

    public void interpTest(String test, IStrategoTerm input, IStrategoTerm output) throws IOException, InterpreterException {
        if (this.unitTestDebug) {
            System.out.println("Input : " + input);
        }
        AbstractInterpreterTest.assertTrue("main strategy failed", this.runInterp(test, input));
        IStrategoTerm x = output;
        IStrategoTerm y = this.itp.current();
        if (this.unitTestDebug) {
            System.out.println("Want  : " + x + " / " + x.getTermType() + " / " + x.getClass() + " / " + x.getSubtermCount());
            System.out.println("Got   : " + y + " / " + y.getTermType() + " / " + y.getClass() + " / " + y.getSubtermCount());
        }
        boolean succeeded = this.itp.current().match(output);
        if (this.unitTestDebug) {
            System.out.println(succeeded);
        }
        AbstractInterpreterTest.assertTrue("actual output differs from expected output", succeeded);
    }

    private boolean runInterp(String test, IStrategoTerm input) throws IOException, InterpreterException {
        this.itp.load(String.valueOf(this.basePath) + "/" + test + ".ctree");
        this.itp.setCurrent(input);
        return this.itp.invoke("main_0_0");
    }
}

