/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import org.spoofax.jsglr.client.BacktrackPosition;
import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.IndentInfo;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.RecoverNode;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.StructureSkipSuggestion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FineGrainedOnRegion {
    private static final int MAX_NR_OF_EXPLORED_LINES = 75;
    private int acceptRecoveryPosition;
    private int regionEndPosition;
    private ArrayList<BacktrackPosition> choicePoints;
    private static int MAX_BACK_JUMPS = 5;
    private SGLR mySGLR;

    private ParserHistory getHistory() {
        return this.mySGLR.getHistory();
    }

    public void setInfoFGOnly() {
        this.regionEndPosition = this.mySGLR.tokensSeen + 5;
        this.acceptRecoveryPosition = this.regionEndPosition + 15;
        int lastIndex = this.getHistory().getIndexLastLine();
        int i = Math.max(0, lastIndex - 75);
        while (i < lastIndex) {
            IndentInfo line = this.getHistory().getLine(i);
            if (line.getStackNodes() != null && line.getStackNodes().size() > 0) {
                BacktrackPosition btPoint = new BacktrackPosition(line.getStackNodes(), line.getTokensSeen());
                btPoint.setIndexHistory(i);
                this.choicePoints.add(btPoint);
            }
            ++i;
        }
    }

    public void setRegionInfo(StructureSkipSuggestion erroneousRegion, int acceptPosition) {
        int btStartIndex;
        this.regionEndPosition = erroneousRegion.getEndSkip().getTokensSeen();
        this.acceptRecoveryPosition = acceptPosition;
        int lastIndex = Math.min(erroneousRegion.getIndexHistoryEnd(), this.getHistory().getIndexLastLine());
        assert (lastIndex >= 0 && erroneousRegion.getIndexHistoryStart() >= 0 && erroneousRegion.getIndexHistoryStart() <= erroneousRegion.getIndexHistoryEnd());
        int i = btStartIndex = Math.max(erroneousRegion.getIndexHistoryStart(), lastIndex - 75);
        while (i < lastIndex) {
            IndentInfo line = this.getHistory().getLine(i);
            if (line.getStackNodes() != null && line.getStackNodes().size() > 0) {
                BacktrackPosition btPoint = new BacktrackPosition(line.getStackNodes(), line.getTokensSeen());
                btPoint.setIndexHistory(i);
                this.choicePoints.add(btPoint);
            }
            ++i;
        }
    }

    public boolean recover() {
        int btIndex = this.choicePoints.size() - 1;
        if (btIndex >= 0) {
            return this.recoverFrom(btIndex, new ArrayList<RecoverNode>());
        }
        return false;
    }

    private boolean recoverFrom(int btIndex, ArrayList<RecoverNode> unexplored_branches) {
        ArrayList<Object> rec_Branches = new ArrayList();
        if (btIndex >= 0) {
            rec_Branches = this.collectRecoverBranches(btIndex);
            this.resetSGLR(btIndex);
        } else {
            this.resetSGLR(0);
        }
        rec_Branches.addAll(unexplored_branches);
        ArrayList<RecoverNode> newbranches = this.recoverParse(rec_Branches, this.regionEndPosition);
        if (this.acceptParse()) {
            return true;
        }
        if (this.choicePoints.size() - 1 - btIndex > MAX_BACK_JUMPS) {
            if (btIndex > 0) {
                ArrayList<RecoverNode> rec_Branches_prefix = new ArrayList();
                rec_Branches_prefix = this.collectRecoverBranches(0, btIndex);
                this.resetSGLR(0);
                ArrayList<RecoverNode> oneRecoverBranches = this.recoverParse(rec_Branches_prefix, this.regionEndPosition);
                if (!this.acceptParse()) {
                    this.resetSGLR(0);
                    this.recoverParse(oneRecoverBranches, this.regionEndPosition);
                }
                return this.acceptParse();
            }
            return false;
        }
        return this.recoverFrom(btIndex - 1, newbranches);
    }

    private void resetSGLR(int btIndex) {
        BacktrackPosition btrPosition = this.choicePoints.get(btIndex);
        this.mySGLR.activeStacks.clear(true);
        this.getHistory().setTokenIndex(btrPosition.tokensSeen);
    }

    private ArrayList<RecoverNode> collectRecoverBranches(int btIndex) {
        this.resetSGLR(btIndex);
        this.mySGLR.activeStacks.addAll(this.choicePoints.get((int)btIndex).recoverStacks);
        int endPos = btIndex < this.choicePoints.size() - 1 ? this.choicePoints.get((int)(btIndex + 1)).tokensSeen - 1 : this.regionEndPosition;
        ArrayList<RecoverNode> rec1_Branches = this.recoverParse(new ArrayList<RecoverNode>(), endPos);
        return rec1_Branches;
    }

    private ArrayList<RecoverNode> collectRecoverBranches(int btIndex, int btIndex_end) {
        this.resetSGLR(btIndex);
        this.mySGLR.activeStacks.addAll(this.choicePoints.get((int)btIndex).recoverStacks);
        int endPos = btIndex_end < this.choicePoints.size() ? this.choicePoints.get((int)btIndex_end).tokensSeen - 1 : this.regionEndPosition;
        ArrayList<RecoverNode> rec1_Branches = this.recoverParse(new ArrayList<RecoverNode>(), endPos);
        return rec1_Branches;
    }

    private ArrayList<RecoverNode> recoverParse(ArrayList<RecoverNode> candidates, int endRecoverSearchPos) {
        this.mySGLR.setFineGrainedOnRegion(true);
        ArrayList<RecoverNode> newCandidates = new ArrayList<RecoverNode>();
        do {
            int curTokIndex = this.getHistory().getTokenIndex();
            this.addCurrentCandidates(candidates, curTokIndex);
            this.getHistory().readRecoverToken(this.mySGLR, false);
            this.mySGLR.doParseStep();
            newCandidates.addAll(this.collectNewRecoverCandidates(curTokIndex));
            this.mySGLR.getRecoverStacks().clear();
        } while (this.getHistory().getTokenIndex() <= endRecoverSearchPos && this.mySGLR.acceptingStack == null && this.mySGLR.getCurrentToken() != 256);
        this.mySGLR.setFineGrainedOnRegion(false);
        return newCandidates;
    }

    private boolean acceptParse() {
        while (this.getHistory().getTokenIndex() <= this.acceptRecoveryPosition && this.mySGLR.acceptingStack == null && this.mySGLR.activeStacks.size() > 0) {
            this.getHistory().readRecoverToken(this.mySGLR, false);
            this.mySGLR.doParseStep();
        }
        return this.mySGLR.activeStacks.size() > 0 || this.mySGLR.acceptingStack != null;
    }

    private ArrayList<RecoverNode> collectNewRecoverCandidates(int tokenIndex) {
        ArrayList<RecoverNode> results = new ArrayList<RecoverNode>();
        for (Frame recoverStack : this.mySGLR.getRecoverStacks()) {
            RecoverNode rn = new RecoverNode(recoverStack, tokenIndex);
            results.add(rn);
        }
        return results;
    }

    private void addCurrentCandidates(ArrayList<RecoverNode> candidates, int tokenPosition) {
        for (RecoverNode recoverNode : candidates) {
            if (tokenPosition != recoverNode.tokensSeen) continue;
            Frame st = this.mySGLR.findStack(this.mySGLR.activeStacks, recoverNode.recoverStack.state);
            if (st != null) {
                for (Link ln : recoverNode.recoverStack.getAllLinks()) {
                    st.addLink(ln);
                }
                continue;
            }
            this.mySGLR.addStack(recoverNode.recoverStack);
        }
    }

    public FineGrainedOnRegion(SGLR parser) {
        this.mySGLR = parser;
        this.choicePoints = new ArrayList();
    }

    public boolean parseRemainingTokens() {
        while (!this.getHistory().hasFinishedRecoverTokens() && this.mySGLR.activeStacks.size() > 0 && this.mySGLR.acceptingStack == null) {
            this.getHistory().readRecoverToken(this.mySGLR, true);
            this.mySGLR.doParseStep();
        }
        return this.mySGLR.activeStacks.size() > 0 || this.mySGLR.acceptingStack != null;
    }
}

