/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.Path;
import org.spoofax.jsglr.client.PooledPathList;
import org.spoofax.jsglr.client.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frame
implements Serializable {
    private static final long serialVersionUID = -4757644376472129935L;
    public static int framesCreated = 0;
    public final State state;
    private Link[] steps;
    private int stepsCount;

    public Frame(State s) {
        this.state = s;
        this.steps = new Link[20];
        this.stepsCount = 0;
        ++framesCreated;
    }

    public boolean allLinksRejected() {
        if (this.stepsCount == 0) {
            return false;
        }
        int i = 0;
        while (i < this.stepsCount) {
            if (!this.steps[i].isRejected()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public State peek() {
        return this.state;
    }

    public void findAllPaths(PooledPathList pool, int arity) {
        this.doComputePathsToRoot(pool, null, arity, 0, 0);
    }

    private void doComputePathsToRoot(PooledPathList pool, Path node, int arity, int parentCount, int length) {
        if (arity == 0) {
            pool.rememberPath(node, null, this, length, parentCount);
        } else {
            int i = 1;
            while (i <= this.stepsCount) {
                Link link = this.steps[this.stepsCount - i];
                Path n = pool.makePath(node, link, this, link.getLength(), parentCount);
                link.parent.doComputePathsToRoot(pool, n, arity - 1, parentCount + 1, length + link.getLength());
                ++i;
            }
        }
    }

    public Frame getRoot() {
        if (this.stepsCount == 0) {
            return this;
        }
        return this.steps[0].parent.getRoot();
    }

    public Link findDirectLink(Frame st0) {
        int i = 0;
        while (i < this.stepsCount) {
            if (this.steps[i].parent == st0) {
                return this.steps[i];
            }
            ++i;
        }
        return null;
    }

    public ArrayList<Link> getAllLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        int i = 0;
        while (i < this.stepsCount) {
            links.add(this.steps[i]);
            ++i;
        }
        return links;
    }

    public Link addLink(Frame st0, AbstractParseNode n, int length) {
        if (this.stepsCount >= this.steps.length) {
            this.resizeSteps();
        }
        Link link = new Link(st0, n, length);
        this.steps[this.stepsCount++] = link;
        return link;
    }

    public Link addLink(Link ln) {
        if (this.stepsCount >= this.steps.length) {
            this.resizeSteps();
        }
        Link link = ln;
        this.steps[this.stepsCount++] = link;
        return link;
    }

    private void resizeSteps() {
        Link[] newSteps = new Link[this.steps.length * 2];
        System.arraycopy(this.steps, 0, newSteps, 0, this.steps.length);
        this.steps = newSteps;
    }

    public String dumpStack() {
        StringBuilder sb = new StringBuilder();
        sb.append("GSS [\n").append(this.doDumpStack(2)).append("\n  ]");
        return sb.toString();
    }

    public String doDumpStack(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.state.stateNumber);
        if (this.stepsCount > 1) {
            sb.append(" ( ");
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n2 = 0;
            while (n2 < n) {
                Link s = linkArray[n2];
                if (s == null) break;
                sb.append(s.parent.doDumpStack(indent + 1));
                sb.append(" | ");
                ++n2;
            }
            sb.append(")");
        } else {
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n3 = 0;
            while (n3 < n) {
                Link s = linkArray[n3];
                if (s == null) break;
                sb.append(" <").append(s.label).append("> ").append(s.parent.state.stateNumber).append("\n");
                if (indent <= 5) {
                    sb.append(s.parent.doDumpStack(indent + 1));
                }
                ++n3;
            }
        }
        return sb.toString();
    }

    public String dumpStackCompact() {
        StringBuilder sb = new StringBuilder();
        sb.append("GSS [").append(this.doDumpStackCompact()).append(" ]");
        return sb.toString();
    }

    public String doDumpStackCompact() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.state.stateNumber);
        if (this.stepsCount > 1) {
            sb.append(" ( ");
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n2 = 0;
            while (n2 < n) {
                Link s = linkArray[n2];
                if (s == null) break;
                sb.append(s.parent.doDumpStackCompact());
                sb.append(" | ");
                ++n2;
            }
            sb.append(")");
        } else {
            Link[] linkArray = this.steps;
            int n = this.steps.length;
            int n3 = 0;
            while (n3 < n) {
                Link s = linkArray[n3];
                if (s == null) break;
                sb.append(", ").append(s.parent.doDumpStackCompact());
                ++n3;
            }
        }
        return sb.toString();
    }

    public void findLimitedPaths(PooledPathList pool, int arity, Link l) {
        if (this.findLink(arity, l)) {
            this.doComputePathsToRoot(pool, null, l, false, arity, 0, 0);
        }
    }

    private void TRACE_DumpLinks(Link[] st) {
        int i = 0;
        while (i < this.stepsCount) {
            Link link = st[this.stepsCount - i - 1];
            ++i;
        }
    }

    private boolean findLink(int arity, Link l0) {
        if (arity > 0) {
            int i = 0;
            while (i < this.stepsCount) {
                Link l1 = this.steps[this.stepsCount - i - 1];
                if (l0 == l1) {
                    return true;
                }
                if (arity > 1 && l1.parent.findLink(arity - 1, l0)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void doComputePathsToRoot(PooledPathList pool, Path node, Link l, boolean seen, int arity, int parentCount, int length) {
        if (arity == 0 && seen) {
            pool.rememberPath(node, null, this, length, parentCount);
        } else if (arity > 0) {
            int i = 0;
            while (i < this.stepsCount) {
                Link ln = this.steps[this.stepsCount - i - 1];
                boolean seenIt = seen || ln == l;
                Path n = pool.makePath(node, ln, this, ln.getLength(), parentCount);
                ln.parent.doComputePathsToRoot(pool, n, l, seenIt, arity - 1, parentCount + 1, length + ln.getLength());
                ++i;
            }
        }
    }

    public void clear() {
        if (this.steps != null) {
            int i = 0;
            while (i < this.stepsCount) {
                this.steps[i].clear();
                this.steps[i] = null;
                ++i;
            }
            this.steps = null;
            this.stepsCount = 0;
        }
    }

    public int minAvoidValue() {
        int result = 0;
        int i = 0;
        while (i < this.stepsCount) {
            if (i == 0) {
                result = this.steps[i].recoverCount;
                result = Math.min(result, this.steps[i].recoverCount);
            }
            ++i;
        }
        return result;
    }

    public List<String> getStackPaths(String frontEnd, boolean avoidFree) {
        String front = String.valueOf(this.state.stateNumber) + frontEnd;
        ArrayList<String> stackStrings = new ArrayList<String>();
        if (this.stepsCount == 0) {
            stackStrings.add(front);
            return stackStrings;
        }
        int i = 0;
        while (i < this.stepsCount) {
            Link ln = this.steps[i];
            if (ln.recoverCount == 0 || !avoidFree) {
                List<String> childColl;
                if (ln.recoverCount == 0) {
                    childColl = ln.parent.getStackPaths(" - " + front, avoidFree);
                } else {
                    String frnt = "-$" + ln.recoverCount + "$-" + front;
                    childColl = ln.parent.getStackPaths(frnt, avoidFree);
                }
                stackStrings.addAll(childColl);
            }
            ++i;
        }
        return stackStrings;
    }

    public String[] getStackRepresentation(boolean avoidFree) {
        List<String> stackStrings = this.getStackPaths("", avoidFree);
        return stackStrings.toArray(new String[stackStrings.size()]);
    }
}

