/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.ArrayList;
import java.util.List;
import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoNamed;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITreeFactory;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstAnnoImploder<TNode> {
    private final ITreeFactory<TNode> factory;
    private final List<TNode> placeholderValues;
    private final IToken leftToken;
    private final IToken rightToken;
    private final ITermFactory termFactory;

    public AstAnnoImploder(ITreeFactory<TNode> factory, ITermFactory termFactory, List<TNode> placeholderValues, IToken leftToken, IToken rightToken) {
        this.factory = factory;
        this.termFactory = termFactory;
        this.placeholderValues = placeholderValues;
        this.leftToken = leftToken;
        this.rightToken = rightToken;
    }

    public TNode implode(IStrategoTerm ast, String sort) throws ParseError {
        String astString = ast.toString();
        if (astString.startsWith("\"") && astString.endsWith("\"")) {
            astString = astString.substring(1, astString.length() - 1);
            astString = astString.replace("\\\\", "\\").replace("\\\"", "\"");
            ast = this.termFactory.parseFromString(astString);
        }
        return this.toNode(ast, sort);
    }

    private TNode toNode(IStrategoTerm term, String sort) {
        switch (term.getTermType()) {
            case 10: {
                return this.placeholderToNode(term, sort);
            }
            case 1: 
            case 5: {
                return this.namedToNode(term, sort);
            }
            case 2: {
                return this.listToNode(term, sort);
            }
            case 3: {
                IStrategoInt i = (IStrategoInt)term;
                return this.factory.createIntTerminal(sort, this.leftToken, i.intValue());
            }
            case 4: {
                IStrategoReal r = (IStrategoReal)term;
                return this.factory.createRealTerminal(sort, this.leftToken, r.realValue());
            }
        }
        throw new IllegalStateException("Unexpected term type encountered in {ast} attribute");
    }

    private TNode placeholderToNode(IStrategoTerm placeholder, String sort) {
        IStrategoTerm term = ((IStrategoPlaceholder)placeholder).getTemplate();
        if (Term.isTermInt(term)) {
            int id = Term.javaInt(term);
            if (1 <= id && id <= this.placeholderValues.size()) {
                return this.placeholderValues.get(id - 1);
            }
        } else if (Term.isTermNamed(term)) {
            String type = ((IStrategoNamed)term).getName();
            if ("conc".equals(type) && term.getSubtermCount() == 2) {
                TNode left = this.toNode((IStrategoTerm)Term.termAt(term, 0), null);
                TNode right = this.toNode((IStrategoTerm)Term.termAt(term, 1), null);
                ArrayList<TNode> children = new ArrayList<TNode>();
                for (TNode node : this.factory.getChildren(left)) {
                    children.add(node);
                }
                for (TNode node : this.factory.getChildren(right)) {
                    children.add(node);
                }
                return this.factory.createList(sort, this.leftToken, this.rightToken, children);
            }
            if ("yield".equals(type) && term.getSubtermCount() == 1) {
                throw new NotImplementedException("not implemented: yield in {ast} attribute");
            }
        }
        throw new IllegalStateException("Error in syntax definition: illegal placeholder in {ast} attribute: " + placeholder);
    }

    private TNode namedToNode(IStrategoTerm term, String sort) {
        IStrategoNamed appl = (IStrategoNamed)term;
        ArrayList<TNode> children = new ArrayList<TNode>(appl.getSubtermCount());
        int i = 0;
        while (i < appl.getSubtermCount()) {
            children.add(this.toNode((IStrategoTerm)Term.termAt(appl, i), null));
            ++i;
        }
        if (appl.getTermType() == 5) {
            return this.factory.createStringTerminal(sort, this.leftToken, this.rightToken, appl.getName());
        }
        return this.factory.createNonTerminal(sort, appl.getName(), this.leftToken, this.rightToken, children);
    }

    private TNode listToNode(IStrategoTerm term, String sort) {
        IStrategoList list = (IStrategoList)term;
        ArrayList<TNode> children = new ArrayList<TNode>(list.getSubtermCount());
        int i = 0;
        while (i < term.getSubtermCount()) {
            children.add(this.toNode((IStrategoTerm)Term.termAt(term, i), null));
            ++i;
        }
        return this.factory.createList(sort, this.leftToken, this.rightToken, children);
    }
}

