/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import java.util.ArrayList;
import java.util.List;
import org.spoofax.PushbackStringIterator;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.CycleParseNode;
import org.spoofax.jsglr.client.ParseNode;
import org.spoofax.jsglr.client.ParseProductionNode;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.RecoveryConnector;
import org.spoofax.jsglr.client.imploder.AstAnnoImploder;
import org.spoofax.jsglr.client.imploder.AutoConcatList;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.ITreeFactory;
import org.spoofax.jsglr.client.imploder.LabelInfo;
import org.spoofax.jsglr.client.imploder.NullTokenizer;
import org.spoofax.jsglr.client.imploder.ProductionAttributeReader;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.jsglr.client.imploder.Tokenizer;
import org.spoofax.jsglr.client.imploder.TopdownTreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBuilder
extends TopdownTreeBuilder {
    public static final char SKIPPED_CHAR = '\uffff';
    public static final char UNEXPECTED_EOF_CHAR = '\ufffe';
    private static final int NONE = -1;
    private static final int EXPECTED_NODE_CHILDREN = 5;
    private static final String LIST_CONSTRUCTOR = new String("[]");
    private static final String TUPLE_CONSTRUCTOR = new String("");
    private final boolean disableTokens;
    private ParseTable table;
    private ITokenizer tokenizer;
    private String input;
    private PushbackStringIterator stringIterator;
    private ITreeFactory factory;
    private boolean initializeFactories;
    private ProductionAttributeReader prodReader;
    private ITermFactory termFactory;
    private LabelInfo[] labels;
    private int labelStart;
    private int offset;
    private int nonMatchingOffset = -1;
    private char nonMatchingChar;
    private char nonMatchingCharExpected;
    private boolean inLexicalContext;

    public TreeBuilder() {
        this(false);
    }

    public TreeBuilder(boolean disableTokens) {
        this.disableTokens = disableTokens;
        this.initializeFactories = true;
    }

    public TreeBuilder(ITreeFactory treeFactory) {
        this(treeFactory, false);
    }

    public TreeBuilder(ITreeFactory treeFactory, boolean disableTokens) {
        this.factory = treeFactory;
        this.disableTokens = disableTokens;
        this.factory.setEnableTokens(!disableTokens);
    }

    @Override
    public void initializeTable(ParseTable table, int productionCount, int labelStart, int labelCount) {
        this.table = table;
        this.termFactory = table.getFactory();
        if (this.initializeFactories) {
            this.factory = new TermTreeFactory(this.termFactory);
            this.factory.setEnableTokens(!this.disableTokens);
            this.initializeFactories = false;
        }
        assert (!(this.tokenizer instanceof Tokenizer) || ((Tokenizer)this.tokenizer).getKeywordRecognizer() == table.getKeywordRecognizer());
        this.prodReader = new ProductionAttributeReader(this.termFactory);
        this.labels = new LabelInfo[labelCount - labelStart];
        this.labelStart = labelStart;
    }

    @Override
    public void initializeLabel(int labelNumber, IStrategoAppl parseTreeProduction) {
        this.labels[labelNumber - this.labelStart] = new LabelInfo(this.prodReader, parseTreeProduction);
    }

    @Override
    public void initializeInput(String input, String filename) {
        assert (this.offset == 0) : "Tree builder offset was not reset, race condition?";
        this.setTokenizer(this.disableTokens ? new NullTokenizer(input, filename) : new Tokenizer(input, filename, this.table.getKeywordRecognizer()));
        this.setInput(input);
        this.reset();
    }

    @Override
    public final ITokenizer getTokenizer() {
        return this.tokenizer;
    }

    protected void setTokenizer(ITokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    protected void setInput(String input) {
        this.input = input;
        this.stringIterator = new PushbackStringIterator(input);
    }

    protected final int getOffset() {
        return this.offset;
    }

    protected final String getInput() {
        return this.input;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }

    protected ParseTable getParseTable() {
        return this.table;
    }

    public ITreeFactory getFactory() {
        if (this.factory == null && this.initializeFactories) {
            throw new IllegalStateException("Not initialized yet");
        }
        return this.factory;
    }

    @Override
    @Deprecated
    public Object buildTree(AbstractParseNode node) {
        assert (this.tokenizer != null) : "Tokenizer not initialized; initializeInput() not called?";
        return this.tryBuildAutoConcatListNode(super.buildTree(node));
    }

    @Override
    public void reset() {
        this.offset = 0;
        this.inLexicalContext = false;
        if (this.tokenizer != null && this.tokenizer.getStartOffset() > 0) {
            this.setTokenizer(this.disableTokens ? new NullTokenizer(this.tokenizer.getInput(), this.tokenizer.getFilename()) : new Tokenizer(this.tokenizer.getInput(), this.tokenizer.getFilename(), this.table.getKeywordRecognizer()));
        }
    }

    @Override
    public Object buildTreeTop(Object subtree, int ambiguityCount) {
        try {
            Object tree = this.tryBuildAutoConcatListNode(subtree);
            tree = this.recreateWithAllTokens(tree);
            this.tokenizer.makeToken(this.tokenizer.getStartOffset() - 1, 8, true);
            Object result = this.factory.createTop(tree, this.tokenizer.getFilename(), ambiguityCount);
            if (result instanceof ISimpleTerm) {
                this.tokenizer.setAst((ISimpleTerm)result);
            }
            Object object = result;
            return object;
        }
        finally {
            this.reset();
        }
    }

    private Object recreateWithAllTokens(Object tree) {
        ArrayList<Object> children = new ArrayList<Object>();
        for (Object child : this.factory.getChildren(tree)) {
            children.add(child);
        }
        tree = this.factory.recreateNode(tree, this.tokenizer.getTokenAt(0), this.tokenizer.currentToken(), children);
        return tree;
    }

    @Override
    public Object buildTreeNode(ParseNode node) {
        Object result;
        LabelInfo label = this.labels[node.getLabel() - this.labelStart];
        IToken prevToken = this.tokenizer.currentToken();
        int lastOffset = this.offset;
        AbstractParseNode[] subnodes = node.getChildren();
        boolean isList = label.isList();
        boolean lexicalStart = false;
        if (!this.inLexicalContext && label.isNonContextFree()) {
            lexicalStart = true;
            this.inLexicalContext = true;
        }
        List children = null;
        if (!this.inLexicalContext) {
            children = isList ? new AutoConcatList(label.getSort()) : new ArrayList(Math.max(5, subnodes.length));
        }
        AbstractParseNode[] abstractParseNodeArray = subnodes;
        int n = subnodes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode subnode = abstractParseNodeArray[n2];
            Object child = this.inLexicalContext && subnode.isParseProductionChain() ? this.chainToTreeTopdown(subnode) : subnode.toTreeTopdown(this);
            if (this.inLexicalContext) {
                child = null;
            }
            if (child != null) {
                children.add((Object)(isList ? child : this.tryBuildAutoConcatListNode(child)));
            }
            ++n2;
        }
        if (!this.inLexicalContext && isList && children.isEmpty()) {
            IToken token = this.tokenizer.makeToken(this.tokenizer.getStartOffset() - 1, 7, true);
            ((AutoConcatList)children).setEmptyListToken(token);
        }
        if (lexicalStart) {
            result = this.tryCreateStringTerminal(label, lastOffset);
            this.inLexicalContext = false;
        } else if (this.inLexicalContext) {
            this.tokenizer.tryMakeLayoutToken(this.offset - 1, lastOffset - 1, label);
            result = null;
        } else {
            result = isList ? children : this.createNodeOrInjection(label, prevToken, children);
        }
        this.tokenizer.markPossibleSyntaxError(label, prevToken, this.offset - 1, this.prodReader);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private Object chainToTreeTopdown(AbstractParseNode node) {
        if (TreeBuilder.$assertionsDisabled || node.isParseProductionChain()) ** GOTO lbl12
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            kids = ((ParseNode)node).getChildren();
            if (kids.length == 2) {
                this.buildTreeProduction((ParseProductionNode)kids[0]);
                node = kids[1];
                continue;
            }
            if (kids.length == 1) {
                return this.buildTreeNode((ParseNode)node);
            }
            throw new IllegalStateException("Unexpected node in parse production chain: " + node);
lbl12:
            // 2 sources

            ** while (node.isParseNode())
        }
lbl13:
        // 1 sources

        this.buildTreeProduction((ParseProductionNode)node);
        return null;
    }

    @Override
    public Object buildTreeAmb(ParseNode a) {
        if (this.inLexicalContext) {
            return a.getChildren()[0].toTreeTopdown(this);
        }
        int oldOffset = this.offset;
        int oldBeginOffset = this.tokenizer.getStartOffset();
        boolean oldLexicalContext = this.inLexicalContext;
        AbstractParseNode[] subnodes = a.getChildren();
        ArrayList<Object> children = new ArrayList<Object>(Math.max(5, subnodes.length));
        this.tokenizer.setAmbiguous(true);
        AbstractParseNode[] abstractParseNodeArray = subnodes;
        int n = subnodes.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode subnode = abstractParseNodeArray[n2];
            this.offset = oldOffset;
            this.tokenizer.setStartOffset(oldBeginOffset);
            this.inLexicalContext = oldLexicalContext;
            Object child = this.tryBuildAutoConcatListNode(subnode.toTreeTopdown(this));
            if (child != null) {
                children.add(child);
            }
            ++n2;
        }
        IToken leftToken = null;
        IToken rightToken = null;
        if (children.size() <= 0) {
            return null;
        }
        leftToken = this.factory.getLeftToken(children.get(0));
        rightToken = this.factory.getRightToken(children.get(children.size() - 1));
        return this.factory.createAmb(children, leftToken, rightToken);
    }

    @Override
    public Object buildTreeCycle(CycleParseNode node) {
        if (this.inLexicalContext) {
            return null;
        }
        IToken token = this.tokenizer.makeToken(this.offset - 1, 0, true);
        if (node.getTargetLabel() == -1) {
            return this.factory.createNonTerminal("cycle", "cycle", token, token, new ArrayList());
        }
        LabelInfo label = this.labels[node.getTargetLabel() - this.labelStart];
        String cons = label.getSort();
        if (cons == null) {
            cons = "cycle";
        }
        Object child = this.factory.createNonTerminal(label.getSort(), cons, token, token, new ArrayList());
        ArrayList children = new ArrayList();
        children.add(child);
        return this.factory.createNonTerminal("cycle", "cycle", token, token, children);
    }

    private Object tryBuildAutoConcatListNode(Object node) {
        if (node instanceof AutoConcatList) {
            return this.buildAutoConcatListNode((AutoConcatList)node);
        }
        return node;
    }

    public Object buildAutoConcatListNode(AutoConcatList list) {
        IToken left = list.isEmpty() ? list.getEmptyListToken() : this.factory.getLeftToken(list.get(0));
        IToken right = list.isEmpty() ? list.getEmptyListToken() : this.factory.getRightToken(list.get(list.size() - 1));
        return this.factory.createList(list.getSort(), left, right, list);
    }

    @Override
    public Object buildTreeProduction(ParseProductionNode node) {
        int character = node.prod;
        this.consumeLexicalChar(character);
        return this.inLexicalContext ? null : this.createIntTerminal(node, null);
    }

    private Object tryCreateStringTerminal(LabelInfo label, int lastOffset) {
        String sort = label.getSort();
        IToken rightToken = this.tokenizer.makeToken(this.offset - 1, label, sort != null);
        if (sort == null) {
            return null;
        }
        IToken leftToken = rightToken.getStartOffset() == lastOffset ? rightToken : this.tokenizer.getTokenAtOffset(lastOffset);
        String contents = this.tokenizer.toString(lastOffset, this.offset - 1);
        assert (this.disableTokens || this.tokenizer.isAmbigous() || contents.equals(this.tokenizer.toString(leftToken, rightToken)) && lastOffset == leftToken.getStartOffset());
        Object result = this.factory.createStringTerminal(sort, leftToken, rightToken, this.getPaddedLexicalValue(label, contents, lastOffset));
        String constructor = label.getMetaVarConstructor();
        if (constructor != null) {
            ArrayList children = new ArrayList(1);
            children.add(result);
            result = this.factory.createNonTerminal(sort, constructor, leftToken, rightToken, children);
        }
        return result;
    }

    private Object createIntTerminal(ParseProductionNode node, LabelInfo label) {
        IToken token = this.tokenizer.makeToken(this.offset - 1, label, true);
        int value = node.prod;
        return this.factory.createIntTerminal(label == null ? null : label.getSort(), token, value);
    }

    private Object createNodeOrInjection(LabelInfo label, IToken prevToken, List<Object> children) {
        String constructor = label.getConstructor();
        if (label.isList()) {
            throw new IllegalStateException("Illegal state: now handled by tryCreateAutoConcatListNode()");
        }
        if (constructor != null) {
            return this.createNode(label, constructor, prevToken, children);
        }
        if (label.getAstAttribute() != null) {
            return this.createAstNonTerminal(label, prevToken, children);
        }
        if (label.isOptional()) {
            if (children == null || children.size() == 0) {
                return this.createNode(label, "None", prevToken, children);
            }
            assert (children.size() == 1);
            return this.createNode(label, "Some", prevToken, children);
        }
        if (children.size() == 1) {
            return this.factory.createInjection(label.getSort(), children);
        }
        return this.createNode(label, TUPLE_CONSTRUCTOR, prevToken, children);
    }

    private Object createNode(LabelInfo label, String constructor, IToken prevToken, List<Object> children) {
        IToken left = this.getStartToken(prevToken);
        IToken right = this.tokenizer.currentToken();
        if (constructor == LIST_CONSTRUCTOR) {
            return this.factory.createList(label.getSort(), left, right, children);
        }
        if (constructor == TUPLE_CONSTRUCTOR) {
            return this.factory.createTuple(label.getSort(), left, right, children);
        }
        if (constructor == null && children.size() == 1 && this.factory.tryGetStringValue(children.get(0)) != null) {
            return this.factory.createStringTerminal(label.getSort(), left, right, this.factory.tryGetStringValue(children.get(0)));
        }
        return this.factory.createNonTerminal(label.getSort(), constructor, left, right, children);
    }

    private Object createAstNonTerminal(LabelInfo label, IToken prevToken, List<Object> children) {
        IToken left = this.getStartToken(prevToken);
        IToken right = this.tokenizer.currentToken();
        AstAnnoImploder<Object> imploder = new AstAnnoImploder<Object>(this.factory, this.termFactory, children, left, right);
        return imploder.implode(label.getAstAttribute(), label.getSort());
    }

    private String getPaddedLexicalValue(LabelInfo label, String contents, int startOffset) {
        if (label.isIndentPaddingLexical()) {
            if (startOffset == 0) {
                return contents;
            }
            int lineStart = this.input.lastIndexOf(10, startOffset - 1) + 1;
            StringBuilder result = new StringBuilder();
            result.append(this.input, lineStart, startOffset);
            int i = 0;
            while (i < result.length()) {
                char c = result.charAt(i);
                if (c != ' ' && c != '\t') {
                    result.setCharAt(i, ' ');
                }
                ++i;
            }
            result.append(contents);
            return result.toString();
        }
        return contents;
    }

    private IToken getStartToken(IToken prevToken) {
        if (prevToken == null) {
            return this.tokenizer.getTokenCount() == 0 ? null : this.tokenizer.getTokenAt(0);
        }
        int index = prevToken.getIndex();
        if (this.tokenizer.getTokenCount() - index <= 1) {
            return this.tokenizer.makeToken(this.offset - 1, 7, true);
        }
        return this.tokenizer.getTokenAt(index + 1);
    }

    protected final void consumeLexicalChar(int character) {
        if (this.offset >= this.input.length()) {
            this.markUnexpectedEOF(character);
        } else {
            char parsedChar = (char)character;
            char inputChar = this.stringIterator.truncateUnicodeChar(this.input.charAt(this.offset));
            if (parsedChar != inputChar) {
                if (RecoveryConnector.isLayoutCharacter(parsedChar)) {
                    this.tokenizer.tryMakeSkippedRegionToken(this.offset);
                    ++this.offset;
                } else if (this.nonMatchingOffset == -1) {
                    this.nonMatchingOffset = this.offset;
                    this.nonMatchingChar = parsedChar;
                    this.nonMatchingCharExpected = inputChar;
                }
            } else {
                ++this.offset;
            }
        }
    }

    private void markUnexpectedEOF(int character) {
        if (this.tokenizer.currentToken().getKind() != 12) {
            if (this.tokenizer.getStartOffset() >= this.input.length()) {
                this.tokenizer.setStartOffset(Math.max(this.input.length() - 1, 0));
            }
            this.tokenizer.makeToken(this.input.length() - 1, 12, true);
        }
    }
}

