/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.tests;

import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.InvalidParseTableException;
import org.spoofax.jsglr.client.ParserException;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.incremental.IncrementalSGLR;
import org.spoofax.jsglr.client.incremental.IncrementalSGLRException;
import org.spoofax.jsglr.client.incremental.IncrementalSortSet;
import org.spoofax.jsglr.tests.ParseTestCase;

public class TestIncrementalSGLR
extends ParseTestCase {
    private static String[] CLASSBODY_SORTS = new String[]{"ClassBodyDec"};
    private static String[] MOST_SORTS = new String[]{"MethodDec", "ClassBodyDec", "ClassMemberDec", "ConstrDec", "FieldDec", "ImportDec", "PackageDec", "ImportDec*"};
    private static IStrategoTerm java4Result;
    private static IStrategoTerm java5Result;
    private static IStrategoTerm java7Result;
    private static IStrategoTerm java8Result;

    public void gwtSetUp() throws ParserException, InvalidParseTableException {
        super.gwtSetUp("Java-15", "java", CLASSBODY_SORTS);
        TestIncrementalSGLR.assertTrue("Java -ea assertions must be enabled for these tests", IncrementalSGLR.class.desiredAssertionStatus());
    }

    private IStrategoTerm getJava4Result() {
        if (java4Result == null) {
            java4Result = this.doParseTest("java4");
        }
        return java4Result;
    }

    private IStrategoTerm getJava5Result() {
        if (java5Result == null) {
            java5Result = this.doParseTest("java5");
        }
        return java5Result;
    }

    private IStrategoTerm getJava7Result() {
        if (java7Result == null) {
            java7Result = this.doParseTest("java7");
        }
        return java7Result;
    }

    private IStrategoTerm getJava8Result() {
        if (java8Result == null) {
            java8Result = this.doParseTest("java8");
        }
        return java8Result;
    }

    public void testJava51() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment", "MethodDec", "ClassMemberDec");
    }

    public void testJava52() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment2", "MethodDec", "ClassMemberDec");
    }

    public void testJava53() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment3", "MethodDec", "ClassMemberDec");
    }

    public void testJava54() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment4", "MethodDec", "ClassMemberDec");
    }

    public void testJava55() throws Exception {
        IStrategoTerm result = this.doParseIncrementalTest(this.getJava5Result(), "java5-increment5", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertFalse("There is no foo", result.toString().contains("\"foo\""));
        TestIncrementalSGLR.assertFalse("There is no baz", result.toString().contains("\"bar\""));
        TestIncrementalSGLR.assertTrue("There is only foobaz", result.toString().contains("\"foobaz\""));
    }

    public void testJava56() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment6", "ClassDec");
    }

    public void testJava57() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment7", "ClassDec");
    }

    public void testJava58() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment8", "ClassDec");
    }

    public void testJava59() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment9", "ClassDec");
    }

    public void testJava510() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment10", "ClassDec");
    }

    public void testJava511() throws Exception {
        this.doParseIncrementalTest(this.getJava5Result(), "java5-increment11", "MethodDec", "ClassMemberDec");
    }

    public void testJava6Recovery() throws Exception {
        this.suffix = "java.recover";
        this.sglr.setUseStructureRecovery(true);
        this.doCompare = false;
        IStrategoTerm java6 = this.doParseTest("java6");
        IStrategoTerm java61 = this.doParseIncrementalTest(java6, "java6-increment", new String[0]);
        TestIncrementalSGLR.assertFalse(java6.toString().contains("baz"));
        TestIncrementalSGLR.assertTrue(java61.toString().contains("baz"));
        TestIncrementalSGLR.assertTrue(ImploderAttachment.getLeftToken(java61).getTokenizer().toString().toString().contains("sense"));
    }

    public void testJava7() throws Exception {
        IStrategoTerm java7 = this.getJava7Result();
        this.doParseIncrementalTest(java7, "java7-increment", "MethodDec", "ClassMemberDec");
    }

    public void testJava72() throws Exception {
        IStrategoTerm java7 = this.getJava7Result();
        this.doParseIncrementalTest(java7, "java7-increment2", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertFalse(this.isReparsed("foo"));
    }

    public void testJava73() throws Exception {
        IStrategoTerm java7 = this.getJava7Result();
        this.doParseIncrementalTest(java7, "java7-increment3", "MethodDec", "ClassMemberDec");
        int reparsed = this.incrementalSGLR.getLastReconstructedNodes().size();
        TestIncrementalSGLR.assertTrue("Expected 1 reparsed node: " + reparsed, reparsed <= 4);
    }

    public void testJava8() throws Exception {
        IStrategoTerm java8 = this.getJava8Result();
        IStrategoTerm java8Increment = this.doParseIncrementalTest(java8, "java8-increment", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertTrue("Comment should be in input tokens", ImploderAttachment.getLeftToken(java8).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertTrue("Comment should be in output tokens", ImploderAttachment.getLeftToken(java8Increment).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertTrue(this.isReparsed("foo"));
        TestIncrementalSGLR.assertFalse(this.isReparsed("qux"));
    }

    public void testJava82() throws Exception {
        IStrategoTerm java8 = this.getJava8Result();
        IStrategoTerm java8Increment = this.doParseIncrementalTest(java8, "java8-increment2", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertTrue("Comment should be in input tokens", ImploderAttachment.getLeftToken(java8).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertTrue("Comment should be in output tokens", ImploderAttachment.getLeftToken(java8Increment).getTokenizer().toString().contains("comment"));
    }

    public void testJava83() throws Exception {
        IStrategoTerm java8 = this.getJava8Result();
        IStrategoTerm java8Increment = this.doParseIncrementalTest(java8, "java8-increment3", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertTrue("Comment should be in input tokens", ImploderAttachment.getLeftToken(java8).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertTrue("Comment should be in output tokens", ImploderAttachment.getLeftToken(java8Increment).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertFalse(this.isReparsed("qux"));
    }

    public void testJava84() throws Exception {
        IStrategoTerm java8 = this.getJava8Result();
        IStrategoTerm java8Increment = this.doParseIncrementalTest(java8, "java8-increment4", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertTrue("Comment should be in input tokens", ImploderAttachment.getLeftToken(java8).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertTrue("Comment should be in output tokens", ImploderAttachment.getLeftToken(java8Increment).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertFalse(this.isReparsed("qux"));
    }

    public void testJava85() throws Exception {
        IStrategoTerm java8 = this.getJava8Result();
        IStrategoTerm java8Increment = this.doParseIncrementalTest(java8, "java8-increment5", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertTrue("Comment should be in input tokens", ImploderAttachment.getLeftToken(java8).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertTrue("Comment should be in output tokens", ImploderAttachment.getLeftToken(java8Increment).getTokenizer().toString().contains("comment"));
        TestIncrementalSGLR.assertFalse(this.isReparsed("qux"));
    }

    public void testJava912Recovery() throws Exception {
        this.suffix = "java.recover";
        this.sglr.setUseStructureRecovery(true);
        this.doCompare = false;
        IStrategoTerm java9 = this.doParseTest("java9");
        IStrategoTerm java91 = this.doParseIncrementalTest(java9, "java9-increment", new String[0]);
        this.doParseIncrementalTest(java91, "java9-increment2", new String[0]);
    }

    public void testJava912RecoveryFail() throws Exception {
        this.incrementalSGLR.setIncrementalSorts(IncrementalSortSet.create(this.table, false, CLASSBODY_SORTS));
        try {
            this.testJava912Recovery();
            TestIncrementalSGLR.fail("Exception expected");
        }
        catch (IncrementalSGLRException e) {
            System.out.println(e.getMessage());
        }
    }

    public void testJava93Recovery() throws Exception {
        this.suffix = "java.recover";
        this.sglr.setUseStructureRecovery(true);
        this.doCompare = false;
        IStrategoTerm java9 = this.doParseTest("java9");
        this.doParseIncrementalTest(java9, "java9-increment3", new String[0]);
    }

    public void testJava93RecoveryFail() throws Exception {
        this.incrementalSGLR.setIncrementalSorts(IncrementalSortSet.create(this.table, false, CLASSBODY_SORTS));
        try {
            this.testJava93Recovery();
            TestIncrementalSGLR.fail("Exception expected");
        }
        catch (IncrementalSGLRException e) {
            System.out.println(e.getMessage());
        }
    }

    public void testJava4() throws Exception {
        IncrementalSGLR.DEBUG = false;
        this.doParseIncrementalTest(this.getJava4Result(), "java4-increment", "MethodDec", "ClassMemberDec");
        TestIncrementalSGLR.assertTrue(this.isReparsed("foo"));
        int reparsed = this.incrementalSGLR.getLastReconstructedNodes().size();
        TestIncrementalSGLR.assertTrue("Expected 4 or fewer reparsed nodes: " + reparsed, reparsed <= 4);
    }

    public void testJava4vs5Fail1() throws Exception {
        try {
            IncrementalSGLR.DEBUG = false;
            this.incrementalSGLR.setIncrementalSorts(IncrementalSortSet.create(this.table, true, MOST_SORTS));
            this.doParseIncrementalTest(this.getJava4Result(), "java5-increment", new String[0]);
            TestIncrementalSGLR.fail("Exception expected");
        }
        catch (IncrementalSGLRException e) {
            System.out.println(e.getMessage());
            TestIncrementalSGLR.assertTrue("Must fail on precondition", e.getMessage().indexOf("Precondition") != -1);
        }
    }

    public void testJava4vs5Fail2() throws Exception {
        try {
            IncrementalSGLR.DEBUG = false;
            this.incrementalSGLR.setIncrementalSorts(IncrementalSortSet.create(this.table, false, CLASSBODY_SORTS));
            this.doParseIncrementalTest(this.getJava4Result(), "java5-increment", new String[0]);
            TestIncrementalSGLR.fail("Exception expected");
        }
        catch (IncrementalSGLRException e) {
            System.out.println(e.getMessage());
            TestIncrementalSGLR.assertTrue("Must fail on precondition", e.getMessage().indexOf("Precondition") != -1);
        }
    }

    private boolean isReparsed(String substring) {
        return this.incrementalSGLR.getLastReconstructedNodes().toString().indexOf(substring) != -1;
    }
}

