/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.attachments;

import org.spoofax.NotImplementedException;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.attachments.AbstractWrappedTermFactory;
import org.spoofax.terms.attachments.DesugaredOriginAttachment;
import org.spoofax.terms.attachments.OriginAttachment;

public abstract class OriginTermFactory
extends AbstractWrappedTermFactory {
    private static boolean REASSIGN_ORIGINS = false;
    private boolean assignDesugaredOrigins = false;

    public void setAssignDesugaredOrigins(boolean assignDesugaredOrigins) {
        this.assignDesugaredOrigins = assignDesugaredOrigins;
    }

    public OriginTermFactory(ITermFactory baseFactory) {
        super(0, baseFactory);
        assert (!(baseFactory instanceof OriginTermFactory));
    }

    public ITermFactory getFactoryWithStorageType(int storageType) {
        assert (this.getDefaultStorageType() <= storageType);
        return this;
    }

    public abstract boolean isOriginRoot(IStrategoTerm var1);

    public IStrategoAppl replaceAppl(IStrategoConstructor constructor, IStrategoTerm[] kids, IStrategoAppl oldTerm) {
        IStrategoList annos = oldTerm.getAnnotations();
        IStrategoAppl result = this.makeAppl(constructor, this.ensureChildLinks(kids, oldTerm), annos);
        return (IStrategoAppl)this.ensureLink(result, oldTerm, false);
    }

    public IStrategoTuple replaceTuple(IStrategoTerm[] kids, IStrategoTuple old) {
        IStrategoTuple result = this.makeTuple(this.ensureChildLinks(kids, old), old.getAnnotations());
        return (IStrategoTuple)this.ensureLink(result, old, false);
    }

    public IStrategoList replaceListCons(IStrategoTerm head, IStrategoList tail, IStrategoTerm oldHead, IStrategoList oldTail) {
        IStrategoList result = this.makeListCons(head, tail);
        if (oldHead != head) {
            this.replaceTerm(head, oldHead);
        }
        return result;
    }

    public IStrategoTerm replaceTerm(IStrategoTerm term, IStrategoTerm origin) {
        if (term == null) {
            return term;
        }
        if (term == origin) {
            return term;
        }
        if (term.isList()) {
            if (term.getSubtermCount() == origin.getSubtermCount() && origin.isList()) {
                return this.makeListLink((IStrategoList)term, (IStrategoList)origin);
            }
            return term;
        }
        if (this.haveSameSignature(term, origin)) {
            this.ensureChildLinks(term.getAllSubterms(), origin);
            return this.ensureLink(term, origin, false);
        }
        return this.ensureLink(term, origin, false);
    }

    private boolean haveSameSignature(IStrategoTerm term, IStrategoTerm origin) {
        if (term instanceof StrategoAppl && origin instanceof StrategoAppl && !((StrategoAppl)term).getConstructor().equals(((StrategoAppl)origin).getConstructor())) {
            return false;
        }
        return term.getTermType() == origin.getTermType() && term.getSubtermCount() == origin.getSubtermCount();
    }

    public IStrategoTerm makeLink(IStrategoTerm term, IStrategoTerm origin) {
        assert (this.isOriginRoot(origin));
        if (term.isList()) {
            if (term.getSubtermCount() == origin.getSubtermCount() && origin.isList()) {
                return this.makeListLink((IStrategoList)term, (IStrategoList)origin);
            }
        } else if (OriginAttachment.get(term) == null) {
            if (term.getStorageType() == 0) {
                OriginAttachment.setOrigin(term, origin);
            }
        } else if (REASSIGN_ORIGINS) {
            throw new NotImplementedException("Not implemented: unwrapping of possibly already wrapped term");
        }
        return term;
    }

    public IStrategoTerm makeLinkDesugared(IStrategoTerm term, IStrategoTerm desugared) {
        if (!term.isList() && DesugaredOriginAttachment.get(term) == null) {
            if (term.getStorageType() == 0) {
                DesugaredOriginAttachment.setDesugaredOrigin(term, desugared);
            }
        } else if (REASSIGN_ORIGINS) {
            throw new NotImplementedException("Not implemented: unwrapping of possibly already wrapped term");
        }
        return term;
    }

    public IStrategoList replaceList(IStrategoTerm[] terms, IStrategoList old) {
        assert (terms.length == old.getSubtermCount());
        int i = 0;
        while (i < terms.length) {
            terms[i] = this.replaceTerm(terms[i], old.head());
            old = old.tail();
            ++i;
        }
        return this.makeList(terms, old.getAnnotations());
    }

    private IStrategoList makeListLink(IStrategoList terms, IStrategoList old) {
        if (terms.isEmpty()) {
            assert (old.isEmpty());
            return terms;
        }
        IStrategoTerm head = terms.head();
        IStrategoList tail = terms.tail();
        IStrategoTerm newHead = this.ensureLink(head, old.head(), false);
        IStrategoList newTail = this.makeListLink(tail, old.tail());
        if (head == newHead && tail == newTail) {
            return terms;
        }
        return this.makeListCons(newHead, newTail, terms.getAnnotations());
    }

    protected IStrategoTerm[] ensureChildLinks(IStrategoTerm[] kids, IStrategoTerm old) {
        assert (!old.isList());
        IStrategoTerm[] oldKids = old.getAllSubterms();
        if (oldKids == kids) {
            return kids;
        }
        int i = 0;
        while (i < kids.length) {
            kids[i] = this.ensureLink(kids[i], oldKids[i], true);
            ++i;
        }
        return kids;
    }

    protected IStrategoTerm ensureLink(IStrategoTerm term, IStrategoTerm old, boolean isChildLink) {
        IStrategoTerm originRoot;
        if (term == old || this.isOriginRoot(term)) {
            return term;
        }
        if (this.assignDesugaredOrigins) {
            if (!isChildLink) {
                DesugaredOriginAttachment.setDesugaredOrigin(term, term);
            }
        } else {
            IStrategoTerm desugared = DesugaredOriginAttachment.getDesugaredOrigin(old);
            if (desugared != null) {
                term = this.makeLinkDesugared(term, desugared);
            }
        }
        return (originRoot = this.getOriginRoot(old)) == null ? term : this.makeLink(term, originRoot);
    }

    protected IStrategoTerm getOriginRoot(IStrategoTerm term) {
        if (this.isOriginRoot(term)) {
            return term;
        }
        IStrategoTerm result = OriginAttachment.getOrigin(term);
        assert (result == null || this.isOriginRoot(result));
        return result;
    }

    public IStrategoTerm annotateTerm(IStrategoTerm term, IStrategoList annotations) {
        IStrategoTerm result = super.annotateTerm(term, annotations);
        this.ensureLink(result, term, false);
        return result;
    }
}

