/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.attachments;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.attachments.ITermAttachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TermAttachmentType<T extends ITermAttachment> {
    private static Set<TermAttachmentType<?>> asyncTypes = new CopyOnWriteArraySet();
    private final Class<T> type;
    private final IStrategoConstructor constructor;

    protected TermAttachmentType(Class<T> type, String constructorName, int constructorArity) {
        this.type = type;
        this.constructor = constructorName == null ? null : new TermFactory().makeConstructor(constructorName, constructorArity);
    }

    public static TermAttachmentType<?>[] getKnownTypes() {
        Set<TermAttachmentType<?>> copy = asyncTypes;
        return copy.toArray(new TermAttachmentType[copy.size()]);
    }

    public boolean isSerializationSupported() {
        return this.constructor != null;
    }

    public IStrategoConstructor getTermConstructor() {
        return this.constructor;
    }

    public final IStrategoAppl toTerm(ITermFactory factory, ITermAttachment attachment) {
        assert (this == attachment.getAttachmentType());
        return factory.makeAppl(this.constructor, this.toSubterms(factory, attachment));
    }

    public final T fromTerm(IStrategoAppl term) {
        if (term.getConstructor() == this.constructor) {
            return this.fromSubterms(term.getAllSubterms());
        }
        return null;
    }

    protected abstract IStrategoTerm[] toSubterms(ITermFactory var1, T var2);

    protected abstract T fromSubterms(IStrategoTerm[] var1);

    public String toString() {
        return this.type.getName();
    }
}

