/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.Arrays;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.HybridInterpreter;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.DynamicStrategy;
import org.strategoxt.lang.InteropSDefT;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;

public class InteropStrategy
extends DynamicStrategy {
    private final SDefT definition;

    public InteropStrategy(SDefT sDefT) {
        this.definition = sDefT;
    }

    public static Strategy[] toInteropStrategies(SDefT[] sDefTArray) {
        Strategy[] strategyArray = new Strategy[sDefTArray.length];
        int n = 0;
        while (n < sDefTArray.length) {
            SDefT sDefT = sDefTArray[n];
            strategyArray[n] = sDefT instanceof InteropSDefT ? ((InteropSDefT)sDefT).getStrategy() : new InteropStrategy(sDefTArray[n]);
            ++n;
        }
        return strategyArray;
    }

    public IStrategoTerm invokeDynamic(Context context, IStrategoTerm iStrategoTerm, Strategy[] strategyArray, IStrategoTerm[] iStrategoTermArray) {
        IContext iContext = HybridInterpreter.getContext(context);
        VarScope varScope = iContext.getVarScope();
        try {
            VarScope varScope2 = this.definition.getScope();
            if (strategyArray.length != 0 || iStrategoTermArray.length != 0) {
                varScope2 = new VarScope(varScope2);
                this.assignParameters(context, varScope2, strategyArray, iStrategoTermArray);
                iContext.setVarScope(varScope2);
            }
            iContext.setCurrent(iStrategoTerm);
            iContext.setVarScope(varScope2);
            boolean bl = this.definition.evaluate(iContext);
            IStrategoTerm iStrategoTerm2 = bl ? iContext.current() : null;
            return iStrategoTerm2;
        }
        catch (InterpreterErrorExit interpreterErrorExit) {
            throw new StrategoErrorExit(interpreterErrorExit.getMessage(), interpreterErrorExit.getTerm(), (Throwable)interpreterErrorExit);
        }
        catch (InterpreterExit interpreterExit) {
            throw new StrategoExit(interpreterExit.getValue(), (Throwable)interpreterExit);
        }
        catch (InterpreterException interpreterException) {
            throw new StrategoException("Exception in interpreter: " + interpreterException.getMessage(), interpreterException);
        }
        finally {
            iContext.restoreVarScope(varScope);
        }
    }

    private void assignParameters(Context context, VarScope varScope, Strategy[] strategyArray, IStrategoTerm[] iStrategoTermArray) throws InterpreterException {
        SDefT.SVar[] sVarArray = this.definition.getStrategyParams();
        String[] stringArray = this.definition.getTermParams();
        IContext iContext = HybridInterpreter.getContext(context);
        SDefT[] sDefTArray = InteropSDefT.toInteropSDefTs(strategyArray, iContext);
        if (sVarArray.length != strategyArray.length || stringArray.length != iStrategoTermArray.length) {
            throw new InterpreterException("Illegal number of arguments passed to strategy " + this.getName() + ": " + Arrays.toString(strategyArray) + "|" + Arrays.toString(iStrategoTermArray));
        }
        int n = 0;
        while (n < sVarArray.length) {
            varScope.addSVar(sVarArray[n].name, sDefTArray[n]);
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            varScope.add(stringArray[n], iStrategoTermArray[n]);
            ++n;
        }
    }

    public String getName() {
        return this.definition.getName();
    }

    public SDefT getDefinition() {
        return this.definition;
    }
}

