/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.SRTS_all;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelContext;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJob;
import org.strategoxt.lang.parallel.stratego_parallel.ParallelJobExecutor;
import org.strategoxt.lang.parallel.stratego_parallel.stratego_parallel;

public class ParallelAll
extends SRTS_all {
    public static ParallelAll instance;
    private static final WeakHashMap<IStrategoTerm, Integer> termSizes;
    private final ParallelJobExecutor executor = new ParallelJobExecutor();
    private int termSizeThreshold = 3200;
    private int subtermCountThreshold = 12;
    private double jobLengthMultiplier = 1.0;
    private AtomicInteger parallelismLevel = new AtomicInteger(0);
    private boolean isForcedParallel;
    private volatile boolean allowUnordered;

    static {
        termSizes = new WeakHashMap();
    }

    public IStrategoTerm invoke(Context context, IStrategoTerm iStrategoTerm, Strategy strategy) {
        if (!stratego_parallel.isActive() && (this.isForcedParallel || this.isCandidateTerm(context, iStrategoTerm))) {
            this.isForcedParallel = false;
            context.push("<parallel>");
            IStrategoTerm iStrategoTerm2 = this.invokeParallel(context, iStrategoTerm, strategy);
            if (iStrategoTerm2 == null) {
                context.popOnFailure();
            } else {
                context.popOnSuccess();
            }
            return iStrategoTerm2;
        }
        iStrategoTerm.getAllSubterms();
        return super.invoke(context, iStrategoTerm, strategy);
    }

    public void setForcedParallel(boolean bl) {
        this.isForcedParallel = bl;
    }

    public ParallelJobExecutor getExecutor() {
        return this.executor;
    }

    public IStrategoTerm invokeParallel(Context context, IStrategoTerm iStrategoTerm, Strategy strategy) {
        IStrategoTerm[] iStrategoTermArray = iStrategoTerm.getAllSubterms();
        IStrategoTerm[] iStrategoTermArray2 = new IStrategoTerm[iStrategoTermArray.length];
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        AtomicReference<String> atomicReference = null;
        AtomicReference<Throwable> atomicReference2 = new AtomicReference<Throwable>();
        ParallelJob parallelJob = null;
        stratego_parallel.setActive(true);
        boolean bl = this.allowUnordered;
        try {
            try {
                double d = (double)iStrategoTermArray.length / (double)(this.executor.getMaximumPoolSize() + 1) * this.jobLengthMultiplier;
                int n = 1 + (int)d;
                System.out.print("<" + iStrategoTermArray.length / n);
                int n2 = 0;
                while (n2 < iStrategoTermArray.length) {
                    int n3 = n2;
                    ParallelJob parallelJob2 = new ParallelJob(context, strategy, iStrategoTermArray, iStrategoTermArray2, atomicInteger, atomicBoolean, atomicReference, atomicReference2, bl, n3, n, this.parallelismLevel.get());
                    if (parallelJob == null) {
                        parallelJob = parallelJob2;
                    } else {
                        this.executor.execute(parallelJob2);
                    }
                    n2 += n;
                }
                parallelJob.run();
                this.executor.join();
                parallelJob.waitForCompletedFocusIndex();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        finally {
            stratego_parallel.setActive(false);
        }
        if (atomicBoolean.get()) {
            if (atomicReference2.get() != null) {
                if (atomicReference2.get() instanceof StrategoExit) {
                    throw new StrategoExit((StrategoExit)atomicReference2.get());
                }
                throw new StrategoException("Exception in asynchronous job", atomicReference2.get());
            }
            return null;
        }
        assert (iStrategoTerm.getTermType() == 2);
        return context.getFactory().makeList(iStrategoTermArray2);
    }

    public void setAllowUnordered(boolean bl) {
        this.allowUnordered = bl;
    }

    protected boolean isCandidateTerm(Context context, IStrategoTerm iStrategoTerm) {
        if (iStrategoTerm.getTermType() == 2 && iStrategoTerm.getStorageType() != 0 && iStrategoTerm.getSubtermCount() >= this.subtermCountThreshold && this.getTermSize(iStrategoTerm, 1) >= this.termSizeThreshold) {
            if (this.parallelismLevel.get() > 2) {
                return false;
            }
            if (this.parallelismLevel.get() > 1 && !((ParallelContext)context).getJob().isFocusJob()) {
                return false;
            }
            IStrategoList iStrategoList = (IStrategoList)iStrategoTerm;
            while (!iStrategoList.isEmpty()) {
                if (!iStrategoList.getAnnotations().isEmpty()) {
                    return false;
                }
                iStrategoList = iStrategoList.tail();
            }
            return true;
        }
        return false;
    }

    protected int getTermSize(IStrategoTerm iStrategoTerm, int n) {
        int n2 = iStrategoTerm.getSubtermCount();
        if (n2 == 0) {
            return n;
        }
        Integer n3 = termSizes.get(iStrategoTerm);
        if (n3 != null) {
            return n + n3;
        }
        int n4 = n + n2;
        if (iStrategoTerm.getTermType() == 2) {
            IStrategoList iStrategoList = (IStrategoList)iStrategoTerm;
            while (!iStrategoList.isEmpty()) {
                IStrategoTerm iStrategoTerm2 = iStrategoList.head();
                n4 = this.getTermSize(iStrategoTerm2, n4);
                if (n4 >= this.termSizeThreshold) {
                    termSizes.put(iStrategoTerm, n4);
                    return n4;
                }
                iStrategoList = iStrategoList.tail();
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                IStrategoTerm iStrategoTerm3 = iStrategoTerm.getSubterm(n5);
                n4 = this.getTermSize(iStrategoTerm3, n4);
                if (n4 >= this.termSizeThreshold) {
                    termSizes.put(iStrategoTerm, n4);
                    return n4;
                }
                ++n5;
            }
        }
        termSizes.put(iStrategoTerm, n4);
        return n4;
    }
}

