/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spoofax.DebugUtil;
import org.spoofax.interpreter.core.BindingInfo;
import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarScope {
    private VarScope parent;
    private Map<String, IStrategoTerm> vars;
    private Map<String, SDefT> svars;

    public VarScope(VarScope parent) {
        this.parent = parent;
        this.vars = new HashMap<String, IStrategoTerm>(0);
        this.svars = new HashMap<String, SDefT>(0);
    }

    public IStrategoTerm lookup(String name) {
        IStrategoTerm t = this.vars.get(name);
        if (t == null && this.parent != null) {
            t = this.parent.lookup(name);
        }
        if (DebugUtil.isDebugging()) {
            Context.debug(DebugUtil.buildIndent(2), "lookup : ", name, " = ", t);
        }
        return t;
    }

    public SDefT lookupSVar(String name) {
        SDefT t = this.svars.get(name);
        if (t == null && this.parent != null) {
            return this.parent.lookupSVar(name);
        }
        return t;
    }

    public void addSVar(String svar, SDefT strat) {
        this.svars.put(svar, strat);
    }

    public void addSVars(SDefT[] sdefs) {
        int i = 0;
        int sz = sdefs.length;
        while (i < sz) {
            this.svars.put(sdefs[i].getName(), sdefs[i]);
            ++i;
        }
    }

    public void add(String var, IStrategoTerm t) {
        this.vars.put(var, t);
    }

    public void addVars(List<String> vars) {
        for (String var : vars) {
            this.vars.put(var, null);
        }
    }

    public String printVars() {
        StringBuilder sb = new StringBuilder("");
        Iterator<String> it = this.vars.keySet().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(":");
        return sb.toString();
    }

    public boolean hasVarInLocalScope(String name) {
        return this.vars.containsKey(name) && this.vars.get(name) != null;
    }

    public VarScope getParent() {
        return this.parent;
    }

    public VarScope scopeOf(String name) {
        if (this.vars.containsKey(name)) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.scopeOf(name);
        }
        return null;
    }

    public String dump(String prefix, boolean localOnly) {
        String pre = prefix;
        if (!localOnly && this.parent != null) {
            pre = this.parent.dump(prefix);
        }
        if (DebugUtil.isDebugging()) {
            this.debug(pre, "=== ", this);
            for (String t : this.vars.keySet()) {
                this.debug(pre, "[v] ", t, "   ", this.vars.get(t));
            }
            for (String t : this.svars.keySet()) {
                this.debug(pre, "[s] ", t, "   ", this.svars.get(t));
            }
            if (this.svars.size() == 0 && this.vars.size() == 0) {
                this.debug(pre, "<empty>");
            }
        }
        return String.valueOf(pre) + "  ";
    }

    public String dump(String prefix) {
        return this.dump(prefix, false);
    }

    private void debug(Object ... s) {
        DebugUtil.debug(s);
    }

    public void clear() {
        this.vars.clear();
        this.svars.clear();
    }

    public List<BindingInfo> saveUnboundVars() {
        return this.saveUnboundVars(new ArrayList<BindingInfo>());
    }

    private List<BindingInfo> saveUnboundVars(ArrayList<BindingInfo> results) {
        for (String k : this.vars.keySet()) {
            if (this.vars.get(k) != null) continue;
            results.add(new BindingInfo(this, k));
        }
        if (this.parent != null) {
            return this.parent.saveUnboundVars(results);
        }
        return results;
    }

    public void restoreUnboundVars(List<BindingInfo> bindings) {
        for (BindingInfo binding : bindings) {
            binding.value = binding.scope.overrideVar(binding.name, null);
        }
    }

    public void setBoundVarsAfterBacktracking(List<BindingInfo> bindings) {
        for (BindingInfo binding : bindings) {
            String name = binding.name;
            IStrategoTerm value = binding.value;
            if (value == null || this.vars.get(name) != null) continue;
            this.overrideVar(name, value);
        }
    }

    private IStrategoTerm overrideVar(String name, IStrategoTerm value) {
        return this.vars.put(name, value);
    }

    public Collection<SDefT> getStrategyDefinitions() {
        return this.svars.values();
    }
}

