/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.language;

import java.net.URI;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.library.language.SemanticIndexEntry;
import org.spoofax.interpreter.library.language.SemanticIndexEntryParent;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.terms.attachments.TermAttachmentStripper;

public class SemanticIndexEntryFactory {
    private final ITermFactory termFactory;
    private final TermAttachmentStripper stripper;
    private final IStrategoConstructor defCon;
    private final IStrategoConstructor useCon;
    private final IStrategoConstructor defDataCon;
    private final IStrategoConstructor badDefCon;
    private final IStrategoConstructor badUseCon;

    public SemanticIndexEntryFactory(ITermFactory termFactory) {
        this.termFactory = termFactory;
        this.stripper = new TermAttachmentStripper(termFactory);
        this.defCon = termFactory.makeConstructor("Def", 1);
        this.useCon = termFactory.makeConstructor("Use", 1);
        this.defDataCon = termFactory.makeConstructor("DefData", 3);
        this.badDefCon = termFactory.makeConstructor("BadDef", 1);
        this.badUseCon = termFactory.makeConstructor("BadUse", 1);
    }

    public ITermFactory getTermFactory() {
        return this.termFactory;
    }

    public IStrategoConstructor getDefCon() {
        return this.defCon;
    }

    public IStrategoConstructor getDefDataCon() {
        return this.defDataCon;
    }

    public SemanticIndexEntry createEntry(IStrategoAppl entryTerm, SemanticIndexEntryParent parent, URI file) {
        return this.createEntry(this.getEntryType(entryTerm), this.getEntryNamespace(entryTerm), this.getEntryId(entryTerm), this.getEntryData(entryTerm), parent, file);
    }

    public SemanticIndexEntry createEntry(IStrategoTerm type, IStrategoTerm namespace, IStrategoList id, IStrategoTerm data, SemanticIndexEntryParent parent, URI file) {
        ImploderAttachment idAttachment = ImploderAttachment.getCompactPositionAttachment(id, true);
        ImploderAttachment dataAttachment = data == null ? null : ImploderAttachment.getCompactPositionAttachment(data, false);
        id = this.createSanitizedId(id, parent);
        data = this.stripper.strip(data);
        type = this.stripper.strip(type);
        assert (namespace == this.stripper.strip(namespace));
        id.putAttachment(idAttachment);
        if (data != null) {
            data.putAttachment(dataAttachment);
        }
        return new SemanticIndexEntry(type, namespace, id, data, file);
    }

    private IStrategoList createSanitizedId(IStrategoList id, SemanticIndexEntryParent parent) {
        if (parent != null) {
            return this.termFactory.makeListCons(this.stripper.strip(id.head()), parent.getId());
        }
        return (IStrategoList)this.stripper.strip(id);
    }

    public SemanticIndexEntryParent createEntryParent(IStrategoTerm namespace, IStrategoList id, SemanticIndexEntryParent parent) {
        assert (namespace == this.stripper.strip(namespace));
        id = this.createSanitizedId(id, parent);
        return new SemanticIndexEntryParent(namespace, id);
    }

    public IStrategoTerm getEntryType(IStrategoAppl entry) {
        IStrategoConstructor type = entry.getConstructor();
        if (type == this.defCon || type == this.badDefCon) {
            return this.defCon;
        }
        if (type == this.useCon || type == this.badUseCon) {
            return this.useCon;
        }
        if (type == this.defDataCon) {
            return entry.getSubterm(1);
        }
        throw new IllegalArgumentException("Illegal index entry: " + entry);
    }

    public IStrategoList getEntryId(IStrategoAppl entry) {
        IStrategoTerm result = entry.getSubterm(0);
        if (Tools.isTermList(result)) {
            IStrategoList full = (IStrategoList)result;
            return full.isEmpty() ? full : full.tail();
        }
        throw new IllegalArgumentException("Illegal index entry: " + entry);
    }

    public IStrategoTerm getEntryNamespace(IStrategoAppl entry) {
        IStrategoTerm result = entry.getSubterm(0);
        if (Tools.isTermList(result)) {
            IStrategoList full = (IStrategoList)result;
            return this.stripper.strip(full.isEmpty() ? full : full.head());
        }
        throw new IllegalArgumentException("Illegal index entry: " + entry);
    }

    public IStrategoTerm getEntryData(IStrategoAppl entry) {
        if (entry.getSubtermCount() == 3) {
            return entry.getSubterm(2);
        }
        assert (entry.getSubtermCount() < 3);
        return null;
    }
}

