/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ChannelPushbackInputStream
extends PushbackInputStream {
    private static final int BUFFER_SIZE = 512;
    private final FileChannel channel;
    private final ByteBuffer buffer;
    private final byte[] pushbackStack;
    private int pushbackSize = 0;

    public ChannelPushbackInputStream(FileChannel channel, int bufferSize) {
        super(null);
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(512);
        this.pushbackStack = new byte[bufferSize];
    }

    public ChannelPushbackInputStream(FileChannel channel) {
        this(channel, 1);
    }

    public int read() throws IOException {
        if (this.pushbackSize > 0) {
            return this.pushbackStack[--this.pushbackSize];
        }
        if (this.buffer.hasRemaining()) {
            return this.buffer.get();
        }
        if (this.channel.read(this.buffer) == -1) {
            return -1;
        }
        this.buffer.rewind();
        return this.buffer.get();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = off;
        do {
            if (this.pushbackSize > 0) {
                b[i++] = this.pushbackStack[--this.pushbackSize];
                continue;
            }
            if (!this.buffer.hasRemaining()) {
                if (this.channel.read(this.buffer) == -1) {
                    return i == off ? -1 : i - off;
                }
                this.buffer.rewind();
            }
            int read = Math.min(this.buffer.remaining(), len - i);
            this.buffer.get(b, i, i + read);
            i += read;
        } while (i < len);
        return i - off;
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        int i = off;
        while (i < len) {
            this.unread(b[i]);
            ++i;
        }
    }

    public void unread(int b) throws IOException {
        if (this.pushbackSize == this.pushbackStack.length) {
            throw new IOException("Pushback buffer is full");
        }
        this.pushbackStack[this.pushbackSize++] = (byte)b;
    }

    public synchronized void close() throws IOException {
        this.channel.close();
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

