/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.BottomupTreeBuilder;
import org.spoofax.jsglr.client.ParseNode;
import org.spoofax.jsglr.client.imploder.TopdownTreeBuilder;

public class CycleParseNode
extends AbstractParseNode {
    private static final AbstractParseNode[] NO_CHILDREN = new AbstractParseNode[0];
    private ParseNode target;

    public CycleParseNode(ParseNode target) {
        this.target = target;
    }

    public int getNodeType() {
        return 7;
    }

    public AbstractParseNode[] getChildren() {
        return NO_CHILDREN;
    }

    public Object toTreeBottomup(BottomupTreeBuilder builder) {
        return builder.buildCycle(this.getTargetLabel());
    }

    public int getTargetLabel() {
        AbstractParseNode target = this.target;
        while (target.isAmbNode()) {
            target = ((AbstractParseNode)target).getChildren()[0];
        }
        if (target.isParseNode()) {
            return target.getLabel();
        }
        return -1;
    }

    public Object toTreeTopdown(TopdownTreeBuilder builder) {
        return builder.buildTreeCycle(this);
    }

    public void reject() {
        throw new UnsupportedOperationException();
    }

    public String toStringShallow() {
        return this.toString();
    }

    public String toString() {
        return "cycle(" + this.target + ")";
    }

    public boolean isParseProductionChain() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CycleParseNode other = (CycleParseNode)obj;
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public int getLabel() {
        return this.target.getLabel();
    }
}

