/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.imploder;

import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokenizer;
import org.spoofax.jsglr.client.imploder.LabelInfo;
import org.spoofax.jsglr.client.imploder.LineStartOffsetList;
import org.spoofax.jsglr.client.imploder.ProductionAttributeReader;
import org.spoofax.jsglr.client.imploder.Token;
import org.spoofax.jsglr.client.imploder.TokenKindManager;

public abstract class AbstractTokenizer
implements ITokenizer {
    private final TokenKindManager manager = new TokenKindManager();
    private boolean isAmbiguous;
    private final String filename;
    private final String input;
    private LineStartOffsetList lineStartOffsets;
    private boolean isSyntaxCorrect = true;

    public AbstractTokenizer(String input, String filename) {
        this.input = input;
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getInput() {
        return this.input;
    }

    public boolean isSyntaxCorrect() {
        return this.isSyntaxCorrect;
    }

    private LineStartOffsetList getLineStartOffsets() {
        if (this.lineStartOffsets == null) {
            this.lineStartOffsets = new LineStartOffsetList(this.getInput());
        }
        return this.lineStartOffsets;
    }

    public IToken makeToken(int endOffset, LabelInfo label, boolean allowEmptyToken) {
        return this.makeToken(endOffset, this.manager.getTokenKind(label), allowEmptyToken);
    }

    public boolean isAmbigous() {
        return this.isAmbiguous;
    }

    public void setAmbiguous(boolean isAmbiguous) {
        this.isAmbiguous = isAmbiguous;
    }

    public int getLineAtOffset(int offset) {
        return this.getTokenAtOffset(offset).getLine();
    }

    public void markPossibleSyntaxError(LabelInfo label, IToken prevToken, int endOffset, ProductionAttributeReader prodReader) {
        if (label.isRecover() || label.isReject() || label.getDeprecationMessage() != null) {
            String tokenText;
            IToken first;
            IToken last;
            if (prodReader.isIgnoredUnspecifiedRecoverySort(label.getSort())) {
                return;
            }
            if (this.isSyntaxCorrect) {
                boolean bl = this.isSyntaxCorrect = label.getDeprecationMessage() != null;
            }
            if (prevToken == this.currentToken()) {
                first = last = this.makeToken(endOffset, 9, true);
            } else {
                first = AbstractTokenizer.findRightMostLayoutToken(AbstractTokenizer.getTokenAfter(prevToken));
                if (first != this.currentToken() && first.getKind() == 7) {
                    first = AbstractTokenizer.getTokenAfter(first);
                }
                last = this.currentToken();
            }
            if (first.getStartOffset() + 1 == last.getEndOffset()) {
                first = AbstractTokenizer.findLeftMostLayoutToken(first);
            }
            if ((tokenText = this.toString(first, last)).length() > 40) {
                tokenText = String.valueOf(tokenText.substring(0, 40)) + "...";
            }
            if (label.isReject() || prodReader.isWaterConstructor(label.getConstructor())) {
                this.setErrorMessage(first, last, "Syntax error, not expected here: '" + tokenText + "'");
            } else if (prodReader.isInsertEndConstructor(label.getConstructor())) {
                this.setErrorMessage(first, last, "Syntax error, unterminated construct");
            } else if (prodReader.isInsertConstructor(label.getConstructor()) || prodReader.isInsertOpenQuoteSort(label.getSort())) {
                this.setErrorMessage(first, last, "Syntax error, expected: " + prodReader.getSyntaxErrorExpectedInsertion(label));
            } else if (label.getDeprecationMessage() != null) {
                this.setErrorMessage(first, last, "Warning: " + label.getDeprecationMessage());
            } else {
                this.setErrorMessage(first, last, "Syntax error: '" + tokenText + "'");
            }
        }
    }

    protected abstract void setErrorMessage(IToken var1, IToken var2, String var3);

    public final int getEndLine() {
        return this.getTokenCount() == 0 ? 1 : this.getTokenAt(this.getTokenCount() - 1).getLine();
    }

    public final int getEndColumn() {
        return this.getTokenCount() == 0 ? 1 : this.getTokenAt(this.getTokenCount() - 1).getColumn();
    }

    public String toString(IToken left, IToken right) {
        int startOffset = left.getStartOffset();
        int endOffset = right.getEndOffset();
        return this.toString(startOffset, endOffset);
    }

    public String toString(int startOffset, int endOffset) {
        return this.getInput() == null ? null : this.getInput().substring(startOffset, endOffset + 1);
    }

    public static boolean isErrorInRange(IToken start2, IToken end) {
        ITokenizer tokens = start2.getTokenizer();
        int i = start2.getIndex();
        int max2 = end.getIndex();
        while (i <= max2) {
            IToken token = tokens.getTokenAt(i);
            if (token.getError() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IToken findLeftMostLayoutToken(IToken token) {
        if (token == null) {
            return null;
        }
        ITokenizer tokens = token.getTokenizer();
        int i = token.getIndex() - 1;
        while (i >= 0) {
            IToken neighbour = tokens.getTokenAt(i);
            switch (neighbour.getKind()) {
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    return token;
                }
            }
            token = neighbour;
            --i;
        }
        return token;
    }

    public static IToken findRightMostLayoutToken(IToken token) {
        if (token == null) {
            return null;
        }
        ITokenizer tokens = token.getTokenizer();
        int i = token.getIndex() + 1;
        int count = tokens.getTokenCount();
        while (i < count) {
            IToken neighbour = tokens.getTokenAt(i);
            switch (neighbour.getKind()) {
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    return token;
                }
            }
            token = neighbour;
            ++i;
        }
        return token;
    }

    public static IToken findLeftMostTokenOnSameLine(IToken token) {
        if (token == null) {
            return null;
        }
        int line = token.getLine();
        ITokenizer tokens = token.getTokenizer();
        int i = token.getIndex() - 1;
        while (i >= 0) {
            IToken neighbour = tokens.getTokenAt(i);
            if (neighbour.getLine() != line || i == 0) {
                return tokens.getTokenAt(i + 1);
            }
            --i;
        }
        return token;
    }

    public static IToken findRightMostTokenOnSameLine(IToken token) {
        if (token == null) {
            return null;
        }
        int line = token.getLine();
        ITokenizer tokens = token.getTokenizer();
        int i = token.getIndex() + 1;
        int count = tokens.getTokenCount();
        while (i < count) {
            IToken neighbour = tokens.getTokenAt(i);
            if (neighbour.getLine() != line || i == count - 1) {
                return tokens.getTokenAt(i - 1);
            }
            ++i;
        }
        return token;
    }

    public static IToken getTokenAfter(IToken token) {
        if (token == null) {
            return null;
        }
        int nextOffset = token.getEndOffset();
        ITokenizer tokens = token.getTokenizer();
        int i = token.getIndex() + 1;
        int max2 = tokens.getTokenCount();
        while (i < max2) {
            IToken result = tokens.getTokenAt(i);
            if (result.getStartOffset() >= nextOffset) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IToken getTokenBefore(IToken token) {
        if (token == null) {
            return null;
        }
        int prevOffset = token.getStartOffset();
        ITokenizer tokens = token.getTokenizer();
        int i = token.getIndex() - 1;
        while (i >= 0) {
            IToken result = tokens.getTokenAt(i);
            if (result.getEndOffset() <= prevOffset) {
                return result;
            }
            --i;
        }
        return null;
    }

    public static IToken getFirstTokenWithSameOffset(IToken token) {
        IToken before = token;
        do {
            if ((before = AbstractTokenizer.getTokenBefore(token = before)) != null && before != token) continue;
            return token;
        } while (before.getStartOffset() == token.getStartOffset());
        return token.getTokenizer().getTokenAt(before.getIndex() + 1);
    }

    public static IToken getLastTokenWithSameEndOffset(IToken token) {
        IToken after = token;
        do {
            if ((after = AbstractTokenizer.getTokenAfter(token = after)) != null && after != token) continue;
            return token;
        } while (after.getEndOffset() == token.getEndOffset());
        return token.getTokenizer().getTokenAt(after.getIndex() - 1);
    }

    public IToken getErrorTokenOrAdjunct(int offset) {
        if (offset < this.getStartOffset()) {
            return AbstractTokenizer.findReportableErrorToken(this.getTokenAtOffset(offset));
        }
        return this.makeErrorAdjunct(offset);
    }

    private IToken makeErrorAdjunct(int offset) {
        if (offset == this.getInput().length()) {
            return this.makeErrorAdjunctBackwards(offset - 1);
        }
        if (offset > this.getInput().length()) {
            return this.makeErrorAdjunctBackwards(this.getInput().length() - 1);
        }
        int endOffset = offset;
        String input = this.getInput();
        boolean onlySeenWhitespace = AbstractTokenizer.isSpace(input.charAt(endOffset));
        while (endOffset + 1 < this.getInput().length()) {
            char next = input.charAt(endOffset + 1);
            if (onlySeenWhitespace) {
                onlySeenWhitespace = AbstractTokenizer.isSpace(next);
                ++offset;
            } else if (!Character.isLetterOrDigit(next)) break;
            ++endOffset;
        }
        return this.makeAdjunct(offset, endOffset, 9);
    }

    private IToken makeErrorAdjunctBackwards(int offset) {
        int beginOffset = offset;
        boolean onlySeenWhitespace = true;
        while (offset >= this.getInput().length()) {
            --offset;
        }
        String input = this.getInput();
        while (beginOffset > 0) {
            char c = input.charAt(beginOffset - 1);
            boolean isWhitespace = AbstractTokenizer.isSpace(c);
            if (onlySeenWhitespace) {
                onlySeenWhitespace = isWhitespace;
            } else if (isWhitespace) break;
            --beginOffset;
        }
        return this.makeAdjunct(beginOffset, offset, 9);
    }

    protected final IToken makeAdjunct(int startOffset, int endOffset, int tokenKind) {
        LineStartOffsetList lineStarts = this.getLineStartOffsets();
        int index = lineStarts.getIndex(startOffset);
        int line = lineStarts.getLine(index);
        int column = lineStarts.getColumn(index, startOffset);
        return this.makeAdjunct(startOffset, endOffset, tokenKind, line, column);
    }

    protected IToken makeAdjunct(int startOffset, int endOffset, int tokenKind, int line, int column) {
        IToken nearbyToken = this.getTokenAtOffset(startOffset);
        int fakeIndex = nearbyToken == null ? 0 : nearbyToken.getIndex();
        return new Token(this, fakeIndex, line, column, startOffset, endOffset, tokenKind);
    }

    private static IToken findReportableErrorToken(IToken token) {
        ITokenizer tokenizer = token.getTokenizer();
        int i = token.getIndex();
        int max2 = tokenizer.getTokenCount();
        while (i < max2) {
            token = tokenizer.getTokenAt(i);
            if (token.getKind() == 8) break;
            if (token.getLength() != 0 && token.getKind() != 7) {
                return token;
            }
            ++i;
        }
        i = token.getIndex();
        while (i > 0) {
            token = tokenizer.getTokenAt(i);
            if (token.getLength() != 0 && token.getKind() != 7) {
                return token;
            }
            --i;
        }
        return token;
    }

    public void tryMakeLayoutToken(int endOffset, int lastOffset, LabelInfo label) {
        if (endOffset > lastOffset + 1 && label.isLexLayout()) {
            if (this.getStartOffset() <= lastOffset) {
                this.makeToken(lastOffset, 7, false);
            }
            this.makeToken(endOffset, 7, false);
        } else {
            String sort = label.getSort();
            if ("WATERTOKEN".equals(sort) || "WATERTOKENSEPARATOR".equals(sort)) {
                this.makeWaterToken(endOffset, lastOffset);
            }
        }
    }

    private void makeWaterToken(int endOffset, int lastOffset) {
        if (this.getStartOffset() <= lastOffset) {
            this.makeToken(lastOffset, 7, false);
        }
        String input = this.getInput();
        int wordStart = this.getStartOffset();
        while (wordStart <= endOffset && AbstractTokenizer.isSpace(input.charAt(wordStart))) {
            ++wordStart;
        }
        if (wordStart < endOffset) {
            this.makeToken(wordStart - 1, 11, false);
        }
        this.makeToken(endOffset, 9, false);
    }

    private static boolean isSpace(char c) {
        switch (c) {
            case ' ': {
                return true;
            }
            case '\n': {
                return true;
            }
            case '\t': {
                return true;
            }
            case '\f': {
                return true;
            }
            case '\r': {
                return true;
            }
        }
        return false;
    }
}

