/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.incremental;

import org.spoofax.jsglr.client.incremental.IncrementalSGLR;

public class CommentDamageExpander {
    public static final CommentDamageExpander C_STYLE = new CommentDamageExpander("/*", "*/");
    public static final CommentDamageExpander ONLY_LINE_COMMENTS = new CommentDamageExpander(null, null);
    private final String commentStart;
    private final String commentEnd;

    public CommentDamageExpander(String commentStart, String commentEnd) {
        this.commentStart = commentStart;
        this.commentEnd = commentEnd;
    }

    public int getExpandedDamageStart(String newInput, int damageStart, int damageEnd, int damageSizeChange) {
        return newInput.lastIndexOf(10, damageStart - 1) + 1;
    }

    public int getExpandedDamageEnd(String newInput, int damageStart, int damageEnd, int damageSizeChange) {
        damageStart = this.commentStart == null ? damageStart : Math.max(0, damageStart - this.commentStart.length() + 1);
        damageEnd = Math.max(damageEnd, newInput.indexOf(10, damageEnd + damageSizeChange) - damageSizeChange);
        if (this.commentStart == null) {
            return damageEnd;
        }
        int commentStartOffset = newInput.lastIndexOf(this.commentStart, damageEnd + damageSizeChange);
        int commentEndOffset = newInput.indexOf(this.commentEnd, commentStartOffset + this.commentStart.length() + 1);
        if (commentEndOffset == -1) {
            if (IncrementalSGLR.DEBUG && commentStartOffset != -1) {
                System.out.println("Unterminated comment ignored");
            }
            return damageEnd;
        }
        if (commentEndOffset + this.commentEnd.length() <= damageStart) {
            return damageEnd;
        }
        assert (commentEndOffset - damageSizeChange + this.commentEnd.length() >= damageEnd);
        return commentEndOffset - damageSizeChange + this.commentEnd.length();
    }
}

