/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.incremental;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.imploder.AbstractTokenizer;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.incremental.IncrementalSGLR;
import org.spoofax.jsglr.client.incremental.IncrementalSortSet;
import org.spoofax.terms.SimpleTermVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DamageRegionAnalyzer {
    final IncrementalSortSet incrementalSorts;
    final int damageStart;
    final int damageEnd;
    final int damageSizeChange;

    public DamageRegionAnalyzer(IncrementalSGLR<?> parser, int damageStart, int damageEnd, int damageSizeChange) {
        this.incrementalSorts = parser.incrementalSorts;
        this.damageStart = damageStart;
        this.damageEnd = damageEnd;
        this.damageSizeChange = damageSizeChange;
    }

    public List<ISimpleTerm> getDamageNodes(ISimpleTerm tree) {
        ArrayList<ISimpleTerm> results = new ArrayList<ISimpleTerm>();
        this.getDamageRegionTreeNodes(tree, results, true, 0, null);
        return results;
    }

    public List<ISimpleTerm> getDamageNodesForPartialTree(ISimpleTerm tree, int skippedChars) {
        ArrayList<ISimpleTerm> results = new ArrayList<ISimpleTerm>();
        this.getDamageRegionTreeNodes(tree, results, false, skippedChars, null);
        return results;
    }

    private ISimpleTerm getDamageRegionTreeNodes(ISimpleTerm tree, List<ISimpleTerm> results, boolean isOriginalTree, int skippedChars, ISimpleTerm outerIncrementalNode) {
        if (this.incrementalSorts.isIncrementalNode(tree)) {
            outerIncrementalNode = tree;
        }
        if (!tree.isList() && this.isDamageTreeNode(tree, isOriginalTree, skippedChars)) {
            return this.addDamageRegionTreeNode(tree, results, outerIncrementalNode);
        }
        boolean addedChild = false;
        Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(tree);
        int i = 0;
        int max2 = tree.getSubtermCount();
        while (i < max2) {
            ISimpleTerm child = iterator == null ? tree.getSubterm(i) : iterator.next();
            ISimpleTerm addedAncestor = this.getDamageRegionTreeNodes(child, results, isOriginalTree, skippedChars, outerIncrementalNode);
            if (addedAncestor != null && addedAncestor == outerIncrementalNode) {
                return addedAncestor;
            }
            addedChild = true;
            ++i;
        }
        if (!addedChild && tree.isList() && this.isDamageTreeNode(tree, isOriginalTree, skippedChars)) {
            return this.addDamageRegionTreeNode(tree, results, outerIncrementalNode);
        }
        return null;
    }

    private ISimpleTerm addDamageRegionTreeNode(ISimpleTerm tree, List<ISimpleTerm> results, ISimpleTerm outerIncrementalNode) {
        assert (results.indexOf(outerIncrementalNode) == -1 || results.get(results.indexOf(outerIncrementalNode)) != outerIncrementalNode) : "Exact copy of node to be added already added";
        if (outerIncrementalNode != null) {
            results.add(outerIncrementalNode);
        } else {
            results.add(tree);
        }
        return outerIncrementalNode;
    }

    protected boolean isDamageTreeNode(ISimpleTerm tree, boolean isOriginalTree, int skippedChars) {
        IToken current = AbstractTokenizer.findLeftMostLayoutToken(ImploderAttachment.getLeftToken(tree));
        IToken last = AbstractTokenizer.findRightMostLayoutToken(ImploderAttachment.getRightToken(tree));
        if (current != null && last != null) {
            if (!this.isDamagedRange(current.getStartOffset(), last.getEndOffset(), isOriginalTree, skippedChars)) {
                return false;
            }
            Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(tree);
            int i = 0;
            int max2 = tree.getSubtermCount();
            while (i < max2) {
                ISimpleTerm child = iterator == null ? tree.getSubterm(i) : iterator.next();
                IToken childLeft = AbstractTokenizer.findLeftMostLayoutToken(ImploderAttachment.getLeftToken(child));
                IToken childRight = AbstractTokenizer.findRightMostLayoutToken(ImploderAttachment.getRightToken(child));
                if (childLeft != null && childRight != null) {
                    if (childLeft.getIndex() > current.getIndex() && this.isDamagedRange(current.getEndOffset() + 1, childLeft.getStartOffset() - 1, isOriginalTree, skippedChars)) {
                        return true;
                    }
                    current = childRight;
                }
                ++i;
            }
            return this.isDamagedRange(current.getEndOffset() + 1, last.getEndOffset(), isOriginalTree, skippedChars);
        }
        return false;
    }

    private boolean isDamagedRange(int startOffset, int endOffset, boolean isOriginalTree, int skippedChars) {
        if (isOriginalTree) {
            return IncrementalSGLR.isRangeOverlap(this.damageStart, this.damageEnd, startOffset, endOffset);
        }
        return IncrementalSGLR.isRangeOverlap(this.damageStart - skippedChars, this.damageEnd - skippedChars + this.damageSizeChange, startOffset, endOffset);
    }
}

