/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategoList
extends StrategoTerm
implements IStrategoList,
Iterable<IStrategoTerm> {
    private static final int UNKNOWN_SIZE = -1;
    static final int EMPTY_LIST_HASH = 5041;
    private IStrategoTerm head;
    private IStrategoList tail;
    private int size = -1;

    public StrategoList(IStrategoTerm head, IStrategoList tail, IStrategoList annotations, int storageType) {
        super(annotations, storageType);
        this.head = head;
        this.tail = tail;
        if (storageType != 0) {
            this.initImmutableHashCode();
        }
    }

    @Override
    public IStrategoTerm head() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public IStrategoList tail() {
        if (this.tail == null) {
            throw new IllegalStateException();
        }
        return this.tail;
    }

    @Override
    @Deprecated
    public IStrategoList prepend(IStrategoTerm prefix) {
        return new StrategoList(prefix, this, null, TermFactory.getStorageType(prefix, this));
    }

    @Override
    public final IStrategoTerm get(int index) {
        return this.getSubterm(index);
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        int size = this.size();
        IStrategoTerm[] clone = new IStrategoTerm[size];
        IStrategoList list = this;
        int i = 0;
        while (i < size) {
            clone[i] = list.head();
            list = list.tail();
            ++i;
        }
        return clone;
    }

    @Override
    public final int size() {
        return this.getSubtermCount();
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        IStrategoList list = this;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        int i = 0;
        while (i < index) {
            if (list.isEmpty()) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + index);
            }
            list = list.tail();
            ++i;
        }
        return list.head();
    }

    @Override
    public int getSubtermCount() {
        int result = this.size;
        if (result == -1) {
            result = 0;
            IStrategoList cur = this;
            while (!cur.isEmpty()) {
                ++result;
                cur = cur.tail();
            }
            if (this.getStorageType() != 0) {
                this.size = result;
            }
            return result;
        }
        return result;
    }

    @Override
    public int getTermType() {
        return 2;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second, int commonStorageType) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        if (second.getTermType() != 2) {
            return false;
        }
        IStrategoList snd = (IStrategoList)second;
        if (this.size() != snd.size()) {
            return false;
        }
        if (!this.isEmpty()) {
            IStrategoTerm head2;
            IStrategoTerm head = this.head();
            if (head != (head2 = snd.head()) && !head.match(head2)) {
                return false;
            }
            IStrategoList tail = this.tail();
            IStrategoList tail2 = snd.tail();
            IStrategoList cons = tail;
            IStrategoList cons2 = tail2;
            while (!cons.isEmpty()) {
                IStrategoTerm cons2Head;
                IStrategoTerm consHead = cons.head();
                if (consHead != (cons2Head = cons2.head()) && !consHead.match(cons2Head)) {
                    return false;
                }
                cons = cons.tail();
                cons2 = cons2.tail();
            }
            if (commonStorageType == 2) {
                this.head = head2;
                this.tail = tail2;
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        if (annotations.match(secondAnnotations)) {
            if (commonStorageType == 2) {
                this.internalSetAnnotations(secondAnnotations);
            }
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        if (!this.isEmpty()) {
            pp.println("[");
            pp.indent(2);
            this.head().prettyPrint(pp);
            IStrategoList cur = this.tail();
            while (!cur.isEmpty()) {
                pp.print(",");
                pp.nextIndentOff();
                cur.head().prettyPrint(pp);
                pp.println("");
                cur = cur.tail();
            }
            pp.println("");
            pp.print("]");
            pp.outdent(2);
        } else {
            pp.print("[]");
        }
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append('[');
        if (!this.isEmpty()) {
            if (maxDepth == 0) {
                output.append("...");
            } else {
                this.head().writeAsString(output, maxDepth - 1);
                IStrategoList cur = this.tail();
                while (!cur.isEmpty()) {
                    output.append(',');
                    cur.head().writeAsString(output, maxDepth - 1);
                    cur = cur.tail();
                }
            }
        }
        output.append(']');
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        int prime = 71;
        int result = 1;
        result = 71 * result + (this.head == null ? 0 : this.head.hashCode());
        result = 71 * result + (this.tail == null ? 0 : this.tail.hashCode());
        return result;
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new StrategoListIterator(this);
    }
}

