/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.terms.AbstractSimpleTerm;
import org.spoofax.terms.TermFactory;

public abstract class StrategoTerm
extends AbstractSimpleTerm
implements IStrategoTerm,
Cloneable {
    private static final int UNKNOWN_HASH = -1;
    private static final int MUTABLE_HASH = 0;
    private final int storageType;
    private int hashCode = -1;
    private IStrategoList annotations;

    protected StrategoTerm(IStrategoList annotations, int storageType) {
        assert (annotations == null || !annotations.isEmpty() || annotations == TermFactory.EMPTY_LIST);
        if (annotations != TermFactory.EMPTY_LIST) {
            this.annotations = annotations;
        }
        this.storageType = storageType;
    }

    protected StrategoTerm(int storageType) {
        this(null, storageType);
    }

    public final int getStorageType() {
        return this.storageType;
    }

    public final boolean match(IStrategoTerm second) {
        if (this == second) {
            return true;
        }
        if (second == null) {
            return false;
        }
        int storageType = this.getStorageType();
        switch (storageType) {
            case 3: {
                switch (second.getStorageType()) {
                    case 3: {
                        return false;
                    }
                    case 2: {
                        return this.hashCode() == second.hashCode() && this.doSlowMatch(second, 1);
                    }
                    case 1: {
                        return this.hashCode() == second.hashCode() && this.doSlowMatch(second, 1);
                    }
                }
                return this.doSlowMatch(second, 0);
            }
            case 1: 
            case 2: {
                switch (second.getStorageType()) {
                    case 3: {
                        return this.hashCode() == second.hashCode() && this.doSlowMatch(second, storageType);
                    }
                    case 2: {
                        return this.hashCode() == second.hashCode() && this.doSlowMatch(second, storageType);
                    }
                    case 1: {
                        return this.hashCode() == second.hashCode() && this.doSlowMatch(second, 1);
                    }
                }
                return this.doSlowMatch(second, 0);
            }
        }
        return this.doSlowMatch(second, 0);
    }

    protected abstract boolean doSlowMatch(IStrategoTerm var1, int var2);

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IStrategoTerm)) {
            return false;
        }
        return this.match((IStrategoTerm)obj);
    }

    public int hashCode() {
        int result = this.hashCode;
        switch (result) {
            case 0: {
                result = this.hashFunction();
                if (this.annotations != null && this.annotations != TermFactory.EMPTY_LIST && !this.annotations.isEmpty()) {
                    result = result * 2423 + this.annotations.hashCode();
                }
                return result;
            }
            case -1: {
                result = this.hashFunction();
                if (this.annotations != null && this.annotations != TermFactory.EMPTY_LIST && !this.annotations.isEmpty()) {
                    result = result * 2423 + this.annotations.hashCode();
                }
                this.hashCode = this.getTermType() == 0 ? 0 : result;
                return result;
            }
        }
        return result;
    }

    protected final void initImmutableHashCode() {
        assert (this.getTermType() != 0);
        if (this.hashCode == -1) {
            int hashCode = this.hashFunction();
            this.hashCode = this.annotations == null || this.annotations == TermFactory.EMPTY_LIST || this.annotations.isEmpty() ? hashCode : hashCode * 2423 + this.annotations.hashCode();
        }
    }

    protected abstract int hashFunction();

    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    public String toString(int maxDepth) {
        StringBuilder result = new StringBuilder();
        try {
            this.writeAsString(result, maxDepth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    public final void writeToString(Appendable output) throws IOException {
        this.writeAsString(output, Integer.MAX_VALUE);
    }

    protected void appendAnnotations(Appendable sb, int maxDepth) throws IOException {
        IStrategoList annos = this.getAnnotations();
        if (annos.size() == 0) {
            return;
        }
        sb.append('{');
        annos.getSubterm(0).writeAsString(sb, maxDepth);
        annos = annos.tail();
        while (!annos.isEmpty()) {
            sb.append(',');
            annos.head().writeAsString(sb, maxDepth);
            annos = annos.tail();
        }
        sb.append('}');
    }

    @Deprecated
    protected void printAnnotations(ITermPrinter pp) {
        IStrategoList annos = this.getAnnotations();
        if (annos.size() == 0) {
            return;
        }
        pp.print("{");
        annos.head().prettyPrint(pp);
        annos = annos.tail();
        while (!annos.isEmpty()) {
            pp.print(",");
            annos.head().prettyPrint(pp);
            annos = annos.tail();
        }
        pp.print("}");
    }

    protected StrategoTerm clone() {
        try {
            assert (this.getStorageType() != 3);
            return (StrategoTerm)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public StrategoTerm clone(boolean stripAttachments) {
        StrategoTerm result = this.clone();
        if (stripAttachments) {
            result.clearAttachments();
        }
        return result;
    }

    public final IStrategoList getAnnotations() {
        return this.annotations == null ? TermFactory.EMPTY_LIST : this.annotations;
    }

    public final void internalSetAnnotations(IStrategoList annotations) {
        if (annotations == TermFactory.EMPTY_LIST || annotations.isEmpty()) {
            annotations = null;
        }
        assert (this.getTermType() != 5 || this.getStorageType() != 3) : "Maximally shared, unannotated string must be created using constructor";
        if (this.annotations != annotations) {
            this.annotations = annotations;
            this.hashCode = -1;
        }
    }

    public boolean isList() {
        return this.getTermType() == 2;
    }
}

