/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.attachments;

import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermConverter;
import org.spoofax.terms.StrategoListIterator;
import org.spoofax.terms.TermFactory;

public class TermAttachmentStripper {
    private final ITermFactory factory;
    private final TermConverter converter;

    public TermAttachmentStripper(ITermFactory factory) {
        this.factory = factory;
        this.converter = new TermConverter(factory);
    }

    public IStrategoTerm strip(IStrategoTerm term) {
        IStrategoList annos;
        IStrategoTerm[] newAnnos;
        IStrategoTerm[] newKids;
        if (term == null) {
            return null;
        }
        boolean isRebuildNeeded = false;
        IStrategoTerm[] kids = TermFactory.EMPTY;
        if (term.getSubtermCount() > 0 && (newKids = this.tryStripKids(kids = term.getAllSubterms())) != null) {
            isRebuildNeeded = true;
            kids = newKids;
        }
        if ((newAnnos = this.tryStripAnnos(annos = term.getAnnotations())) != null) {
            isRebuildNeeded = true;
            annos = this.factory.makeList(newAnnos);
        }
        if (!isRebuildNeeded) {
            isRebuildNeeded = term.getAttachment(null) != null;
        }
        return isRebuildNeeded ? this.converter.convertShallow(term, kids, annos) : term;
    }

    private IStrategoTerm[] tryStripKids(IStrategoTerm[] oldKids) {
        boolean isChanged = false;
        IStrategoTerm[] newKids = null;
        int i = 0;
        while (i < oldKids.length) {
            IStrategoTerm oldKid = oldKids[i];
            IStrategoTerm newKid = this.strip(oldKid);
            if (!isChanged && oldKid != newKid) {
                newKids = (IStrategoTerm[])oldKids.clone();
                isChanged = true;
            }
            if (isChanged) {
                newKids[i] = newKid;
            }
            ++i;
        }
        return newKids;
    }

    private IStrategoTerm[] tryStripAnnos(IStrategoList oldAnnos) {
        if (oldAnnos.isEmpty()) {
            return null;
        }
        boolean isChanged = false;
        IStrategoTerm[] newAnnos = new IStrategoTerm[oldAnnos.size()];
        StrategoListIterator oldIterator = new StrategoListIterator(oldAnnos);
        int i = 0;
        while (i < newAnnos.length) {
            IStrategoTerm newAnno;
            IStrategoTerm oldAnno = oldIterator.next();
            isChanged |= oldAnno != (newAnno = this.strip(oldAnno));
            newAnnos[i] = newAnno;
            ++i;
        }
        return isChanged ? newAnnos : null;
    }
}

