/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.parallel.stratego_parallel;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.spoofax.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelJobExecutor
extends ThreadPoolExecutor {
    private final int asyncMaxPoolSize;
    private final boolean isConstantPoolSize;
    private int asyncPoolSize;

    public ParallelJobExecutor() {
        this(Math.max(8, 2), Math.max(8, 2));
    }

    public ParallelJobExecutor(int n, int n2) {
        super(n - 1, n2 - 1, 60L, TimeUnit.SECONDS, ParallelJobExecutor.createQueue());
        this.isConstantPoolSize = n == n2;
        this.asyncPoolSize = n;
        this.asyncMaxPoolSize = n2;
    }

    private static BlockingQueue<Runnable> createQueue() {
        return new ArrayBlockingQueue<Runnable>(16, true);
    }

    @Override
    public synchronized int getCorePoolSize() {
        return super.getCorePoolSize();
    }

    @Override
    public synchronized int getMaximumPoolSize() {
        return super.getMaximumPoolSize();
    }

    @Override
    public void setCorePoolSize(int n) {
        throw new NotImplementedException();
    }

    @Override
    public void setMaximumPoolSize(int n) {
        throw new NotImplementedException();
    }

    public void join() {
        Runnable runnable;
        BlockingQueue<Runnable> blockingQueue = this.getQueue();
        while ((runnable = (Runnable)blockingQueue.poll()) != null) {
            runnable.run();
        }
    }

    public synchronized void asyncBeginSleep() {
        if (!this.isConstantPoolSize) {
            ++this.asyncPoolSize;
            if (this.asyncPoolSize <= this.asyncMaxPoolSize) {
                super.setCorePoolSize(this.asyncPoolSize);
            }
        }
    }

    public synchronized void asyncEndSleep() {
        if (!this.isConstantPoolSize) {
            --this.asyncPoolSize;
            if (this.asyncPoolSize <= this.asyncMaxPoolSize) {
                super.setCorePoolSize(this.asyncPoolSize);
            }
        }
    }
}

