/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTDecRefQueue;
import com.microsoft.z3.ASTMapDecRefQueue;
import com.microsoft.z3.ASTVectorDecRefQueue;
import com.microsoft.z3.ApplyResultDecRefQueue;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BitVecNum;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Constructor;
import com.microsoft.z3.ConstructorList;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FiniteDomainSort;
import com.microsoft.z3.Fixedpoint;
import com.microsoft.z3.FixedpointDecRefQueue;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterpDecRefQueue;
import com.microsoft.z3.FuncInterpEntryDecRefQueue;
import com.microsoft.z3.Goal;
import com.microsoft.z3.GoalDecRefQueue;
import com.microsoft.z3.IDisposable;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.ListSort;
import com.microsoft.z3.ModelDecRefQueue;
import com.microsoft.z3.Native;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.ParamDescrsDecRefQueue;
import com.microsoft.z3.Params;
import com.microsoft.z3.ParamsDecRefQueue;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Probe;
import com.microsoft.z3.ProbeDecRefQueue;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.SetSort;
import com.microsoft.z3.Solver;
import com.microsoft.z3.SolverDecRefQueue;
import com.microsoft.z3.Sort;
import com.microsoft.z3.StatisticsDecRefQueue;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Tactic;
import com.microsoft.z3.TacticDecRefQueue;
import com.microsoft.z3.TupleSort;
import com.microsoft.z3.UninterpretedSort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_ast_print_mode;
import java.util.Map;

public class Context
extends IDisposable {
    private BoolSort m_boolSort = null;
    private IntSort m_intSort = null;
    private RealSort m_realSort = null;
    long m_ctx = 0L;
    private ASTDecRefQueue m_AST_DRQ = new ASTDecRefQueue();
    private ASTMapDecRefQueue m_ASTMap_DRQ = new ASTMapDecRefQueue();
    private ASTVectorDecRefQueue m_ASTVector_DRQ = new ASTVectorDecRefQueue();
    private ApplyResultDecRefQueue m_ApplyResult_DRQ = new ApplyResultDecRefQueue();
    private FuncInterpEntryDecRefQueue m_FuncEntry_DRQ = new FuncInterpEntryDecRefQueue();
    private FuncInterpDecRefQueue m_FuncInterp_DRQ = new FuncInterpDecRefQueue();
    private GoalDecRefQueue m_Goal_DRQ = new GoalDecRefQueue();
    private ModelDecRefQueue m_Model_DRQ = new ModelDecRefQueue();
    private ParamsDecRefQueue m_Params_DRQ = new ParamsDecRefQueue();
    private ParamDescrsDecRefQueue m_ParamDescrs_DRQ = new ParamDescrsDecRefQueue();
    private ProbeDecRefQueue m_Probe_DRQ = new ProbeDecRefQueue();
    private SolverDecRefQueue m_Solver_DRQ = new SolverDecRefQueue();
    private StatisticsDecRefQueue m_Statistics_DRQ = new StatisticsDecRefQueue();
    private TacticDecRefQueue m_Tactic_DRQ = new TacticDecRefQueue();
    private FixedpointDecRefQueue m_Fixedpoint_DRQ = new FixedpointDecRefQueue();
    protected long m_refCount = 0L;

    public Context() throws Z3Exception {
        this.m_ctx = Native.mkContextRc(0L);
        this.InitContext();
    }

    public Context(Map<String, String> map) throws Z3Exception {
        long l = Native.mkConfig();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Native.setParamValue(l, entry.getKey(), entry.getValue());
        }
        this.m_ctx = Native.mkContextRc(l);
        Native.delConfig(l);
        this.InitContext();
    }

    private Context(long l, long l2) {
        this.m_ctx = l;
        this.m_refCount = l2;
    }

    public IntSymbol MkSymbol(int n) throws Z3Exception {
        return new IntSymbol(this, n);
    }

    public StringSymbol MkSymbol(String string) throws Z3Exception {
        return new StringSymbol(this, string);
    }

    Symbol[] MkSymbols(String[] stringArray) throws Z3Exception {
        if (stringArray == null) {
            return null;
        }
        Symbol[] symbolArray = new Symbol[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            symbolArray[i] = this.MkSymbol(stringArray[i]);
        }
        return symbolArray;
    }

    public BoolSort BoolSort() throws Z3Exception {
        if (this.m_boolSort == null) {
            this.m_boolSort = new BoolSort(this);
        }
        return this.m_boolSort;
    }

    public IntSort IntSort() throws Z3Exception {
        if (this.m_intSort == null) {
            this.m_intSort = new IntSort(this);
        }
        return this.m_intSort;
    }

    public RealSort RealSort() throws Z3Exception {
        if (this.m_realSort == null) {
            this.m_realSort = new RealSort(this);
        }
        return this.m_realSort;
    }

    public BoolSort MkBoolSort() throws Z3Exception {
        return new BoolSort(this);
    }

    public UninterpretedSort MkUninterpretedSort(Symbol symbol) throws Z3Exception {
        this.CheckContextMatch(symbol);
        return new UninterpretedSort(this, symbol);
    }

    public UninterpretedSort MkUninterpretedSort(String string) throws Z3Exception {
        return this.MkUninterpretedSort(this.MkSymbol(string));
    }

    public IntSort MkIntSort() throws Z3Exception {
        return new IntSort(this);
    }

    public RealSort MkRealSort() throws Z3Exception {
        return new RealSort(this);
    }

    public BitVecSort MkBitVecSort(int n) throws Z3Exception {
        return new BitVecSort(this, Native.mkBvSort(this.nCtx(), n));
    }

    public ArraySort MkArraySort(Sort sort, Sort sort2) throws Z3Exception {
        this.CheckContextMatch(sort);
        this.CheckContextMatch(sort2);
        return new ArraySort(this, sort, sort2);
    }

    public TupleSort MkTupleSort(Symbol symbol, Symbol[] symbolArray, Sort[] sortArray) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(symbolArray);
        this.CheckContextMatch(sortArray);
        return new TupleSort(this, symbol, symbolArray.length, symbolArray, sortArray);
    }

    public EnumSort MkEnumSort(Symbol symbol, Symbol[] symbolArray) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(symbolArray);
        return new EnumSort(this, symbol, symbolArray);
    }

    public EnumSort MkEnumSort(String string, String[] stringArray) throws Z3Exception {
        return new EnumSort(this, this.MkSymbol(string), this.MkSymbols(stringArray));
    }

    public ListSort MkListSort(Symbol symbol, Sort sort) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(sort);
        return new ListSort(this, symbol, sort);
    }

    public ListSort MkListSort(String string, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return new ListSort(this, this.MkSymbol(string), sort);
    }

    public FiniteDomainSort MkFiniteDomainSort(Symbol symbol, long l) throws Z3Exception {
        this.CheckContextMatch(symbol);
        return new FiniteDomainSort(this, symbol, l);
    }

    public FiniteDomainSort MkFiniteDomainSort(String string, long l) throws Z3Exception {
        return new FiniteDomainSort(this, this.MkSymbol(string), l);
    }

    public Constructor MkConstructor(Symbol symbol, Symbol symbol2, Symbol[] symbolArray, Sort[] sortArray, int[] nArray) throws Z3Exception {
        return new Constructor(this, symbol, symbol2, symbolArray, sortArray, nArray);
    }

    public Constructor MkConstructor(String string, String string2, String[] stringArray, Sort[] sortArray, int[] nArray) throws Z3Exception {
        return new Constructor(this, this.MkSymbol(string), this.MkSymbol(string2), this.MkSymbols(stringArray), sortArray, nArray);
    }

    public DatatypeSort MkDatatypeSort(Symbol symbol, Constructor[] constructorArray) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(constructorArray);
        return new DatatypeSort(this, symbol, constructorArray);
    }

    public DatatypeSort MkDatatypeSort(String string, Constructor[] constructorArray) throws Z3Exception {
        this.CheckContextMatch(constructorArray);
        return new DatatypeSort(this, this.MkSymbol(string), constructorArray);
    }

    public DatatypeSort[] MkDatatypeSorts(Symbol[] symbolArray, Constructor[][] constructorArray) throws Z3Exception {
        Z3Object[] z3ObjectArray;
        this.CheckContextMatch(symbolArray);
        int n = symbolArray.length;
        ConstructorList[] constructorListArray = new ConstructorList[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            z3ObjectArray = constructorArray[i];
            this.CheckContextMatch(z3ObjectArray);
            constructorListArray[i] = new ConstructorList(this, (Constructor[])z3ObjectArray);
            lArray[i] = constructorListArray[i].NativeObject();
        }
        long[] lArray2 = new long[n];
        Native.mkDatatypes(this.nCtx(), n, Symbol.ArrayToNative(symbolArray), lArray2, lArray);
        z3ObjectArray = new DatatypeSort[n];
        for (int i = 0; i < n; ++i) {
            z3ObjectArray[i] = new DatatypeSort(this, lArray2[i]);
        }
        return z3ObjectArray;
    }

    public DatatypeSort[] MkDatatypeSorts(String[] stringArray, Constructor[][] constructorArray) throws Z3Exception {
        return this.MkDatatypeSorts(this.MkSymbols(stringArray), constructorArray);
    }

    public FuncDecl MkFuncDecl(Symbol symbol, Sort[] sortArray, Sort sort) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(sortArray);
        this.CheckContextMatch(sort);
        return new FuncDecl(this, symbol, sortArray, sort);
    }

    public FuncDecl MkFuncDecl(Symbol symbol, Sort sort, Sort sort2) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(sort);
        this.CheckContextMatch(sort2);
        Sort[] sortArray = new Sort[]{sort};
        return new FuncDecl(this, symbol, sortArray, sort2);
    }

    public FuncDecl MkFuncDecl(String string, Sort[] sortArray, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sortArray);
        this.CheckContextMatch(sort);
        return new FuncDecl(this, this.MkSymbol(string), sortArray, sort);
    }

    public FuncDecl MkFuncDecl(String string, Sort sort, Sort sort2) throws Z3Exception {
        this.CheckContextMatch(sort);
        this.CheckContextMatch(sort2);
        Sort[] sortArray = new Sort[]{sort};
        return new FuncDecl(this, this.MkSymbol(string), sortArray, sort2);
    }

    public FuncDecl MkFreshFuncDecl(String string, Sort[] sortArray, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sortArray);
        this.CheckContextMatch(sort);
        return new FuncDecl(this, string, sortArray, sort);
    }

    public FuncDecl MkConstDecl(Symbol symbol, Sort sort) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(sort);
        return new FuncDecl(this, symbol, null, sort);
    }

    public FuncDecl MkConstDecl(String string, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return new FuncDecl(this, this.MkSymbol(string), null, sort);
    }

    public FuncDecl MkFreshConstDecl(String string, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return new FuncDecl(this, string, null, sort);
    }

    public Expr MkBound(int n, Sort sort) throws Z3Exception {
        return Expr.Create(this, Native.mkBound(this.nCtx(), n, sort.NativeObject()));
    }

    public Pattern MkPattern(Expr[] exprArray) throws Z3Exception {
        if (exprArray.length == 0) {
            throw new Z3Exception("Cannot create a pattern from zero terms");
        }
        long[] lArray = AST.ArrayToNative(exprArray);
        return new Pattern(this, Native.mkPattern(this.nCtx(), exprArray.length, lArray));
    }

    public Expr MkConst(Symbol symbol, Sort sort) throws Z3Exception {
        this.CheckContextMatch(symbol);
        this.CheckContextMatch(sort);
        return Expr.Create(this, Native.mkConst(this.nCtx(), symbol.NativeObject(), sort.NativeObject()));
    }

    public Expr MkConst(String string, Sort sort) throws Z3Exception {
        return this.MkConst(this.MkSymbol(string), sort);
    }

    public Expr MkFreshConst(String string, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return Expr.Create(this, Native.mkFreshConst(this.nCtx(), string, sort.NativeObject()));
    }

    public Expr MkConst(FuncDecl funcDecl) throws Z3Exception {
        return this.MkApp(funcDecl, (Expr[])null);
    }

    public BoolExpr MkBoolConst(Symbol symbol) throws Z3Exception {
        return (BoolExpr)this.MkConst(symbol, (Sort)this.BoolSort());
    }

    public BoolExpr MkBoolConst(String string) throws Z3Exception {
        return (BoolExpr)this.MkConst(this.MkSymbol(string), (Sort)this.BoolSort());
    }

    public IntExpr MkIntConst(Symbol symbol) throws Z3Exception {
        return (IntExpr)this.MkConst(symbol, (Sort)this.IntSort());
    }

    public IntExpr MkIntConst(String string) throws Z3Exception {
        return (IntExpr)this.MkConst(string, (Sort)this.IntSort());
    }

    public RealExpr MkRealConst(Symbol symbol) throws Z3Exception {
        return (RealExpr)this.MkConst(symbol, (Sort)this.RealSort());
    }

    public RealExpr MkRealConst(String string) throws Z3Exception {
        return (RealExpr)this.MkConst(string, (Sort)this.RealSort());
    }

    public BitVecExpr MkBVConst(Symbol symbol, int n) throws Z3Exception {
        return (BitVecExpr)this.MkConst(symbol, (Sort)this.MkBitVecSort(n));
    }

    public BitVecExpr MkBVConst(String string, int n) throws Z3Exception {
        return (BitVecExpr)this.MkConst(string, (Sort)this.MkBitVecSort(n));
    }

    public Expr MkApp(FuncDecl funcDecl, Expr expr) throws Z3Exception {
        this.CheckContextMatch(funcDecl);
        this.CheckContextMatch(expr);
        Expr[] exprArray = new Expr[]{expr};
        return Expr.Create(this, funcDecl, exprArray);
    }

    public Expr MkApp(FuncDecl funcDecl, Expr[] exprArray) throws Z3Exception {
        this.CheckContextMatch(funcDecl);
        this.CheckContextMatch(exprArray);
        return Expr.Create(this, funcDecl, exprArray);
    }

    public BoolExpr MkTrue() throws Z3Exception {
        return new BoolExpr(this, Native.mkTrue(this.nCtx()));
    }

    public BoolExpr MkFalse() throws Z3Exception {
        return new BoolExpr(this, Native.mkFalse(this.nCtx()));
    }

    public BoolExpr MkBool(boolean bl) throws Z3Exception {
        return bl ? this.MkTrue() : this.MkFalse();
    }

    public BoolExpr MkEq(Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return new BoolExpr(this, Native.mkEq(this.nCtx(), expr.NativeObject(), expr2.NativeObject()));
    }

    public BoolExpr MkDistinct(Expr[] exprArray) throws Z3Exception {
        this.CheckContextMatch(exprArray);
        return new BoolExpr(this, Native.mkDistinct(this.nCtx(), exprArray.length, AST.ArrayToNative(exprArray)));
    }

    public BoolExpr MkNot(BoolExpr boolExpr) throws Z3Exception {
        this.CheckContextMatch(boolExpr);
        return new BoolExpr(this, Native.mkNot(this.nCtx(), boolExpr.NativeObject()));
    }

    public Expr MkITE(BoolExpr boolExpr, Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(boolExpr);
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return Expr.Create(this, Native.mkIte(this.nCtx(), boolExpr.NativeObject(), expr.NativeObject(), expr2.NativeObject()));
    }

    public BoolExpr MkIff(BoolExpr boolExpr, BoolExpr boolExpr2) throws Z3Exception {
        this.CheckContextMatch(boolExpr);
        this.CheckContextMatch(boolExpr2);
        return new BoolExpr(this, Native.mkIff(this.nCtx(), boolExpr.NativeObject(), boolExpr2.NativeObject()));
    }

    public BoolExpr MkImplies(BoolExpr boolExpr, BoolExpr boolExpr2) throws Z3Exception {
        this.CheckContextMatch(boolExpr);
        this.CheckContextMatch(boolExpr2);
        return new BoolExpr(this, Native.mkImplies(this.nCtx(), boolExpr.NativeObject(), boolExpr2.NativeObject()));
    }

    public BoolExpr MkXor(BoolExpr boolExpr, BoolExpr boolExpr2) throws Z3Exception {
        this.CheckContextMatch(boolExpr);
        this.CheckContextMatch(boolExpr2);
        return new BoolExpr(this, Native.mkXor(this.nCtx(), boolExpr.NativeObject(), boolExpr2.NativeObject()));
    }

    public BoolExpr MkAnd(BoolExpr[] boolExprArray) throws Z3Exception {
        this.CheckContextMatch(boolExprArray);
        return new BoolExpr(this, Native.mkAnd(this.nCtx(), boolExprArray.length, AST.ArrayToNative(boolExprArray)));
    }

    public BoolExpr MkOr(BoolExpr[] boolExprArray) throws Z3Exception {
        this.CheckContextMatch(boolExprArray);
        return new BoolExpr(this, Native.mkOr(this.nCtx(), boolExprArray.length, AST.ArrayToNative(boolExprArray)));
    }

    public ArithExpr MkAdd(ArithExpr[] arithExprArray) throws Z3Exception {
        this.CheckContextMatch(arithExprArray);
        return (ArithExpr)Expr.Create(this, Native.mkAdd(this.nCtx(), arithExprArray.length, AST.ArrayToNative(arithExprArray)));
    }

    public ArithExpr MkMul(ArithExpr[] arithExprArray) throws Z3Exception {
        this.CheckContextMatch(arithExprArray);
        return (ArithExpr)Expr.Create(this, Native.mkMul(this.nCtx(), arithExprArray.length, AST.ArrayToNative(arithExprArray)));
    }

    public ArithExpr MkSub(ArithExpr[] arithExprArray) throws Z3Exception {
        this.CheckContextMatch(arithExprArray);
        return (ArithExpr)Expr.Create(this, Native.mkSub(this.nCtx(), arithExprArray.length, AST.ArrayToNative(arithExprArray)));
    }

    public ArithExpr MkUnaryMinus(ArithExpr arithExpr) throws Z3Exception {
        this.CheckContextMatch(arithExpr);
        return (ArithExpr)Expr.Create(this, Native.mkUnaryMinus(this.nCtx(), arithExpr.NativeObject()));
    }

    public ArithExpr MkDiv(ArithExpr arithExpr, ArithExpr arithExpr2) throws Z3Exception {
        this.CheckContextMatch(arithExpr);
        this.CheckContextMatch(arithExpr2);
        return (ArithExpr)Expr.Create(this, Native.mkDiv(this.nCtx(), arithExpr.NativeObject(), arithExpr2.NativeObject()));
    }

    public IntExpr MkMod(IntExpr intExpr, IntExpr intExpr2) throws Z3Exception {
        this.CheckContextMatch(intExpr);
        this.CheckContextMatch(intExpr2);
        return new IntExpr(this, Native.mkMod(this.nCtx(), intExpr.NativeObject(), intExpr2.NativeObject()));
    }

    public IntExpr MkRem(IntExpr intExpr, IntExpr intExpr2) throws Z3Exception {
        this.CheckContextMatch(intExpr);
        this.CheckContextMatch(intExpr2);
        return new IntExpr(this, Native.mkRem(this.nCtx(), intExpr.NativeObject(), intExpr2.NativeObject()));
    }

    public ArithExpr MkPower(ArithExpr arithExpr, ArithExpr arithExpr2) throws Z3Exception {
        this.CheckContextMatch(arithExpr);
        this.CheckContextMatch(arithExpr2);
        return (ArithExpr)Expr.Create(this, Native.mkPower(this.nCtx(), arithExpr.NativeObject(), arithExpr2.NativeObject()));
    }

    public BoolExpr MkLt(ArithExpr arithExpr, ArithExpr arithExpr2) throws Z3Exception {
        this.CheckContextMatch(arithExpr);
        this.CheckContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkLt(this.nCtx(), arithExpr.NativeObject(), arithExpr2.NativeObject()));
    }

    public BoolExpr MkLe(ArithExpr arithExpr, ArithExpr arithExpr2) throws Z3Exception {
        this.CheckContextMatch(arithExpr);
        this.CheckContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkLe(this.nCtx(), arithExpr.NativeObject(), arithExpr2.NativeObject()));
    }

    public BoolExpr MkGt(ArithExpr arithExpr, ArithExpr arithExpr2) throws Z3Exception {
        this.CheckContextMatch(arithExpr);
        this.CheckContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkGt(this.nCtx(), arithExpr.NativeObject(), arithExpr2.NativeObject()));
    }

    public BoolExpr MkGe(ArithExpr arithExpr, ArithExpr arithExpr2) throws Z3Exception {
        this.CheckContextMatch(arithExpr);
        this.CheckContextMatch(arithExpr2);
        return new BoolExpr(this, Native.mkGe(this.nCtx(), arithExpr.NativeObject(), arithExpr2.NativeObject()));
    }

    public RealExpr MkInt2Real(IntExpr intExpr) throws Z3Exception {
        this.CheckContextMatch(intExpr);
        return new RealExpr(this, Native.mkInt2real(this.nCtx(), intExpr.NativeObject()));
    }

    public IntExpr MkReal2Int(RealExpr realExpr) throws Z3Exception {
        this.CheckContextMatch(realExpr);
        return new IntExpr(this, Native.mkReal2int(this.nCtx(), realExpr.NativeObject()));
    }

    public BoolExpr MkIsInteger(RealExpr realExpr) throws Z3Exception {
        this.CheckContextMatch(realExpr);
        return new BoolExpr(this, Native.mkIsInt(this.nCtx(), realExpr.NativeObject()));
    }

    public BitVecExpr MkBVNot(BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvnot(this.nCtx(), bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkBVRedAND(BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvredand(this.nCtx(), bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkBVRedOR(BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvredor(this.nCtx(), bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkBVAND(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvand(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvor(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVXOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvxor(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVNAND(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvnand(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVNOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvnor(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVXNOR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvxnor(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVNeg(BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkBvneg(this.nCtx(), bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkBVAdd(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvadd(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVSub(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsub(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVMul(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvmul(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVUDiv(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvudiv(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVSDiv(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsdiv(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVURem(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvurem(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVSRem(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsrem(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVSMod(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvsmod(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVULT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvult(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVSLT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvslt(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVULE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvule(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVSLE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsle(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVUGE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvuge(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVSGE(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsge(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVUGT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvugt(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVSGT(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsgt(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkConcat(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkConcat(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkExtract(int n, int n2, BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkExtract(this.nCtx(), n, n2, bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkSignExt(int n, BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkSignExt(this.nCtx(), n, bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkZeroExt(int n, BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkZeroExt(this.nCtx(), n, bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkRepeat(int n, BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkRepeat(this.nCtx(), n, bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkBVSHL(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvshl(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVLSHR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvlshr(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVASHR(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkBvashr(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVRotateLeft(int n, BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkRotateLeft(this.nCtx(), n, bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkBVRotateRight(int n, BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BitVecExpr(this, Native.mkRotateRight(this.nCtx(), n, bitVecExpr.NativeObject()));
    }

    public BitVecExpr MkBVRotateLeft(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkExtRotateLeft(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkBVRotateRight(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BitVecExpr(this, Native.mkExtRotateRight(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BitVecExpr MkInt2BV(int n, IntExpr intExpr) throws Z3Exception {
        this.CheckContextMatch(intExpr);
        return new BitVecExpr(this, Native.mkInt2bv(this.nCtx(), n, intExpr.NativeObject()));
    }

    public IntExpr MkBV2Int(BitVecExpr bitVecExpr, boolean bl) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new IntExpr(this, Native.mkBv2int(this.nCtx(), bitVecExpr.NativeObject(), bl));
    }

    public BoolExpr MkBVAddNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2, boolean bl) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvaddNoOverflow(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject(), bl));
    }

    public BoolExpr MkBVAddNoUnderflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvaddNoUnderflow(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVSubNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsubNoOverflow(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVSubNoUnderflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2, boolean bl) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsubNoUnderflow(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject(), bl));
    }

    public BoolExpr MkBVSDivNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvsdivNoOverflow(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public BoolExpr MkBVNegNoOverflow(BitVecExpr bitVecExpr) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        return new BoolExpr(this, Native.mkBvnegNoOverflow(this.nCtx(), bitVecExpr.NativeObject()));
    }

    public BoolExpr MkBVMulNoOverflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2, boolean bl) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvmulNoOverflow(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject(), bl));
    }

    public BoolExpr MkBVMulNoUnderflow(BitVecExpr bitVecExpr, BitVecExpr bitVecExpr2) throws Z3Exception {
        this.CheckContextMatch(bitVecExpr);
        this.CheckContextMatch(bitVecExpr2);
        return new BoolExpr(this, Native.mkBvmulNoUnderflow(this.nCtx(), bitVecExpr.NativeObject(), bitVecExpr2.NativeObject()));
    }

    public ArrayExpr MkArrayConst(Symbol symbol, Sort sort, Sort sort2) throws Z3Exception {
        return (ArrayExpr)this.MkConst(symbol, (Sort)this.MkArraySort(sort, sort2));
    }

    public ArrayExpr MkArrayConst(String string, Sort sort, Sort sort2) throws Z3Exception {
        return (ArrayExpr)this.MkConst(this.MkSymbol(string), (Sort)this.MkArraySort(sort, sort2));
    }

    public Expr MkSelect(ArrayExpr arrayExpr, Expr expr) throws Z3Exception {
        this.CheckContextMatch(arrayExpr);
        this.CheckContextMatch(expr);
        return Expr.Create(this, Native.mkSelect(this.nCtx(), arrayExpr.NativeObject(), expr.NativeObject()));
    }

    public ArrayExpr MkStore(ArrayExpr arrayExpr, Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(arrayExpr);
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return new ArrayExpr(this, Native.mkStore(this.nCtx(), arrayExpr.NativeObject(), expr.NativeObject(), expr2.NativeObject()));
    }

    public ArrayExpr MkConstArray(Sort sort, Expr expr) throws Z3Exception {
        this.CheckContextMatch(sort);
        this.CheckContextMatch(expr);
        return new ArrayExpr(this, Native.mkConstArray(this.nCtx(), sort.NativeObject(), expr.NativeObject()));
    }

    public ArrayExpr MkMap(FuncDecl funcDecl, ArrayExpr[] arrayExprArray) throws Z3Exception {
        this.CheckContextMatch(funcDecl);
        this.CheckContextMatch(arrayExprArray);
        return (ArrayExpr)Expr.Create(this, Native.mkMap(this.nCtx(), funcDecl.NativeObject(), AST.ArrayLength(arrayExprArray), AST.ArrayToNative(arrayExprArray)));
    }

    public Expr MkTermArray(ArrayExpr arrayExpr) throws Z3Exception {
        this.CheckContextMatch(arrayExpr);
        return Expr.Create(this, Native.mkArrayDefault(this.nCtx(), arrayExpr.NativeObject()));
    }

    public SetSort MkSetSort(Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return new SetSort(this, sort);
    }

    public Expr MkEmptySet(Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return Expr.Create(this, Native.mkEmptySet(this.nCtx(), sort.NativeObject()));
    }

    public Expr MkFullSet(Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return Expr.Create(this, Native.mkFullSet(this.nCtx(), sort.NativeObject()));
    }

    public Expr MkSetAdd(Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return Expr.Create(this, Native.mkSetAdd(this.nCtx(), expr.NativeObject(), expr2.NativeObject()));
    }

    public Expr MkSetDel(Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return Expr.Create(this, Native.mkSetDel(this.nCtx(), expr.NativeObject(), expr2.NativeObject()));
    }

    public Expr MkSetUnion(Expr[] exprArray) throws Z3Exception {
        this.CheckContextMatch(exprArray);
        return Expr.Create(this, Native.mkSetUnion(this.nCtx(), exprArray.length, AST.ArrayToNative(exprArray)));
    }

    public Expr MkSetIntersection(Expr[] exprArray) throws Z3Exception {
        this.CheckContextMatch(exprArray);
        return Expr.Create(this, Native.mkSetIntersect(this.nCtx(), exprArray.length, AST.ArrayToNative(exprArray)));
    }

    public Expr MkSetDifference(Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return Expr.Create(this, Native.mkSetDifference(this.nCtx(), expr.NativeObject(), expr2.NativeObject()));
    }

    public Expr MkSetComplement(Expr expr) throws Z3Exception {
        this.CheckContextMatch(expr);
        return Expr.Create(this, Native.mkSetComplement(this.nCtx(), expr.NativeObject()));
    }

    public Expr MkSetMembership(Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return Expr.Create(this, Native.mkSetMember(this.nCtx(), expr.NativeObject(), expr2.NativeObject()));
    }

    public Expr MkSetSubset(Expr expr, Expr expr2) throws Z3Exception {
        this.CheckContextMatch(expr);
        this.CheckContextMatch(expr2);
        return Expr.Create(this, Native.mkSetSubset(this.nCtx(), expr.NativeObject(), expr2.NativeObject()));
    }

    public Expr MkNumeral(String string, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return Expr.Create(this, Native.mkNumeral(this.nCtx(), string, sort.NativeObject()));
    }

    public Expr MkNumeral(int n, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return Expr.Create(this, Native.mkInt(this.nCtx(), n, sort.NativeObject()));
    }

    public Expr MkNumeral(long l, Sort sort) throws Z3Exception {
        this.CheckContextMatch(sort);
        return Expr.Create(this, Native.mkInt64(this.nCtx(), l, sort.NativeObject()));
    }

    public RatNum MkReal(int n, int n2) throws Z3Exception {
        if (n2 == 0) {
            throw new Z3Exception("Denominator is zero");
        }
        return new RatNum(this, Native.mkReal(this.nCtx(), n, n2));
    }

    public RatNum MkReal(String string) throws Z3Exception {
        return new RatNum(this, Native.mkNumeral(this.nCtx(), string, this.RealSort().NativeObject()));
    }

    public RatNum MkReal(int n) throws Z3Exception {
        return new RatNum(this, Native.mkInt(this.nCtx(), n, this.RealSort().NativeObject()));
    }

    public RatNum MkReal(long l) throws Z3Exception {
        return new RatNum(this, Native.mkInt64(this.nCtx(), l, this.RealSort().NativeObject()));
    }

    public IntNum MkInt(String string) throws Z3Exception {
        return new IntNum(this, Native.mkNumeral(this.nCtx(), string, this.IntSort().NativeObject()));
    }

    public IntNum MkInt(int n) throws Z3Exception {
        return new IntNum(this, Native.mkInt(this.nCtx(), n, this.IntSort().NativeObject()));
    }

    public IntNum MkInt(long l) throws Z3Exception {
        return new IntNum(this, Native.mkInt64(this.nCtx(), l, this.IntSort().NativeObject()));
    }

    public BitVecNum MkBV(String string, int n) throws Z3Exception {
        return (BitVecNum)this.MkNumeral(string, (Sort)this.MkBitVecSort(n));
    }

    public BitVecNum MkBV(int n, int n2) throws Z3Exception {
        return (BitVecNum)this.MkNumeral(n, (Sort)this.MkBitVecSort(n2));
    }

    public BitVecNum MkBV(long l, int n) throws Z3Exception {
        return (BitVecNum)this.MkNumeral(l, (Sort)this.MkBitVecSort(n));
    }

    public Quantifier MkForall(Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) throws Z3Exception {
        return new Quantifier(this, true, sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier MkForall(Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) throws Z3Exception {
        return new Quantifier(this, true, exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public Quantifier MkExists(Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) throws Z3Exception {
        return new Quantifier(this, false, sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier MkExists(Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) throws Z3Exception {
        return new Quantifier(this, false, exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public Quantifier MkQuantifier(boolean bl, Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) throws Z3Exception {
        if (bl) {
            return this.MkForall(sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
        }
        return this.MkExists(sortArray, symbolArray, expr, n, patternArray, exprArray, symbol, symbol2);
    }

    public Quantifier MkQuantifier(boolean bl, Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) throws Z3Exception {
        if (bl) {
            return this.MkForall(exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
        }
        return this.MkExists(exprArray, expr, n, patternArray, exprArray2, symbol, symbol2);
    }

    public void setPrintMode(Z3_ast_print_mode z3_ast_print_mode) throws Z3Exception {
        Native.setAstPrintMode(this.nCtx(), z3_ast_print_mode.toInt());
    }

    public String BenchmarkToSMTString(String string, String string2, String string3, String string4, BoolExpr[] boolExprArray, BoolExpr boolExpr) throws Z3Exception {
        return Native.benchmarkToSmtlibString(this.nCtx(), string, string2, string3, string4, boolExprArray.length, AST.ArrayToNative(boolExprArray), boolExpr.NativeObject());
    }

    public void ParseSMTLIBString(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) throws Z3Exception {
        int n = Symbol.ArrayLength(symbolArray);
        int n2 = Sort.ArrayLength(sortArray);
        int n3 = Symbol.ArrayLength(symbolArray2);
        int n4 = AST.ArrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        Native.parseSmtlibString(this.nCtx(), string, AST.ArrayLength(sortArray), Symbol.ArrayToNative(symbolArray), AST.ArrayToNative(sortArray), AST.ArrayLength(funcDeclArray), Symbol.ArrayToNative(symbolArray2), AST.ArrayToNative(funcDeclArray));
    }

    public void ParseSMTLIBFile(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) throws Z3Exception {
        int n = Symbol.ArrayLength(symbolArray);
        int n2 = Sort.ArrayLength(sortArray);
        int n3 = Symbol.ArrayLength(symbolArray2);
        int n4 = AST.ArrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        Native.parseSmtlibFile(this.nCtx(), string, AST.ArrayLength(sortArray), Symbol.ArrayToNative(symbolArray), AST.ArrayToNative(sortArray), AST.ArrayLength(funcDeclArray), Symbol.ArrayToNative(symbolArray2), AST.ArrayToNative(funcDeclArray));
    }

    public int NumSMTLIBFormulas() throws Z3Exception {
        return Native.getSmtlibNumFormulas(this.nCtx());
    }

    public BoolExpr[] SMTLIBFormulas() throws Z3Exception {
        int n = this.NumSMTLIBFormulas();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = (BoolExpr)Expr.Create(this, Native.getSmtlibFormula(this.nCtx(), i));
        }
        return boolExprArray;
    }

    public int NumSMTLIBAssumptions() throws Z3Exception {
        return Native.getSmtlibNumAssumptions(this.nCtx());
    }

    public BoolExpr[] SMTLIBAssumptions() throws Z3Exception {
        int n = this.NumSMTLIBAssumptions();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = (BoolExpr)Expr.Create(this, Native.getSmtlibAssumption(this.nCtx(), i));
        }
        return boolExprArray;
    }

    public int NumSMTLIBDecls() throws Z3Exception {
        return Native.getSmtlibNumDecls(this.nCtx());
    }

    public FuncDecl[] SMTLIBDecls() throws Z3Exception {
        int n = this.NumSMTLIBDecls();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this, Native.getSmtlibDecl(this.nCtx(), i));
        }
        return funcDeclArray;
    }

    public int NumSMTLIBSorts() throws Z3Exception {
        return Native.getSmtlibNumSorts(this.nCtx());
    }

    public Sort[] SMTLIBSorts() throws Z3Exception {
        int n = this.NumSMTLIBSorts();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.Create(this, Native.getSmtlibSort(this.nCtx(), i));
        }
        return sortArray;
    }

    public BoolExpr ParseSMTLIB2String(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) throws Z3Exception {
        int n = Symbol.ArrayLength(symbolArray);
        int n2 = Sort.ArrayLength(sortArray);
        int n3 = Symbol.ArrayLength(symbolArray2);
        int n4 = AST.ArrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        return (BoolExpr)Expr.Create(this, Native.parseSmtlib2String(this.nCtx(), string, AST.ArrayLength(sortArray), Symbol.ArrayToNative(symbolArray), AST.ArrayToNative(sortArray), AST.ArrayLength(funcDeclArray), Symbol.ArrayToNative(symbolArray2), AST.ArrayToNative(funcDeclArray)));
    }

    public BoolExpr ParseSMTLIB2File(String string, Symbol[] symbolArray, Sort[] sortArray, Symbol[] symbolArray2, FuncDecl[] funcDeclArray) throws Z3Exception {
        int n = Symbol.ArrayLength(symbolArray);
        int n2 = Sort.ArrayLength(sortArray);
        int n3 = Symbol.ArrayLength(symbolArray2);
        int n4 = AST.ArrayLength(funcDeclArray);
        if (n != n2 || n3 != n4) {
            throw new Z3Exception("Argument size mismatch");
        }
        return (BoolExpr)Expr.Create(this, Native.parseSmtlib2File(this.nCtx(), string, AST.ArrayLength(sortArray), Symbol.ArrayToNative(symbolArray), AST.ArrayToNative(sortArray), AST.ArrayLength(funcDeclArray), Symbol.ArrayToNative(symbolArray2), AST.ArrayToNative(funcDeclArray)));
    }

    public Goal MkGoal(boolean bl, boolean bl2, boolean bl3) throws Z3Exception {
        return new Goal(this, bl, bl2, bl3);
    }

    public Params MkParams() throws Z3Exception {
        return new Params(this);
    }

    public int NumTactics() throws Z3Exception {
        return Native.getNumTactics(this.nCtx());
    }

    public String[] TacticNames() throws Z3Exception {
        int n = this.NumTactics();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.getTacticName(this.nCtx(), i);
        }
        return stringArray;
    }

    public String TacticDescription(String string) throws Z3Exception {
        return Native.tacticGetDescr(this.nCtx(), string);
    }

    public Tactic MkTactic(String string) throws Z3Exception {
        return new Tactic(this, string);
    }

    public Tactic AndThen(Tactic tactic, Tactic tactic2, Tactic[] tacticArray) throws Z3Exception {
        this.CheckContextMatch(tactic);
        this.CheckContextMatch(tactic2);
        this.CheckContextMatch(tacticArray);
        long l = 0L;
        if (tacticArray != null && tacticArray.length > 0) {
            l = tacticArray[tacticArray.length - 1].NativeObject();
            for (int i = tacticArray.length - 2; i >= 0; --i) {
                l = Native.tacticAndThen(this.nCtx(), tacticArray[i].NativeObject(), l);
            }
        }
        if (l != 0L) {
            l = Native.tacticAndThen(this.nCtx(), tactic2.NativeObject(), l);
            return new Tactic(this, Native.tacticAndThen(this.nCtx(), tactic.NativeObject(), l));
        }
        return new Tactic(this, Native.tacticAndThen(this.nCtx(), tactic.NativeObject(), tactic2.NativeObject()));
    }

    public Tactic Then(Tactic tactic, Tactic tactic2, Tactic[] tacticArray) throws Z3Exception {
        return this.AndThen(tactic, tactic2, tacticArray);
    }

    public Tactic OrElse(Tactic tactic, Tactic tactic2) throws Z3Exception {
        this.CheckContextMatch(tactic);
        this.CheckContextMatch(tactic2);
        return new Tactic(this, Native.tacticOrElse(this.nCtx(), tactic.NativeObject(), tactic2.NativeObject()));
    }

    public Tactic TryFor(Tactic tactic, int n) throws Z3Exception {
        this.CheckContextMatch(tactic);
        return new Tactic(this, Native.tacticTryFor(this.nCtx(), tactic.NativeObject(), n));
    }

    public Tactic When(Probe probe, Tactic tactic) throws Z3Exception {
        this.CheckContextMatch(tactic);
        this.CheckContextMatch(probe);
        return new Tactic(this, Native.tacticWhen(this.nCtx(), probe.NativeObject(), tactic.NativeObject()));
    }

    public Tactic Cond(Probe probe, Tactic tactic, Tactic tactic2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(tactic);
        this.CheckContextMatch(tactic2);
        return new Tactic(this, Native.tacticCond(this.nCtx(), probe.NativeObject(), tactic.NativeObject(), tactic2.NativeObject()));
    }

    public Tactic Repeat(Tactic tactic, int n) throws Z3Exception {
        this.CheckContextMatch(tactic);
        return new Tactic(this, Native.tacticRepeat(this.nCtx(), tactic.NativeObject(), n));
    }

    public Tactic Skip() throws Z3Exception {
        return new Tactic(this, Native.tacticSkip(this.nCtx()));
    }

    public Tactic Fail() throws Z3Exception {
        return new Tactic(this, Native.tacticFail(this.nCtx()));
    }

    public Tactic FailIf(Probe probe) throws Z3Exception {
        this.CheckContextMatch(probe);
        return new Tactic(this, Native.tacticFailIf(this.nCtx(), probe.NativeObject()));
    }

    public Tactic FailIfNotDecided() throws Z3Exception {
        return new Tactic(this, Native.tacticFailIfNotDecided(this.nCtx()));
    }

    public Tactic UsingParams(Tactic tactic, Params params) throws Z3Exception {
        this.CheckContextMatch(tactic);
        this.CheckContextMatch(params);
        return new Tactic(this, Native.tacticUsingParams(this.nCtx(), tactic.NativeObject(), params.NativeObject()));
    }

    public Tactic With(Tactic tactic, Params params) throws Z3Exception {
        return this.UsingParams(tactic, params);
    }

    public Tactic ParOr(Tactic[] tacticArray) throws Z3Exception {
        this.CheckContextMatch(tacticArray);
        return new Tactic(this, Native.tacticParOr(this.nCtx(), Tactic.ArrayLength(tacticArray), Tactic.ArrayToNative(tacticArray)));
    }

    public Tactic ParAndThen(Tactic tactic, Tactic tactic2) throws Z3Exception {
        this.CheckContextMatch(tactic);
        this.CheckContextMatch(tactic2);
        return new Tactic(this, Native.tacticParAndThen(this.nCtx(), tactic.NativeObject(), tactic2.NativeObject()));
    }

    public void Interrupt() throws Z3Exception {
        Native.interrupt(this.nCtx());
    }

    public int NumProbes() throws Z3Exception {
        return Native.getNumProbes(this.nCtx());
    }

    public String[] ProbeNames() throws Z3Exception {
        int n = this.NumProbes();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.getProbeName(this.nCtx(), i);
        }
        return stringArray;
    }

    public String ProbeDescription(String string) throws Z3Exception {
        return Native.probeGetDescr(this.nCtx(), string);
    }

    public Probe MkProbe(String string) throws Z3Exception {
        return new Probe(this, string);
    }

    public Probe Const(double d) throws Z3Exception {
        return new Probe(this, Native.probeConst(this.nCtx(), d));
    }

    public Probe Lt(Probe probe, Probe probe2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(probe2);
        return new Probe(this, Native.probeLt(this.nCtx(), probe.NativeObject(), probe2.NativeObject()));
    }

    public Probe Gt(Probe probe, Probe probe2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(probe2);
        return new Probe(this, Native.probeGt(this.nCtx(), probe.NativeObject(), probe2.NativeObject()));
    }

    public Probe Le(Probe probe, Probe probe2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(probe2);
        return new Probe(this, Native.probeLe(this.nCtx(), probe.NativeObject(), probe2.NativeObject()));
    }

    public Probe Ge(Probe probe, Probe probe2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(probe2);
        return new Probe(this, Native.probeGe(this.nCtx(), probe.NativeObject(), probe2.NativeObject()));
    }

    public Probe Eq(Probe probe, Probe probe2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(probe2);
        return new Probe(this, Native.probeEq(this.nCtx(), probe.NativeObject(), probe2.NativeObject()));
    }

    public Probe And(Probe probe, Probe probe2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(probe2);
        return new Probe(this, Native.probeAnd(this.nCtx(), probe.NativeObject(), probe2.NativeObject()));
    }

    public Probe Or(Probe probe, Probe probe2) throws Z3Exception {
        this.CheckContextMatch(probe);
        this.CheckContextMatch(probe2);
        return new Probe(this, Native.probeOr(this.nCtx(), probe.NativeObject(), probe2.NativeObject()));
    }

    public Probe Not(Probe probe) throws Z3Exception {
        this.CheckContextMatch(probe);
        return new Probe(this, Native.probeNot(this.nCtx(), probe.NativeObject()));
    }

    public Solver MkSolver() throws Z3Exception {
        return this.MkSolver((Symbol)null);
    }

    public Solver MkSolver(Symbol symbol) throws Z3Exception {
        if (symbol == null) {
            return new Solver(this, Native.mkSolver(this.nCtx()));
        }
        return new Solver(this, Native.mkSolverForLogic(this.nCtx(), symbol.NativeObject()));
    }

    public Solver MkSolver(String string) throws Z3Exception {
        return this.MkSolver(this.MkSymbol(string));
    }

    public Solver MkSimpleSolver() throws Z3Exception {
        return new Solver(this, Native.mkSimpleSolver(this.nCtx()));
    }

    public Solver MkSolver(Tactic tactic) throws Z3Exception {
        return new Solver(this, Native.mkSolverFromTactic(this.nCtx(), tactic.NativeObject()));
    }

    public Fixedpoint MkFixedpoint() throws Z3Exception {
        return new Fixedpoint(this);
    }

    public AST WrapAST(long l) throws Z3Exception {
        return AST.Create(this, l);
    }

    public long UnwrapAST(AST aST) {
        return aST.NativeObject();
    }

    public String SimplifyHelp() throws Z3Exception {
        return Native.simplifyGetHelp(this.nCtx());
    }

    public ParamDescrs SimplifyParameterDescriptions() throws Z3Exception {
        return new ParamDescrs(this, Native.simplifyGetParamDescrs(this.nCtx()));
    }

    public static void ToggleWarningMessages(boolean bl) throws Z3Exception {
        Native.toggleWarningMessages(bl);
    }

    public void UpdateParamValue(String string, String string2) throws Z3Exception {
        Native.updateParamValue(this.nCtx(), string, string2);
    }

    public String GetParamValue(String string) throws Z3Exception {
        Native.StringPtr stringPtr = new Native.StringPtr();
        boolean bl = Native.getParamValue(this.nCtx(), string, stringPtr);
        if (!bl) {
            return null;
        }
        return stringPtr.value;
    }

    long nCtx() {
        return this.m_ctx;
    }

    void InitContext() throws Z3Exception {
        this.setPrintMode(Z3_ast_print_mode.Z3_PRINT_SMTLIB2_COMPLIANT);
        Native.setInternalErrorHandler(this.nCtx());
    }

    void CheckContextMatch(Z3Object z3Object) throws Z3Exception {
        if (this != z3Object.Context()) {
            throw new Z3Exception("Context mismatch");
        }
    }

    void CheckContextMatch(Z3Object[] z3ObjectArray) throws Z3Exception {
        if (z3ObjectArray != null) {
            for (Z3Object z3Object : z3ObjectArray) {
                this.CheckContextMatch(z3Object);
            }
        }
    }

    ASTDecRefQueue AST_DRQ() {
        return this.m_AST_DRQ;
    }

    ASTMapDecRefQueue ASTMap_DRQ() {
        return this.m_ASTMap_DRQ;
    }

    ASTVectorDecRefQueue ASTVector_DRQ() {
        return this.m_ASTVector_DRQ;
    }

    ApplyResultDecRefQueue ApplyResult_DRQ() {
        return this.m_ApplyResult_DRQ;
    }

    FuncInterpEntryDecRefQueue FuncEntry_DRQ() {
        return this.m_FuncEntry_DRQ;
    }

    FuncInterpDecRefQueue FuncInterp_DRQ() {
        return this.m_FuncInterp_DRQ;
    }

    GoalDecRefQueue Goal_DRQ() {
        return this.m_Goal_DRQ;
    }

    ModelDecRefQueue Model_DRQ() {
        return this.m_Model_DRQ;
    }

    ParamsDecRefQueue Params_DRQ() {
        return this.m_Params_DRQ;
    }

    ParamDescrsDecRefQueue ParamDescrs_DRQ() {
        return this.m_ParamDescrs_DRQ;
    }

    ProbeDecRefQueue Probe_DRQ() {
        return this.m_Probe_DRQ;
    }

    SolverDecRefQueue Solver_DRQ() {
        return this.m_Solver_DRQ;
    }

    StatisticsDecRefQueue Statistics_DRQ() {
        return this.m_Statistics_DRQ;
    }

    TacticDecRefQueue Tactic_DRQ() {
        return this.m_Tactic_DRQ;
    }

    FixedpointDecRefQueue Fixedpoint_DRQ() {
        return this.m_Fixedpoint_DRQ;
    }

    protected void finalize() {
        this.Dispose();
        if (this.m_refCount == 0L) {
            try {
                Native.delContext(this.m_ctx);
            }
            catch (Z3Exception z3Exception) {
                // empty catch block
            }
            this.m_ctx = 0L;
        } else {
            new Context(this.m_ctx, this.m_refCount);
        }
    }

    @Override
    public void Dispose() {
        this.m_AST_DRQ.Clear(this);
        this.m_ASTMap_DRQ.Clear(this);
        this.m_ASTVector_DRQ.Clear(this);
        this.m_ApplyResult_DRQ.Clear(this);
        this.m_FuncEntry_DRQ.Clear(this);
        this.m_FuncInterp_DRQ.Clear(this);
        this.m_Goal_DRQ.Clear(this);
        this.m_Model_DRQ.Clear(this);
        this.m_Params_DRQ.Clear(this);
        this.m_Probe_DRQ.Clear(this);
        this.m_Solver_DRQ.Clear(this);
        this.m_Statistics_DRQ.Clear(this);
        this.m_Tactic_DRQ.Clear(this);
        this.m_Fixedpoint_DRQ.Clear(this);
        this.m_boolSort = null;
        this.m_intSort = null;
        this.m_realSort = null;
    }
}

