/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.AlgebraicNum;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BitVecNum;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeExpr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Native;
import com.microsoft.z3.Params;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_lbool;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Expr
extends AST {
    public Expr Simplify() throws Z3Exception {
        return this.Simplify(null);
    }

    public Expr Simplify(Params params) throws Z3Exception {
        if (params == null) {
            return Expr.Create(this.Context(), Native.simplify(this.Context().nCtx(), this.NativeObject()));
        }
        return Expr.Create(this.Context(), Native.simplifyEx(this.Context().nCtx(), this.NativeObject(), params.NativeObject()));
    }

    public FuncDecl FuncDecl() throws Z3Exception {
        return new FuncDecl(this.Context(), Native.getAppDecl(this.Context().nCtx(), this.NativeObject()));
    }

    public Z3_lbool BoolValue() throws Z3Exception {
        return Z3_lbool.fromInt(Native.getBoolValue(this.Context().nCtx(), this.NativeObject()));
    }

    public int NumArgs() throws Z3Exception {
        return Native.getAppNumArgs(this.Context().nCtx(), this.NativeObject());
    }

    public Expr[] Args() throws Z3Exception {
        int n = this.NumArgs();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.Create(this.Context(), Native.getAppArg(this.Context().nCtx(), this.NativeObject(), i));
        }
        return exprArray;
    }

    public void Update(Expr[] exprArray) throws Z3Exception {
        this.Context().CheckContextMatch(exprArray);
        if (exprArray.length != this.NumArgs()) {
            throw new Z3Exception("Number of arguments does not match");
        }
        this.setNativeObject(Native.updateTerm(this.Context().nCtx(), this.NativeObject(), exprArray.length, Expr.ArrayToNative(exprArray)));
    }

    public Expr Substitute(Expr[] exprArray, Expr[] exprArray2) throws Z3Exception {
        this.Context().CheckContextMatch(exprArray);
        this.Context().CheckContextMatch(exprArray2);
        if (exprArray.length != exprArray2.length) {
            throw new Z3Exception("Argument sizes do not match");
        }
        return Expr.Create(this.Context(), Native.substitute(this.Context().nCtx(), this.NativeObject(), exprArray.length, Expr.ArrayToNative(exprArray), Expr.ArrayToNative(exprArray2)));
    }

    public Expr Substitute(Expr expr, Expr expr2) throws Z3Exception {
        return this.Substitute(new Expr[]{expr}, new Expr[]{expr2});
    }

    public Expr SubstituteVars(Expr[] exprArray) throws Z3Exception {
        this.Context().CheckContextMatch(exprArray);
        return Expr.Create(this.Context(), Native.substituteVars(this.Context().nCtx(), this.NativeObject(), exprArray.length, Expr.ArrayToNative(exprArray)));
    }

    @Override
    public Expr Translate(Context context) throws Z3Exception {
        if (this.Context() == context) {
            return this;
        }
        return Expr.Create(context, Native.translate(this.Context().nCtx(), this.NativeObject(), context.nCtx()));
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public boolean IsNumeral() throws Z3Exception {
        return Native.isNumeralAst(this.Context().nCtx(), this.NativeObject());
    }

    public boolean IsWellSorted() throws Z3Exception {
        return Native.isWellSorted(this.Context().nCtx(), this.NativeObject());
    }

    public Sort Sort() throws Z3Exception {
        return Sort.Create(this.Context(), Native.getSort(this.Context().nCtx(), this.NativeObject()));
    }

    public boolean IsConst() throws Z3Exception {
        return this.IsExpr() && this.NumArgs() == 0 && this.FuncDecl().DomainSize() == 0;
    }

    public boolean IsIntNum() throws Z3Exception {
        return this.IsNumeral() && this.IsInt();
    }

    public boolean IsRatNum() throws Z3Exception {
        return this.IsNumeral() && this.IsReal();
    }

    public boolean IsAlgebraicNumber() throws Z3Exception {
        return Native.isAlgebraicNumber(this.Context().nCtx(), this.NativeObject());
    }

    public boolean IsBool() throws Z3Exception {
        return this.IsExpr() && Native.isEqSort(this.Context().nCtx(), Native.mkBoolSort(this.Context().nCtx()), Native.getSort(this.Context().nCtx(), this.NativeObject()));
    }

    public boolean IsTrue() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_TRUE;
    }

    public boolean IsFalse() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_FALSE;
    }

    public boolean IsEq() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_EQ;
    }

    public boolean IsDistinct() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_DISTINCT;
    }

    public boolean IsITE() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ITE;
    }

    public boolean IsAnd() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_AND;
    }

    public boolean IsOr() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_OR;
    }

    public boolean IsIff() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_IFF;
    }

    public boolean IsXor() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_XOR;
    }

    public boolean IsNot() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_NOT;
    }

    public boolean IsImplies() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_IMPLIES;
    }

    public boolean IsInt() throws Z3Exception {
        return Native.isNumeralAst(this.Context().nCtx(), this.NativeObject()) && Native.getSortKind(this.Context().nCtx(), Native.getSort(this.Context().nCtx(), this.NativeObject())) == Z3_sort_kind.Z3_INT_SORT.toInt();
    }

    public boolean IsReal() throws Z3Exception {
        return Native.getSortKind(this.Context().nCtx(), Native.getSort(this.Context().nCtx(), this.NativeObject())) == Z3_sort_kind.Z3_REAL_SORT.toInt();
    }

    public boolean IsArithmeticNumeral() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ANUM;
    }

    public boolean IsLE() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_LE;
    }

    public boolean IsGE() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_GE;
    }

    public boolean IsLT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_LT;
    }

    public boolean IsGT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_GT;
    }

    public boolean IsAdd() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ADD;
    }

    public boolean IsSub() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SUB;
    }

    public boolean IsUMinus() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_UMINUS;
    }

    public boolean IsMul() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_MUL;
    }

    public boolean IsDiv() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_DIV;
    }

    public boolean IsIDiv() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_IDIV;
    }

    public boolean IsRemainder() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_REM;
    }

    public boolean IsModulus() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_MOD;
    }

    public boolean IsIntToReal() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_TO_REAL;
    }

    public boolean IsRealToInt() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_TO_INT;
    }

    public boolean IsRealIsInt() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_IS_INT;
    }

    public boolean IsArray() throws Z3Exception {
        return Native.isApp(this.Context().nCtx(), this.NativeObject()) && Z3_sort_kind.fromInt(Native.getSortKind(this.Context().nCtx(), Native.getSort(this.Context().nCtx(), this.NativeObject()))) == Z3_sort_kind.Z3_ARRAY_SORT;
    }

    public boolean IsStore() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_STORE;
    }

    public boolean IsSelect() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SELECT;
    }

    public boolean IsConstantArray() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_CONST_ARRAY;
    }

    public boolean IsDefaultArray() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ARRAY_DEFAULT;
    }

    public boolean IsArrayMap() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ARRAY_MAP;
    }

    public boolean IsAsArray() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_AS_ARRAY;
    }

    public boolean IsSetUnion() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SET_UNION;
    }

    public boolean IsSetIntersect() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SET_INTERSECT;
    }

    public boolean IsSetDifference() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SET_DIFFERENCE;
    }

    public boolean IsSetComplement() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SET_COMPLEMENT;
    }

    public boolean IsSetSubset() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SET_SUBSET;
    }

    public boolean IsBV() throws Z3Exception {
        return Native.getSortKind(this.Context().nCtx(), Native.getSort(this.Context().nCtx(), this.NativeObject())) == Z3_sort_kind.Z3_BV_SORT.toInt();
    }

    public boolean IsBVNumeral() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BNUM;
    }

    public boolean IsBVBitOne() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BIT1;
    }

    public boolean IsBVBitZero() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BIT0;
    }

    public boolean IsBVUMinus() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BNEG;
    }

    public boolean IsBVAdd() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BADD;
    }

    public boolean IsBVSub() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSUB;
    }

    public boolean IsBVMul() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BMUL;
    }

    public boolean IsBVSDiv() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSDIV;
    }

    public boolean IsBVUDiv() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BUDIV;
    }

    public boolean IsBVSRem() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSREM;
    }

    public boolean IsBVURem() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BUREM;
    }

    public boolean IsBVSMod() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSMOD;
    }

    boolean IsBVSDiv0() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSDIV0;
    }

    boolean IsBVUDiv0() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BUDIV0;
    }

    boolean IsBVSRem0() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSREM0;
    }

    boolean IsBVURem0() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BUREM0;
    }

    boolean IsBVSMod0() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSMOD0;
    }

    public boolean IsBVULE() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ULEQ;
    }

    public boolean IsBVSLE() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SLEQ;
    }

    public boolean IsBVUGE() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_UGEQ;
    }

    public boolean IsBVSGE() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SGEQ;
    }

    public boolean IsBVULT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ULT;
    }

    public boolean IsBVSLT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SLT;
    }

    public boolean IsBVUGT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_UGT;
    }

    public boolean IsBVSGT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SGT;
    }

    public boolean IsBVAND() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BAND;
    }

    public boolean IsBVOR() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BOR;
    }

    public boolean IsBVNOT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BNOT;
    }

    public boolean IsBVXOR() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BXOR;
    }

    public boolean IsBVNAND() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BNAND;
    }

    public boolean IsBVNOR() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BNOR;
    }

    public boolean IsBVXNOR() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BXNOR;
    }

    public boolean IsBVConcat() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_CONCAT;
    }

    public boolean IsBVSignExtension() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_SIGN_EXT;
    }

    public boolean IsBVZeroExtension() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ZERO_EXT;
    }

    public boolean IsBVExtract() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_EXTRACT;
    }

    public boolean IsBVRepeat() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_REPEAT;
    }

    public boolean IsBVReduceOR() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BREDOR;
    }

    public boolean IsBVReduceAND() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BREDAND;
    }

    public boolean IsBVComp() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BCOMP;
    }

    public boolean IsBVShiftLeft() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BSHL;
    }

    public boolean IsBVShiftRightLogical() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BLSHR;
    }

    public boolean IsBVShiftRightArithmetic() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BASHR;
    }

    public boolean IsBVRotateLeft() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ROTATE_LEFT;
    }

    public boolean IsBVRotateRight() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_ROTATE_RIGHT;
    }

    public boolean IsBVRotateLeftExtended() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_EXT_ROTATE_LEFT;
    }

    public boolean IsBVRotateRightExtended() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_EXT_ROTATE_RIGHT;
    }

    public boolean IsIntToBV() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_INT2BV;
    }

    public boolean IsBVToInt() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_BV2INT;
    }

    public boolean IsBVCarry() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_CARRY;
    }

    public boolean IsBVXOR3() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_XOR3;
    }

    public boolean IsLabel() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_LABEL;
    }

    public boolean IsLabelLit() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_LABEL_LIT;
    }

    public boolean IsOEQ() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_OEQ;
    }

    public boolean IsProofTrue() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_TRUE;
    }

    public boolean IsProofAsserted() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_ASSERTED;
    }

    public boolean IsProofGoal() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_GOAL;
    }

    public boolean IsProofModusPonens() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_MODUS_PONENS;
    }

    public boolean IsProofReflexivity() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_REFLEXIVITY;
    }

    public boolean IsProofSymmetry() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_SYMMETRY;
    }

    public boolean IsProofTransitivity() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_TRANSITIVITY;
    }

    public boolean IsProofTransitivityStar() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_TRANSITIVITY_STAR;
    }

    public boolean IsProofMonotonicity() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_MONOTONICITY;
    }

    public boolean IsProofQuantIntro() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_QUANT_INTRO;
    }

    public boolean IsProofDistributivity() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_DISTRIBUTIVITY;
    }

    public boolean IsProofAndElimination() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_AND_ELIM;
    }

    public boolean IsProofOrElimination() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_NOT_OR_ELIM;
    }

    public boolean IsProofRewrite() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_REWRITE;
    }

    public boolean IsProofRewriteStar() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_REWRITE_STAR;
    }

    public boolean IsProofPullQuant() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_PULL_QUANT;
    }

    public boolean IsProofPullQuantStar() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_PULL_QUANT_STAR;
    }

    public boolean IsProofPushQuant() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_PUSH_QUANT;
    }

    public boolean IsProofElimUnusedVars() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_ELIM_UNUSED_VARS;
    }

    public boolean IsProofDER() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_DER;
    }

    public boolean IsProofQuantInst() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_QUANT_INST;
    }

    public boolean IsProofHypothesis() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_HYPOTHESIS;
    }

    public boolean IsProofLemma() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_LEMMA;
    }

    public boolean IsProofUnitResolution() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_UNIT_RESOLUTION;
    }

    public boolean IsProofIFFTrue() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_TRUE;
    }

    public boolean IsProofIFFFalse() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_FALSE;
    }

    public boolean IsProofCommutativity() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_COMMUTATIVITY;
    }

    public boolean IsProofDefAxiom() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_DEF_AXIOM;
    }

    public boolean IsProofDefIntro() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_DEF_INTRO;
    }

    public boolean IsProofApplyDef() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_APPLY_DEF;
    }

    public boolean IsProofIFFOEQ() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_OEQ;
    }

    public boolean IsProofNNFPos() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_POS;
    }

    public boolean IsProofNNFNeg() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_NEG;
    }

    public boolean IsProofNNFStar() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_STAR;
    }

    public boolean IsProofCNFStar() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_CNF_STAR;
    }

    public boolean IsProofSkolemize() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_SKOLEMIZE;
    }

    public boolean IsProofModusPonensOEQ() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_MODUS_PONENS_OEQ;
    }

    public boolean IsProofTheoryLemma() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_PR_TH_LEMMA;
    }

    public boolean IsRelation() throws Z3Exception {
        return Native.isApp(this.Context().nCtx(), this.NativeObject()) && Native.getSortKind(this.Context().nCtx(), Native.getSort(this.Context().nCtx(), this.NativeObject())) == Z3_sort_kind.Z3_RELATION_SORT.toInt();
    }

    public boolean IsRelationStore() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_STORE;
    }

    public boolean IsEmptyRelation() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_EMPTY;
    }

    public boolean IsIsEmptyRelation() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_IS_EMPTY;
    }

    public boolean IsRelationalJoin() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_JOIN;
    }

    public boolean IsRelationUnion() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_UNION;
    }

    public boolean IsRelationWiden() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_WIDEN;
    }

    public boolean IsRelationProject() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_PROJECT;
    }

    public boolean IsRelationFilter() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_FILTER;
    }

    public boolean IsRelationNegationFilter() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_NEGATION_FILTER;
    }

    public boolean IsRelationRename() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_RENAME;
    }

    public boolean IsRelationComplement() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_COMPLEMENT;
    }

    public boolean IsRelationSelect() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_SELECT;
    }

    public boolean IsRelationClone() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_RA_CLONE;
    }

    public boolean IsFiniteDomain() throws Z3Exception {
        return Native.isApp(this.Context().nCtx(), this.NativeObject()) && Native.getSortKind(this.Context().nCtx(), Native.getSort(this.Context().nCtx(), this.NativeObject())) == Z3_sort_kind.Z3_FINITE_DOMAIN_SORT.toInt();
    }

    public boolean IsFiniteDomainLT() throws Z3Exception {
        return this.FuncDecl().DeclKind() == Z3_decl_kind.Z3_OP_FD_LT;
    }

    public int Index() throws Z3Exception {
        if (!this.IsVar()) {
            throw new Z3Exception("Term is not a bound variable.");
        }
        return Native.getIndexValue(this.Context().nCtx(), this.NativeObject());
    }

    protected Expr(Context context) {
        super(context);
    }

    protected Expr(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void CheckNativeObject(long l) throws Z3Exception {
        if (Native.isApp(this.Context().nCtx(), l) ^ true && Native.getAstKind(this.Context().nCtx(), l) != Z3_ast_kind.Z3_VAR_AST.toInt() && Native.getAstKind(this.Context().nCtx(), l) != Z3_ast_kind.Z3_QUANTIFIER_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a term");
        }
        super.CheckNativeObject(l);
    }

    static Expr Create(Context context, FuncDecl funcDecl, Expr[] exprArray) throws Z3Exception {
        long l = Native.mkApp(context.nCtx(), funcDecl.NativeObject(), AST.ArrayLength(exprArray), AST.ArrayToNative(exprArray));
        return Expr.Create(context, l);
    }

    static Expr Create(Context context, long l) throws Z3Exception {
        Z3_ast_kind z3_ast_kind = Z3_ast_kind.fromInt(Native.getAstKind(context.nCtx(), l));
        if (z3_ast_kind == Z3_ast_kind.Z3_QUANTIFIER_AST) {
            return new Quantifier(context, l);
        }
        long l2 = Native.getSort(context.nCtx(), l);
        Z3_sort_kind z3_sort_kind = Z3_sort_kind.fromInt(Native.getSortKind(context.nCtx(), l2));
        if (Native.isAlgebraicNumber(context.nCtx(), l)) {
            return new AlgebraicNum(context, l);
        }
        if (Native.isNumeralAst(context.nCtx(), l)) {
            switch (z3_sort_kind) {
                case Z3_INT_SORT: {
                    return new IntNum(context, l);
                }
                case Z3_REAL_SORT: {
                    return new RatNum(context, l);
                }
                case Z3_BV_SORT: {
                    return new BitVecNum(context, l);
                }
            }
        }
        switch (z3_sort_kind) {
            case Z3_BOOL_SORT: {
                return new BoolExpr(context, l);
            }
            case Z3_INT_SORT: {
                return new IntExpr(context, l);
            }
            case Z3_REAL_SORT: {
                return new RealExpr(context, l);
            }
            case Z3_BV_SORT: {
                return new BitVecExpr(context, l);
            }
            case Z3_ARRAY_SORT: {
                return new ArrayExpr(context, l);
            }
            case Z3_DATATYPE_SORT: {
                return new DatatypeExpr(context, l);
            }
        }
        return new Expr(context, l);
    }
}

