/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_parameter_kind;

public class FuncDecl
extends AST {
    public boolean Equals(Object object) {
        FuncDecl funcDecl = (FuncDecl)object;
        if (funcDecl == null) {
            return false;
        }
        return this == funcDecl;
    }

    @Override
    public int GetHashCode() throws Z3Exception {
        return super.GetHashCode();
    }

    @Override
    public String toString() {
        try {
            return Native.funcDeclToString(this.Context().nCtx(), this.NativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    @Override
    public int Id() throws Z3Exception {
        return Native.getFuncDeclId(this.Context().nCtx(), this.NativeObject());
    }

    public int Arity() throws Z3Exception {
        return Native.getArity(this.Context().nCtx(), this.NativeObject());
    }

    public int DomainSize() throws Z3Exception {
        return Native.getDomainSize(this.Context().nCtx(), this.NativeObject());
    }

    public Sort[] Domain() throws Z3Exception {
        int n = this.DomainSize();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.Create(this.Context(), Native.getDomain(this.Context().nCtx(), this.NativeObject(), i));
        }
        return sortArray;
    }

    public Sort Range() throws Z3Exception {
        return Sort.Create(this.Context(), Native.getRange(this.Context().nCtx(), this.NativeObject()));
    }

    public Z3_decl_kind DeclKind() throws Z3Exception {
        return Z3_decl_kind.fromInt(Native.getDeclKind(this.Context().nCtx(), this.NativeObject()));
    }

    public Symbol Name() throws Z3Exception {
        return Symbol.Create(this.Context(), Native.getDeclName(this.Context().nCtx(), this.NativeObject()));
    }

    public int NumParameters() throws Z3Exception {
        return Native.getDeclNumParameters(this.Context().nCtx(), this.NativeObject());
    }

    public Parameter[] Parameters() throws Z3Exception {
        int n = this.NumParameters();
        Parameter[] parameterArray = new Parameter[n];
        block9: for (int i = 0; i < n; ++i) {
            Z3_parameter_kind z3_parameter_kind = Z3_parameter_kind.fromInt(Native.getDeclParameterKind(this.Context().nCtx(), this.NativeObject(), i));
            switch (z3_parameter_kind) {
                case Z3_PARAMETER_INT: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Native.getDeclIntParameter(this.Context().nCtx(), this.NativeObject(), i));
                    continue block9;
                }
                case Z3_PARAMETER_DOUBLE: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Native.getDeclDoubleParameter(this.Context().nCtx(), this.NativeObject(), i));
                    continue block9;
                }
                case Z3_PARAMETER_SYMBOL: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Symbol.Create(this.Context(), Native.getDeclSymbolParameter(this.Context().nCtx(), this.NativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_SORT: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Sort.Create(this.Context(), Native.getDeclSortParameter(this.Context().nCtx(), this.NativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_AST: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, new AST(this.Context(), Native.getDeclAstParameter(this.Context().nCtx(), this.NativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_FUNC_DECL: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, new FuncDecl(this.Context(), Native.getDeclFuncDeclParameter(this.Context().nCtx(), this.NativeObject(), i)));
                    continue block9;
                }
                case Z3_PARAMETER_RATIONAL: {
                    parameterArray[i] = new Parameter(z3_parameter_kind, Native.getDeclRationalParameter(this.Context().nCtx(), this.NativeObject(), i));
                    continue block9;
                }
                default: {
                    throw new Z3Exception("Unknown function declaration parameter kind encountered");
                }
            }
        }
        return parameterArray;
    }

    FuncDecl(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    FuncDecl(Context context, Symbol symbol, Sort[] sortArray, Sort sort) throws Z3Exception {
        super(context, Native.mkFuncDecl(context.nCtx(), symbol.NativeObject(), AST.ArrayLength(sortArray), AST.ArrayToNative(sortArray), sort.NativeObject()));
    }

    FuncDecl(Context context, String string, Sort[] sortArray, Sort sort) throws Z3Exception {
        super(context, Native.mkFreshFuncDecl(context.nCtx(), string, AST.ArrayLength(sortArray), AST.ArrayToNative(sortArray), sort.NativeObject()));
    }

    @Override
    void CheckNativeObject(long l) throws Z3Exception {
        if (Native.getAstKind(this.Context().nCtx(), l) != Z3_ast_kind.Z3_FUNC_DECL_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a function declaration");
        }
        super.CheckNativeObject(l);
    }

    public Expr Apply(Expr[] exprArray) throws Z3Exception {
        this.Context().CheckContextMatch(exprArray);
        return Expr.Create(this.Context(), this, exprArray);
    }

    public Expr Apply(Expr expr) throws Z3Exception {
        this.Context().CheckContextMatch(expr);
        Expr[] exprArray = new Expr[]{expr};
        return Expr.Create(this.Context(), this, exprArray);
    }

    public class Parameter {
        private Z3_parameter_kind kind;
        private int i;
        private double d;
        private Symbol sym;
        private Sort srt;
        private AST ast;
        private FuncDecl fd;
        private String r;

        public int Int() throws Z3Exception {
            if (this.ParameterKind() != Z3_parameter_kind.Z3_PARAMETER_INT) {
                throw new Z3Exception("parameter is not an int");
            }
            return this.i;
        }

        public double Double() throws Z3Exception {
            if (this.ParameterKind() != Z3_parameter_kind.Z3_PARAMETER_DOUBLE) {
                throw new Z3Exception("parameter is not a double ");
            }
            return this.d;
        }

        public Symbol Symbol() throws Z3Exception {
            if (this.ParameterKind() != Z3_parameter_kind.Z3_PARAMETER_SYMBOL) {
                throw new Z3Exception("parameter is not a Symbol");
            }
            return this.sym;
        }

        public Sort Sort() throws Z3Exception {
            if (this.ParameterKind() != Z3_parameter_kind.Z3_PARAMETER_SORT) {
                throw new Z3Exception("parameter is not a Sort");
            }
            return this.srt;
        }

        public AST AST() throws Z3Exception {
            if (this.ParameterKind() != Z3_parameter_kind.Z3_PARAMETER_AST) {
                throw new Z3Exception("parameter is not an AST");
            }
            return this.ast;
        }

        public FuncDecl FuncDecl() throws Z3Exception {
            if (this.ParameterKind() != Z3_parameter_kind.Z3_PARAMETER_FUNC_DECL) {
                throw new Z3Exception("parameter is not a function declaration");
            }
            return this.fd;
        }

        public String Rational() throws Z3Exception {
            if (this.ParameterKind() != Z3_parameter_kind.Z3_PARAMETER_RATIONAL) {
                throw new Z3Exception("parameter is not a rational String");
            }
            return this.r;
        }

        public Z3_parameter_kind ParameterKind() throws Z3Exception {
            return this.kind;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, int n) {
            this.kind = z3_parameter_kind;
            this.i = n;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, double d) {
            this.kind = z3_parameter_kind;
            this.d = d;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, Symbol symbol) {
            this.kind = z3_parameter_kind;
            this.sym = symbol;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, Sort sort) {
            this.kind = z3_parameter_kind;
            this.srt = sort;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, AST aST) {
            this.kind = z3_parameter_kind;
            this.ast = aST;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, FuncDecl funcDecl2) {
            this.kind = z3_parameter_kind;
            this.fd = funcDecl2;
        }

        Parameter(Z3_parameter_kind z3_parameter_kind, String string) {
            this.kind = z3_parameter_kind;
            this.r = string;
        }
    }
}

