/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;

public class FuncInterp
extends Z3Object {
    public int NumEntries() throws Z3Exception {
        return Native.funcInterpGetNumEntries(this.Context().nCtx(), this.NativeObject());
    }

    public Entry[] Entries() throws Z3Exception {
        int n = this.NumEntries();
        Entry[] entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            entryArray[i] = new Entry(this.Context(), Native.funcInterpGetEntry(this.Context().nCtx(), this.NativeObject(), i));
        }
        return entryArray;
    }

    public Expr Else() throws Z3Exception {
        return Expr.Create(this.Context(), Native.funcInterpGetElse(this.Context().nCtx(), this.NativeObject()));
    }

    public int Arity() throws Z3Exception {
        return Native.funcInterpGetArity(this.Context().nCtx(), this.NativeObject());
    }

    public String toString() {
        try {
            String string = "";
            string = string + "[";
            for (Entry entry : this.Entries()) {
                int n = entry.NumArgs();
                if (n > 1) {
                    string = string + "[";
                }
                Expr[] exprArray = entry.Args();
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        string = string + ", ";
                    }
                    string = string + exprArray[i];
                }
                if (n > 1) {
                    string = string + "]";
                }
                string = string + " -> " + entry.Value() + ", ";
            }
            string = string + "else -> " + this.Else();
            string = string + "]";
            return string;
        }
        catch (Z3Exception z3Exception) {
            return new String("Z3Exception: " + z3Exception.getMessage());
        }
    }

    FuncInterp(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void IncRef(long l) throws Z3Exception {
        this.Context().FuncInterp_DRQ().IncAndClear(this.Context(), l);
        super.IncRef(l);
    }

    @Override
    void DecRef(long l) throws Z3Exception {
        this.Context().FuncInterp_DRQ().Add(l);
        super.DecRef(l);
    }

    public class Entry
    extends Z3Object {
        public Expr Value() throws Z3Exception {
            return Expr.Create(this.Context(), Native.funcEntryGetValue(this.Context().nCtx(), this.NativeObject()));
        }

        public int NumArgs() throws Z3Exception {
            return Native.funcEntryGetNumArgs(this.Context().nCtx(), this.NativeObject());
        }

        public Expr[] Args() throws Z3Exception {
            int n = this.NumArgs();
            Expr[] exprArray = new Expr[n];
            for (int i = 0; i < n; ++i) {
                exprArray[i] = Expr.Create(this.Context(), Native.funcEntryGetArg(this.Context().nCtx(), this.NativeObject(), i));
            }
            return exprArray;
        }

        public String toString() {
            try {
                int n = this.NumArgs();
                String string = "[";
                Expr[] exprArray = this.Args();
                for (int i = 0; i < n; ++i) {
                    string = string + exprArray[i] + ", ";
                }
                return string + this.Value() + "]";
            }
            catch (Z3Exception z3Exception) {
                return new String("Z3Exception: " + z3Exception.getMessage());
            }
        }

        Entry(Context context, long l) throws Z3Exception {
            super(context, l);
        }

        @Override
        void IncRef(long l) throws Z3Exception {
            this.Context().FuncEntry_DRQ().IncAndClear(this.Context(), l);
            super.IncRef(l);
        }

        @Override
        void DecRef(long l) throws Z3Exception {
            this.Context().FuncEntry_DRQ().Add(l);
            super.DecRef(l);
        }
    }
}

