/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ASTVector;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterp;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Model
extends Z3Object {
    public Expr ConstInterp(Expr expr) throws Z3Exception {
        this.Context().CheckContextMatch(expr);
        return this.ConstInterp(expr.FuncDecl());
    }

    public Expr ConstInterp(FuncDecl funcDecl) throws Z3Exception {
        this.Context().CheckContextMatch(funcDecl);
        if (funcDecl.Arity() != 0 || Native.getSortKind(this.Context().nCtx(), Native.getRange(this.Context().nCtx(), funcDecl.NativeObject())) == Z3_sort_kind.Z3_ARRAY_SORT.toInt()) {
            throw new Z3Exception("Non-zero arity functions and arrays have FunctionInterpretations as a model. Use FuncInterp.");
        }
        long l = Native.modelGetConstInterp(this.Context().nCtx(), this.NativeObject(), funcDecl.NativeObject());
        if (l == 0L) {
            return null;
        }
        return Expr.Create(this.Context(), l);
    }

    public FuncInterp FuncInterp(FuncDecl funcDecl) throws Z3Exception {
        this.Context().CheckContextMatch(funcDecl);
        Z3_sort_kind z3_sort_kind = Z3_sort_kind.fromInt(Native.getSortKind(this.Context().nCtx(), Native.getRange(this.Context().nCtx(), funcDecl.NativeObject())));
        if (funcDecl.Arity() == 0) {
            long l = Native.modelGetConstInterp(this.Context().nCtx(), this.NativeObject(), funcDecl.NativeObject());
            if (z3_sort_kind == Z3_sort_kind.Z3_ARRAY_SORT) {
                if (l == 0L) {
                    return null;
                }
                if (Native.isAsArray(this.Context().nCtx(), l) ^ true) {
                    throw new Z3Exception("Argument was not an array constant");
                }
                long l2 = Native.getAsArrayFuncDecl(this.Context().nCtx(), l);
                return this.FuncInterp(new FuncDecl(this.Context(), l2));
            }
            throw new Z3Exception("Constant functions do not have a function interpretation; use ConstInterp");
        }
        long l = Native.modelGetFuncInterp(this.Context().nCtx(), this.NativeObject(), funcDecl.NativeObject());
        if (l == 0L) {
            return null;
        }
        return new FuncInterp(this.Context(), l);
    }

    public int NumConsts() throws Z3Exception {
        return Native.modelGetNumConsts(this.Context().nCtx(), this.NativeObject());
    }

    public FuncDecl[] ConstDecls() throws Z3Exception {
        int n = this.NumConsts();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this.Context(), Native.modelGetConstDecl(this.Context().nCtx(), this.NativeObject(), i));
        }
        return funcDeclArray;
    }

    public int NumFuncs() throws Z3Exception {
        return Native.modelGetNumFuncs(this.Context().nCtx(), this.NativeObject());
    }

    public FuncDecl[] FuncDecls() throws Z3Exception {
        int n = this.NumFuncs();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this.Context(), Native.modelGetFuncDecl(this.Context().nCtx(), this.NativeObject(), i));
        }
        return funcDeclArray;
    }

    public FuncDecl[] Decls() throws Z3Exception {
        int n;
        int n2 = this.NumFuncs();
        int n3 = this.NumConsts();
        int n4 = n2 + n3;
        FuncDecl[] funcDeclArray = new FuncDecl[n4];
        for (n = 0; n < n3; ++n) {
            funcDeclArray[n] = new FuncDecl(this.Context(), Native.modelGetConstDecl(this.Context().nCtx(), this.NativeObject(), n));
        }
        for (n = 0; n < n2; ++n) {
            funcDeclArray[n3 + n] = new FuncDecl(this.Context(), Native.modelGetFuncDecl(this.Context().nCtx(), this.NativeObject(), n));
        }
        return funcDeclArray;
    }

    public Expr Eval(Expr expr, boolean bl) throws Z3Exception {
        Native.LongPtr longPtr = new Native.LongPtr();
        if (Native.modelEval(this.Context().nCtx(), this.NativeObject(), expr.NativeObject(), bl, longPtr) ^ true) {
            throw new ModelEvaluationFailedException();
        }
        return Expr.Create(this.Context(), longPtr.value);
    }

    public Expr Evaluate(Expr expr, boolean bl) throws Z3Exception {
        return this.Eval(expr, bl);
    }

    public int NumSorts() throws Z3Exception {
        return Native.modelGetNumSorts(this.Context().nCtx(), this.NativeObject());
    }

    public Sort[] Sorts() throws Z3Exception {
        int n = this.NumSorts();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.Create(this.Context(), Native.modelGetSort(this.Context().nCtx(), this.NativeObject(), i));
        }
        return sortArray;
    }

    public Expr[] SortUniverse(Sort sort) throws Z3Exception {
        ASTVector aSTVector = new ASTVector(this.Context(), Native.modelGetSortUniverse(this.Context().nCtx(), this.NativeObject(), sort.NativeObject()));
        int n = aSTVector.Size();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.Create(this.Context(), aSTVector.get(i).NativeObject());
        }
        return exprArray;
    }

    public String toString() {
        try {
            return Native.modelToString(this.Context().nCtx(), this.NativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    Model(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void IncRef(long l) throws Z3Exception {
        this.Context().Model_DRQ().IncAndClear(this.Context(), l);
        super.IncRef(l);
    }

    @Override
    void DecRef(long l) throws Z3Exception {
        this.Context().Model_DRQ().Add(l);
        super.DecRef(l);
    }

    public class ModelEvaluationFailedException
    extends Z3Exception {
    }
}

