/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Native;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;

public class Quantifier
extends BoolExpr {
    public boolean IsUniversal() throws Z3Exception {
        return Native.isQuantifierForall(this.Context().nCtx(), this.NativeObject());
    }

    public boolean IsExistential() throws Z3Exception {
        return !this.IsUniversal();
    }

    public int Weight() throws Z3Exception {
        return Native.getQuantifierWeight(this.Context().nCtx(), this.NativeObject());
    }

    public int NumPatterns() throws Z3Exception {
        return Native.getQuantifierNumPatterns(this.Context().nCtx(), this.NativeObject());
    }

    public Pattern[] Patterns() throws Z3Exception {
        int n = this.NumPatterns();
        Pattern[] patternArray = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            patternArray[i] = new Pattern(this.Context(), Native.getQuantifierPatternAst(this.Context().nCtx(), this.NativeObject(), i));
        }
        return patternArray;
    }

    public int NumNoPatterns() throws Z3Exception {
        return Native.getQuantifierNumNoPatterns(this.Context().nCtx(), this.NativeObject());
    }

    public Pattern[] NoPatterns() throws Z3Exception {
        int n = this.NumNoPatterns();
        Pattern[] patternArray = new Pattern[n];
        for (int i = 0; i < n; ++i) {
            patternArray[i] = new Pattern(this.Context(), Native.getQuantifierNoPatternAst(this.Context().nCtx(), this.NativeObject(), i));
        }
        return patternArray;
    }

    public int NumBound() throws Z3Exception {
        return Native.getQuantifierNumBound(this.Context().nCtx(), this.NativeObject());
    }

    public Symbol[] BoundVariableNames() throws Z3Exception {
        int n = this.NumBound();
        Symbol[] symbolArray = new Symbol[n];
        for (int i = 0; i < n; ++i) {
            symbolArray[i] = Symbol.Create(this.Context(), Native.getQuantifierBoundName(this.Context().nCtx(), this.NativeObject(), i));
        }
        return symbolArray;
    }

    public Sort[] BoundVariableSorts() throws Z3Exception {
        int n = this.NumBound();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.Create(this.Context(), Native.getQuantifierBoundSort(this.Context().nCtx(), this.NativeObject(), i));
        }
        return sortArray;
    }

    public BoolExpr Body() throws Z3Exception {
        return new BoolExpr(this.Context(), Native.getQuantifierBody(this.Context().nCtx(), this.NativeObject()));
    }

    Quantifier(Context context, boolean bl, Sort[] sortArray, Symbol[] symbolArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray, Symbol symbol, Symbol symbol2) throws Z3Exception {
        super(context);
        this.Context().CheckContextMatch(patternArray);
        this.Context().CheckContextMatch(exprArray);
        this.Context().CheckContextMatch(sortArray);
        this.Context().CheckContextMatch(symbolArray);
        this.Context().CheckContextMatch(expr);
        if (sortArray.length != symbolArray.length) {
            throw new Z3Exception("Number of sorts does not match number of names");
        }
        if (exprArray == null && symbol == null && symbol2 == null) {
            this.setNativeObject(Native.mkQuantifier(context.nCtx(), bl, n, AST.ArrayLength(patternArray), AST.ArrayToNative(patternArray), AST.ArrayLength(sortArray), AST.ArrayToNative(sortArray), Symbol.ArrayToNative(symbolArray), expr.NativeObject()));
        } else {
            this.setNativeObject(Native.mkQuantifierEx(context.nCtx(), bl, n, AST.GetNativeObject(symbol), AST.GetNativeObject(symbol2), AST.ArrayLength(patternArray), AST.ArrayToNative(patternArray), AST.ArrayLength(exprArray), AST.ArrayToNative(exprArray), AST.ArrayLength(sortArray), AST.ArrayToNative(sortArray), Symbol.ArrayToNative(symbolArray), expr.NativeObject()));
        }
    }

    Quantifier(Context context, boolean bl, Expr[] exprArray, Expr expr, int n, Pattern[] patternArray, Expr[] exprArray2, Symbol symbol, Symbol symbol2) throws Z3Exception {
        super(context);
        this.Context().CheckContextMatch(exprArray2);
        this.Context().CheckContextMatch(patternArray);
        this.Context().CheckContextMatch(expr);
        if (exprArray2 == null && symbol == null && symbol2 == null) {
            this.setNativeObject(Native.mkQuantifierConst(context.nCtx(), bl, n, AST.ArrayLength(exprArray), AST.ArrayToNative(exprArray), AST.ArrayLength(patternArray), AST.ArrayToNative(patternArray), expr.NativeObject()));
        } else {
            this.setNativeObject(Native.mkQuantifierConstEx(context.nCtx(), bl, n, AST.GetNativeObject(symbol), AST.GetNativeObject(symbol2), AST.ArrayLength(exprArray), AST.ArrayToNative(exprArray), AST.ArrayLength(patternArray), AST.ArrayToNative(patternArray), AST.ArrayLength(exprArray2), AST.ArrayToNative(exprArray2), expr.NativeObject()));
        }
    }

    Quantifier(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void CheckNativeObject(long l) throws Z3Exception {
        if (Native.getAstKind(this.Context().nCtx(), l) != Z3_ast_kind.Z3_QUANTIFIER_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a quantifier");
        }
        super.CheckNativeObject(l);
    }
}

