/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ASTVector;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Native;
import com.microsoft.z3.ParamDescrs;
import com.microsoft.z3.Params;
import com.microsoft.z3.Statistics;
import com.microsoft.z3.Status;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_lbool;

public class Solver
extends Z3Object {
    public String Help() throws Z3Exception {
        return Native.solverGetHelp(this.Context().nCtx(), this.NativeObject());
    }

    public void setParameters(Params params) throws Z3Exception {
        this.Context().CheckContextMatch(params);
        Native.solverSetParams(this.Context().nCtx(), this.NativeObject(), params.NativeObject());
    }

    public ParamDescrs ParameterDescriptions() throws Z3Exception {
        return new ParamDescrs(this.Context(), Native.solverGetParamDescrs(this.Context().nCtx(), this.NativeObject()));
    }

    public int NumScopes() throws Z3Exception {
        return Native.solverGetNumScopes(this.Context().nCtx(), this.NativeObject());
    }

    public void Push() throws Z3Exception {
        Native.solverPush(this.Context().nCtx(), this.NativeObject());
    }

    public void Pop() throws Z3Exception {
        this.Pop(1);
    }

    public void Pop(int n) throws Z3Exception {
        Native.solverPop(this.Context().nCtx(), this.NativeObject(), n);
    }

    public void Reset() throws Z3Exception {
        Native.solverReset(this.Context().nCtx(), this.NativeObject());
    }

    public void Assert(BoolExpr[] boolExprArray) throws Z3Exception {
        this.Context().CheckContextMatch(boolExprArray);
        for (BoolExpr boolExpr : boolExprArray) {
            Native.solverAssert(this.Context().nCtx(), this.NativeObject(), boolExpr.NativeObject());
        }
    }

    public void Assert(BoolExpr boolExpr) throws Z3Exception {
        this.Context().CheckContextMatch(boolExpr);
        Native.solverAssert(this.Context().nCtx(), this.NativeObject(), boolExpr.NativeObject());
    }

    public int NumAssertions() throws Z3Exception {
        ASTVector aSTVector = new ASTVector(this.Context(), Native.solverGetAssertions(this.Context().nCtx(), this.NativeObject()));
        return aSTVector.Size();
    }

    public BoolExpr[] Assertions() throws Z3Exception {
        ASTVector aSTVector = new ASTVector(this.Context(), Native.solverGetAssertions(this.Context().nCtx(), this.NativeObject()));
        int n = aSTVector.Size();
        BoolExpr[] boolExprArray = new BoolExpr[n];
        for (int i = 0; i < n; ++i) {
            boolExprArray[i] = new BoolExpr(this.Context(), aSTVector.get(i).NativeObject());
        }
        return boolExprArray;
    }

    public Status Check(Expr[] exprArray) throws Z3Exception {
        Z3_lbool z3_lbool = exprArray == null ? Z3_lbool.fromInt(Native.solverCheck(this.Context().nCtx(), this.NativeObject())) : Z3_lbool.fromInt(Native.solverCheckAssumptions(this.Context().nCtx(), this.NativeObject(), exprArray.length, AST.ArrayToNative(exprArray)));
        switch (z3_lbool) {
            case Z3_L_TRUE: {
                return Status.SATISFIABLE;
            }
            case Z3_L_FALSE: {
                return Status.UNSATISFIABLE;
            }
        }
        return Status.UNKNOWN;
    }

    public Status Check() throws Z3Exception {
        return this.Check(null);
    }

    public Model Model() throws Z3Exception {
        long l = Native.solverGetModel(this.Context().nCtx(), this.NativeObject());
        if (l == 0L) {
            return null;
        }
        return new Model(this.Context(), l);
    }

    public Expr Proof() throws Z3Exception {
        long l = Native.solverGetProof(this.Context().nCtx(), this.NativeObject());
        if (l == 0L) {
            return null;
        }
        return Expr.Create(this.Context(), l);
    }

    public Expr[] UnsatCore() throws Z3Exception {
        ASTVector aSTVector = new ASTVector(this.Context(), Native.solverGetUnsatCore(this.Context().nCtx(), this.NativeObject()));
        int n = aSTVector.Size();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.Create(this.Context(), aSTVector.get(i).NativeObject());
        }
        return exprArray;
    }

    public String ReasonUnknown() throws Z3Exception {
        return Native.solverGetReasonUnknown(this.Context().nCtx(), this.NativeObject());
    }

    public Statistics Statistics() throws Z3Exception {
        return new Statistics(this.Context(), Native.solverGetStatistics(this.Context().nCtx(), this.NativeObject()));
    }

    public String toString() {
        try {
            return Native.solverToString(this.Context().nCtx(), this.NativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    Solver(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void IncRef(long l) throws Z3Exception {
        this.Context().Solver_DRQ().IncAndClear(this.Context(), l);
        super.IncRef(l);
    }

    @Override
    void DecRef(long l) throws Z3Exception {
        this.Context().Solver_DRQ().Add(l);
        super.DecRef(l);
    }
}

