/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.BoolSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeSort;
import com.microsoft.z3.FiniteDomainSort;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.Native;
import com.microsoft.z3.RealSort;
import com.microsoft.z3.RelationSort;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.UninterpretedSort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Sort
extends AST {
    @Override
    public boolean equals(Object object) {
        Sort sort = null;
        try {
            sort = (Sort)Sort.class.cast(object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.NativeObject() == sort.NativeObject();
    }

    @Override
    public int GetHashCode() throws Z3Exception {
        return super.GetHashCode();
    }

    @Override
    public int Id() throws Z3Exception {
        return Native.getSortId(this.Context().nCtx(), this.NativeObject());
    }

    public Z3_sort_kind SortKind() throws Z3Exception {
        return Z3_sort_kind.fromInt(Native.getSortKind(this.Context().nCtx(), this.NativeObject()));
    }

    public Symbol Name() throws Z3Exception {
        return Symbol.Create(this.Context(), Native.getSortName(this.Context().nCtx(), this.NativeObject()));
    }

    @Override
    public String toString() {
        try {
            return Native.sortToString(this.Context().nCtx(), this.NativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    protected Sort(Context context) throws Z3Exception {
        super(context);
    }

    Sort(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void CheckNativeObject(long l) throws Z3Exception {
        if (Native.getAstKind(this.Context().nCtx(), l) != Z3_ast_kind.Z3_SORT_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a sort");
        }
        super.CheckNativeObject(l);
    }

    static Sort Create(Context context, long l) throws Z3Exception {
        switch (Z3_sort_kind.fromInt(Native.getSortKind(context.nCtx(), l))) {
            case Z3_ARRAY_SORT: {
                return new ArraySort(context, l);
            }
            case Z3_BOOL_SORT: {
                return new BoolSort(context, l);
            }
            case Z3_BV_SORT: {
                return new BitVecSort(context, l);
            }
            case Z3_DATATYPE_SORT: {
                return new DatatypeSort(context, l);
            }
            case Z3_INT_SORT: {
                return new IntSort(context, l);
            }
            case Z3_REAL_SORT: {
                return new RealSort(context, l);
            }
            case Z3_UNINTERPRETED_SORT: {
                return new UninterpretedSort(context, l);
            }
            case Z3_FINITE_DOMAIN_SORT: {
                return new FiniteDomainSort(context, l);
            }
            case Z3_RELATION_SORT: {
                return new RelationSort(context, l);
            }
        }
        throw new Z3Exception("Unknown sort kind");
    }
}

