/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;

public class Statistics
extends Z3Object {
    public String toString() {
        try {
            return Native.statsToString(this.Context().nCtx(), this.NativeObject());
        }
        catch (Z3Exception z3Exception) {
            return "Z3Exception: " + z3Exception.getMessage();
        }
    }

    public int Size() throws Z3Exception {
        return Native.statsSize(this.Context().nCtx(), this.NativeObject());
    }

    public Entry[] Entries() throws Z3Exception {
        int n = this.Size();
        Entry[] entryArray = new Entry[n];
        for (int i = 0; i < n; ++i) {
            Entry entry;
            String string = Native.statsGetKey(this.Context().nCtx(), this.NativeObject(), i);
            if (Native.statsIsUint(this.Context().nCtx(), this.NativeObject(), i)) {
                entry = new Entry(string, Native.statsGetUintValue(this.Context().nCtx(), this.NativeObject(), i));
            } else if (Native.statsIsDouble(this.Context().nCtx(), this.NativeObject(), i)) {
                entry = new Entry(string, Native.statsGetDoubleValue(this.Context().nCtx(), this.NativeObject(), i));
            } else {
                throw new Z3Exception("Unknown data entry value");
            }
            entryArray[i] = entry;
        }
        return entryArray;
    }

    public String[] Keys() throws Z3Exception {
        int n = this.Size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Native.statsGetKey(this.Context().nCtx(), this.NativeObject(), i);
        }
        return stringArray;
    }

    public Entry get(String string) throws Z3Exception {
        int n = this.Size();
        Entry[] entryArray = this.Entries();
        for (int i = 0; i < n; ++i) {
            if (entryArray[i].Key != string) continue;
            return entryArray[i];
        }
        return null;
    }

    Statistics(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    @Override
    void IncRef(long l) throws Z3Exception {
        this.Context().Statistics_DRQ().IncAndClear(this.Context(), l);
        super.IncRef(l);
    }

    @Override
    void DecRef(long l) throws Z3Exception {
        this.Context().Statistics_DRQ().Add(l);
        super.DecRef(l);
    }

    public class Entry {
        public String Key;
        private boolean m_is_int = false;
        private boolean m_is_double = false;
        private int m_int = 0;
        private double m_double = 0.0;

        public int UIntValue() {
            return this.m_int;
        }

        public double DoubleValue() {
            return this.m_double;
        }

        public boolean IsUInt() {
            return this.m_is_int;
        }

        public boolean IsDouble() {
            return this.m_is_double;
        }

        public String Value() throws Z3Exception {
            if (this.IsUInt()) {
                return Integer.toString(this.m_int);
            }
            if (this.IsDouble()) {
                return Double.toString(this.m_double);
            }
            throw new Z3Exception("Unknown statistical entry type");
        }

        public String toString() {
            try {
                return this.Key + ": " + this.Value();
            }
            catch (Z3Exception z3Exception) {
                return new String("Z3Exception: " + z3Exception.getMessage());
            }
        }

        Entry(String string, int n) {
            this.Key = string;
            this.m_is_int = true;
            this.m_int = n;
        }

        Entry(String string, double d) {
            this.Key = string;
            this.m_is_double = true;
            this.m_double = d;
        }
    }
}

