/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.Native;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.enumerations.Z3_symbol_kind;

public class Symbol
extends Z3Object {
    protected Z3_symbol_kind Kind() throws Z3Exception {
        return Z3_symbol_kind.fromInt(Native.getSymbolKind(this.Context().nCtx(), this.NativeObject()));
    }

    public boolean IsIntSymbol() throws Z3Exception {
        return this.Kind() == Z3_symbol_kind.Z3_INT_SYMBOL;
    }

    public boolean IsStringSymbol() throws Z3Exception {
        return this.Kind() == Z3_symbol_kind.Z3_STRING_SYMBOL;
    }

    public String toString() {
        try {
            if (this.IsIntSymbol()) {
                return Integer.toString(((IntSymbol)this).Int());
            }
            if (this.IsStringSymbol()) {
                return ((StringSymbol)this).String();
            }
            return new String("Z3Exception: Unknown symbol kind encountered.");
        }
        catch (Z3Exception z3Exception) {
            return new String("Z3Exception: " + z3Exception.getMessage());
        }
    }

    protected Symbol(Context context, long l) throws Z3Exception {
        super(context, l);
    }

    static Symbol Create(Context context, long l) throws Z3Exception {
        switch (Z3_symbol_kind.fromInt(Native.getSymbolKind(context.nCtx(), l))) {
            case Z3_INT_SYMBOL: {
                return new IntSymbol(context, l);
            }
            case Z3_STRING_SYMBOL: {
                return new StringSymbol(context, l);
            }
        }
        throw new Z3Exception("Unknown symbol kind encountered");
    }
}

