/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jdbm.helper.LongPacker;

class LeadingValueCompressionProvider {
    LeadingValueCompressionProvider() {
    }

    static byte[] readByteArray(DataInputStream in, byte[] previous, int ignoreLeadingCount) throws IOException {
        int len = LongPacker.unpackInt(in) - 1;
        if (len == -1) {
            return null;
        }
        int actualCommon = 0;
        actualCommon = LongPacker.unpackInt(in);
        byte[] buf = new byte[len];
        if (previous == null) {
            actualCommon = 0;
        }
        if (actualCommon > 0) {
            in.readFully(buf, 0, ignoreLeadingCount);
            System.arraycopy(previous, ignoreLeadingCount, buf, ignoreLeadingCount, actualCommon - ignoreLeadingCount);
        }
        in.readFully(buf, actualCommon, len - actualCommon);
        return buf;
    }

    static void writeByteArray(DataOutputStream out, byte[] buf, byte[] previous, int ignoreLeadingCount) throws IOException {
        if (buf == null) {
            LongPacker.packInt(out, 0);
            return;
        }
        int actualCommon = ignoreLeadingCount;
        if (previous != null) {
            int maxCommon;
            int n = maxCommon = buf.length > previous.length ? previous.length : buf.length;
            if (maxCommon > Short.MAX_VALUE) {
                maxCommon = Short.MAX_VALUE;
            }
            while (actualCommon < maxCommon) {
                if (buf[actualCommon] != previous[actualCommon]) break;
                ++actualCommon;
            }
        }
        LongPacker.packInt(out, buf.length + 1);
        LongPacker.packInt(out, actualCommon);
        out.write(buf, 0, ignoreLeadingCount);
        out.write(buf, actualCommon, buf.length - actualCommon);
    }
}

