/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jdbm.InverseHashView;
import jdbm.RecordListener;
import jdbm.SecondaryHashMap;
import jdbm.SecondaryKeyExtractor;
import jdbm.SecondaryTreeMap;
import jdbm.Serializer;
import jdbm.btree.BTree;
import jdbm.btree.BTreeSecondarySortedMap;
import jdbm.helper.ComparableComparator;
import jdbm.helper.JdbmBase;
import jdbm.htree.HTree;
import jdbm.htree.HTreeSecondaryMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecondaryKeyHelper {
    public static <A, K, V> BTree<A, Iterable<K>> secondaryBTree(String objectName, final SecondaryKeyExtractor<A, K, V> keyExtractor, Comparator<A> comparator, JdbmBase<K, V> b) throws IOException {
        BTree secIndex = null;
        long recid = b.getRecordManager().getNamedObject(objectName);
        if (recid != 0L) {
            secIndex = BTree.load(b.getRecordManager(), recid);
        } else {
            secIndex = BTree.createInstance(b.getRecordManager(), comparator);
            b.getRecordManager().setNamedObject(objectName, secIndex.getRecid());
        }
        final BTree secIndex2 = secIndex;
        b.addRecordListener(new RecordListener<K, V>(){

            @Override
            public void recordInserted(K key, V value) throws IOException {
                Object secKey = keyExtractor.extractSecondaryKey(key, value);
                if (secKey == null) {
                    return;
                }
                ArrayList kk = (ArrayList)secIndex2.find(secKey);
                if (kk == null) {
                    kk = new ArrayList();
                }
                kk.add(key);
                secIndex2.insert(secKey, kk, true);
            }

            @Override
            public void recordRemoved(K key, V value) throws IOException {
                Object secKey = keyExtractor.extractSecondaryKey(key, value);
                List kk = (List)secIndex2.find(secKey);
                if (kk == null) {
                    return;
                }
                kk.remove(key);
                if (kk.isEmpty()) {
                    secIndex2.remove(secKey);
                } else {
                    secIndex2.insert(secKey, kk, true);
                }
            }

            @Override
            public void recordUpdated(K key, V oldValue, V newValue) throws IOException {
                Object oldSecKey = keyExtractor.extractSecondaryKey(key, oldValue);
                Object newSecKey = keyExtractor.extractSecondaryKey(key, newValue);
                if (oldSecKey == null && newSecKey == null) {
                    return;
                }
                if (oldSecKey == null && newSecKey != null) {
                    this.recordInserted(key, newValue);
                    return;
                }
                if (oldSecKey != null && newSecKey == null) {
                    this.recordRemoved(key, oldValue);
                    return;
                }
                if (oldSecKey.equals(newSecKey)) {
                    return;
                }
                this.recordRemoved(key, oldValue);
                this.recordInserted(key, newValue);
            }
        });
        return secIndex;
    }

    public static <A, K, V> HTree<A, Iterable<K>> secondaryHTree(String objectName, final SecondaryKeyExtractor<A, K, V> keyExtractor, JdbmBase<K, V> b, Serializer<A> secondaryKeySerializer) throws IOException {
        HTree secIndex = null;
        long recid = b.getRecordManager().getNamedObject(objectName);
        if (recid != 0L) {
            secIndex = HTree.load(b.getRecordManager(), recid, secondaryKeySerializer, null);
        } else {
            secIndex = HTree.createInstance(b.getRecordManager(), secondaryKeySerializer, null);
            b.getRecordManager().setNamedObject(objectName, secIndex.getRecid());
        }
        final HTree secIndex2 = secIndex;
        b.addRecordListener(new RecordListener<K, V>(){

            @Override
            public void recordInserted(K key, V value) throws IOException {
                Object secKey = keyExtractor.extractSecondaryKey(key, value);
                if (secKey == null) {
                    return;
                }
                ArrayList kk = (ArrayList)secIndex2.find(secKey);
                if (kk == null) {
                    kk = new ArrayList();
                }
                kk.add(key);
                secIndex2.put(secKey, kk);
            }

            @Override
            public void recordRemoved(K key, V value) throws IOException {
                Object secKey = keyExtractor.extractSecondaryKey(key, value);
                List kk = (List)secIndex2.find(secKey);
                if (kk == null) {
                    return;
                }
                kk.remove(key);
                if (kk.isEmpty()) {
                    secIndex2.remove(secKey);
                } else {
                    secIndex2.put(secKey, kk);
                }
            }

            @Override
            public void recordUpdated(K key, V oldValue, V newValue) throws IOException {
                Object oldSecKey = keyExtractor.extractSecondaryKey(key, oldValue);
                Object newSecKey = keyExtractor.extractSecondaryKey(key, newValue);
                if (oldSecKey == null && newSecKey == null) {
                    return;
                }
                if (oldSecKey == null && newSecKey != null) {
                    this.recordInserted(key, newValue);
                    return;
                }
                if (oldSecKey != null && newSecKey == null) {
                    this.recordRemoved(key, oldValue);
                    return;
                }
                if (oldSecKey.equals(newSecKey)) {
                    return;
                }
                this.recordRemoved(key, oldValue);
                this.recordInserted(key, newValue);
            }
        });
        return secIndex;
    }

    public static <A, K, V> BTree<A, Iterable<K>> secondaryBTreeManyToOne(String objectName, final SecondaryKeyExtractor<Iterable<A>, K, V> keyExtractor, Comparator<A> comparator, JdbmBase<K, V> b) throws IOException {
        BTree secIndex = null;
        long recid = b.getRecordManager().getNamedObject(objectName);
        if (recid != 0L) {
            secIndex = BTree.load(b.getRecordManager(), recid);
        } else {
            secIndex = BTree.createInstance(b.getRecordManager(), comparator);
            b.getRecordManager().setNamedObject(objectName, secIndex.getRecid());
        }
        final BTree secIndex2 = secIndex;
        b.addRecordListener(new RecordListener<K, V>(){

            @Override
            public void recordInserted(K key, V value) throws IOException {
                for (Object secKey : (Iterable)keyExtractor.extractSecondaryKey(key, value)) {
                    if (secKey == null) {
                        return;
                    }
                    ArrayList kk = (ArrayList)secIndex2.find(secKey);
                    if (kk == null) {
                        kk = new ArrayList();
                    }
                    kk.add(key);
                    secIndex2.insert(secKey, kk, true);
                }
            }

            @Override
            public void recordRemoved(K key, V value) throws IOException {
                for (Object secKey : (Iterable)keyExtractor.extractSecondaryKey(key, value)) {
                    List kk = (List)secIndex2.find(secKey);
                    if (kk == null) {
                        return;
                    }
                    kk.remove(key);
                    if (kk.isEmpty()) {
                        secIndex2.remove(secKey);
                        continue;
                    }
                    secIndex2.insert(secKey, kk, true);
                }
            }

            @Override
            public void recordUpdated(K key, V oldValue, V newValue) throws IOException {
                Iterable oldSecKey = (Iterable)keyExtractor.extractSecondaryKey(key, oldValue);
                Iterable newSecKey = (Iterable)keyExtractor.extractSecondaryKey(key, newValue);
                if (oldSecKey == null && newSecKey == null) {
                    return;
                }
                if (oldSecKey == null && newSecKey != null) {
                    this.recordInserted(key, newValue);
                    return;
                }
                if (oldSecKey != null && newSecKey == null) {
                    this.recordRemoved(key, oldValue);
                    return;
                }
                if (oldSecKey.equals(newSecKey)) {
                    return;
                }
                this.recordRemoved(key, oldValue);
                this.recordInserted(key, newValue);
            }
        });
        return secIndex;
    }

    public static <A, K, V> HTree<A, Iterable<K>> secondaryHTreeManyToOne(String objectName, final SecondaryKeyExtractor<Iterable<A>, K, V> keyExtractor, JdbmBase<K, V> b, Serializer<A> secondaryKeySerializer) throws IOException {
        HTree secIndex = null;
        long recid = b.getRecordManager().getNamedObject(objectName);
        if (recid != 0L) {
            secIndex = HTree.load(b.getRecordManager(), recid, secondaryKeySerializer, null);
        } else {
            secIndex = HTree.createInstance(b.getRecordManager(), secondaryKeySerializer, null);
            b.getRecordManager().setNamedObject(objectName, secIndex.getRecid());
        }
        final HTree secIndex2 = secIndex;
        b.addRecordListener(new RecordListener<K, V>(){

            @Override
            public void recordInserted(K key, V value) throws IOException {
                for (Object secKey : (Iterable)keyExtractor.extractSecondaryKey(key, value)) {
                    if (secKey == null) {
                        return;
                    }
                    ArrayList kk = (ArrayList)secIndex2.find(secKey);
                    if (kk == null) {
                        kk = new ArrayList();
                    }
                    kk.add(key);
                    secIndex2.put(secKey, kk);
                }
            }

            @Override
            public void recordRemoved(K key, V value) throws IOException {
                for (Object secKey : (Iterable)keyExtractor.extractSecondaryKey(key, value)) {
                    List kk = (List)secIndex2.find(secKey);
                    if (kk == null) {
                        return;
                    }
                    kk.remove(key);
                    if (kk.isEmpty()) {
                        secIndex2.remove(secKey);
                        continue;
                    }
                    secIndex2.put(secKey, kk);
                }
            }

            @Override
            public void recordUpdated(K key, V oldValue, V newValue) throws IOException {
                Iterable oldSecKey = (Iterable)keyExtractor.extractSecondaryKey(key, oldValue);
                Iterable newSecKey = (Iterable)keyExtractor.extractSecondaryKey(key, newValue);
                if (oldSecKey == null && newSecKey == null) {
                    return;
                }
                if (oldSecKey == null && newSecKey != null) {
                    this.recordInserted(key, newValue);
                    return;
                }
                if (oldSecKey != null && newSecKey == null) {
                    this.recordRemoved(key, oldValue);
                    return;
                }
                if (oldSecKey.equals(newSecKey)) {
                    return;
                }
                this.recordRemoved(key, oldValue);
                this.recordInserted(key, newValue);
            }
        });
        return secIndex;
    }

    public static <A, K, V> SecondaryHashMap<A, K, V> secondaryHashMap(String objectName, SecondaryKeyExtractor<A, K, V> secKeyExtractor, JdbmBase<K, V> b, Serializer<A> secondaryKeySerializer) {
        try {
            HTree<A, Iterable<K>> secTree = SecondaryKeyHelper.secondaryHTree(objectName, secKeyExtractor, b, secondaryKeySerializer);
            HTreeSecondaryMap<A, K, V> ret = new HTreeSecondaryMap<A, K, V>(secTree, b);
            return ret;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static <A, K, V> SecondaryTreeMap<A, K, V> secondaryTreeMap(String objectName, SecondaryKeyExtractor<A, K, V> secKeyExtractor, Comparator<A> comparator, JdbmBase<K, V> b, Serializer<A> secondaryKeySerializer) {
        try {
            BTree<A, Iterable<A>> secTree = SecondaryKeyHelper.secondaryBTree(objectName, secKeyExtractor, comparator, b);
            if (secondaryKeySerializer != null) {
                secTree.setKeySerializer(secondaryKeySerializer);
            }
            BTreeSecondarySortedMap<A, K, V> ret = new BTreeSecondarySortedMap<A, K, V>(secTree, b);
            return ret;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static <A, K, V> SecondaryHashMap<A, K, V> secondaryHashMapManyToOne(String objectName, SecondaryKeyExtractor<Iterable<A>, K, V> secKeyExtractor, JdbmBase<K, V> b, Serializer<A> secondaryKeySerializer) {
        try {
            HTree<A, Iterable<K>> secTree = SecondaryKeyHelper.secondaryHTreeManyToOne(objectName, secKeyExtractor, b, secondaryKeySerializer);
            HTreeSecondaryMap<A, K, V> ret = new HTreeSecondaryMap<A, K, V>(secTree, b);
            return ret;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static <A, K, V> SecondaryTreeMap<A, K, V> secondarySortedMapManyToOne(String objectName, SecondaryKeyExtractor<Iterable<A>, K, V> secKeyExtractor, Comparator<A> comparator, JdbmBase<K, V> b, Serializer<A> secondaryKeySerializer) {
        try {
            BTree<A, Iterable<A>> secTree = SecondaryKeyHelper.secondaryBTreeManyToOne(objectName, secKeyExtractor, comparator, b);
            if (secondaryKeySerializer != null) {
                secTree.setKeySerializer(secondaryKeySerializer);
            }
            BTreeSecondarySortedMap<A, K, V> ret = new BTreeSecondarySortedMap<A, K, V>(secTree, b);
            return ret;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static <K, V> InverseHashView<K, V> inverseHashView(JdbmBase<K, V> base, String recordName) {
        SecondaryKeyExtractor hashExtractor = new SecondaryKeyExtractor<Integer, K, V>(){
            long hashEqualsIdentityCounter = 0L;

            @Override
            public Integer extractSecondaryKey(K key, V value) {
                int identityHashCode;
                int hashCode = value.hashCode();
                if (hashCode == (identityHashCode = System.identityHashCode(value))) {
                    ++this.hashEqualsIdentityCounter;
                } else if (this.hashEqualsIdentityCounter > 0L) {
                    --this.hashEqualsIdentityCounter;
                }
                if (this.hashEqualsIdentityCounter > 50L) {
                    throw new IllegalArgumentException("Object does not implement hashCode() correctly: " + value.getClass());
                }
                return new Integer(hashCode);
            }
        };
        final SecondaryTreeMap inverseMap = SecondaryKeyHelper.secondaryTreeMap(recordName, hashExtractor, ComparableComparator.INSTANCE, base, null);
        return new InverseHashView<K, V>(){

            @Override
            public K findKeyForValue(V val) {
                Iterable keys = (Iterable)inverseMap.get(new Integer(val.hashCode()));
                if (keys == null) {
                    return null;
                }
                for (Object k : keys) {
                    if (!val.equals(inverseMap.getPrimaryValue(k))) continue;
                    return k;
                }
                return null;
            }

            @Override
            public Iterable<K> findKeysForValue(V val) {
                Iterable keys = (Iterable)inverseMap.get(new Integer(val.hashCode()));
                ArrayList ret = new ArrayList();
                if (keys == null) {
                    return null;
                }
                for (Object k : keys) {
                    if (!val.equals(inverseMap.getPrimaryValue(k))) continue;
                    ret.add(k);
                }
                return ret;
            }
        };
    }

    public static <K, V> Iterable<V> translateIterable(final JdbmBase<K, V> b, final Iterable<K> keys) {
        if (keys == null) {
            return new ArrayList();
        }
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(keys){
                    Iterator<K> iter;
                    {
                        this.iter = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        try {
                            return b.find(this.iter.next());
                        }
                        catch (IOException e) {
                            throw new Error(e);
                        }
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }
        };
    }
}

