/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jdbm.RecordManager;
import jdbm.Serializer;
import jdbm.helper.DefaultSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreReference<E> {
    private long recid = -1L;

    StoreReference() {
    }

    public StoreReference(RecordManager recman, E val, Serializer<E> serializer) {
        if (recman == null) {
            throw new IllegalArgumentException("RecordManager is null");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("Serializer is null");
        }
        if (val == null) {
            throw new IllegalArgumentException("Can not store null value");
        }
        if (val instanceof StoreReference) {
            throw new IllegalArgumentException("Can not store other reference");
        }
        try {
            this.recid = recman.insert(val, serializer);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public StoreReference(RecordManager recman, E val) {
        this(recman, val, DefaultSerializer.INSTANCE);
    }

    public E get(RecordManager recman2, Serializer<E> serializer2) {
        if (this.recid != -1L) {
            try {
                return recman2.fetch(this.recid, serializer2);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        throw new IllegalStateException("Should not be here");
    }

    public E get(RecordManager recman2) {
        return (E)this.get(recman2, DefaultSerializer.INSTANCE);
    }

    void writeExternal(DataOutputStream d) throws IOException {
        if (this.recid == -1L) {
            throw new IllegalStateException("not initialized");
        }
        d.writeLong(this.recid);
    }

    void readExternal(DataInputStream d) throws IOException {
        if (this.recid != -1L) {
            throw new IllegalStateException("already initialized");
        }
        this.recid = d.readLong();
    }

    public long getRecId() {
        return this.recid;
    }

    public void remove(RecordManager recordManager) {
        if (this.recid == -1L) {
            throw new IllegalStateException("alread removed");
        }
        try {
            recordManager.delete(this.recid);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

